/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import devplugin.Channel;
import devplugin.ChannelFilter;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import util.ui.ChannelContextMenu;
import util.ui.ChannelListCellRenderer;
import util.ui.DragAndDropMouseListener;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.UiUtilities;

public class ChannelChooserPanel
extends JPanel
implements ListDropAction {
    private DefaultListModel mChannelChooserModel;
    private JList mList;
    private MainFrame mParent;
    private boolean disableSync = false;
    private ChannelFilter mChannelFilter;

    public ChannelChooserPanel(MainFrame frame, KeyListener keyListener) {
        this.mParent = frame;
        this.mChannelChooserModel = new DefaultListModel();
        this.mList = new JList(this.mChannelChooserModel){

            @Override
            public void setSelectedIndex(int index) {
                if (this.getModel().getElementAt(index) instanceof String) {
                    int test = this.getSelectedIndex();
                    index = test < index ? ++index : --index;
                    if (index >= 0 && index < this.getModel().getSize()) {
                        this.setSelectedIndex(index);
                    }
                } else {
                    super.setSelectedIndex(index);
                }
            }
        };
        this.mList.addKeyListener(keyListener);
        this.updateChannelChooser();
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.mList);
        scrollPane.addKeyListener(keyListener);
        scrollPane.getViewport().addKeyListener(keyListener);
        scrollPane.getVerticalScrollBar().addKeyListener(keyListener);
        scrollPane.getHorizontalScrollBar().addKeyListener(keyListener);
        this.add(scrollPane);
        ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mList, this.mList, this);
        new DragAndDropMouseListener(this.mList, this.mList, this, dnDHandler);
        this.mList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!ChannelChooserPanel.this.disableSync) {
                    ChannelChooserPanel.this.showChannel();
                }
                ChannelChooserPanel.this.disableSync = false;
            }
        });
        this.mList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ChannelChooserPanel.this.showChannel();
                }
            }
        });
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ChannelChooserPanel.this.showChannel();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ChannelChooserPanel.this.mList.setSelectedIndex(ChannelChooserPanel.this.mList.locationToIndex(e.getPoint()));
                }
                ChannelChooserPanel.this.showPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ChannelChooserPanel.this.showPopupMenu(e);
            }
        });
        this.mList.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int selected = ChannelChooserPanel.this.mList.getSelectedIndex() + e.getWheelRotation();
                if (selected < 0) {
                    selected = 0;
                } else if (selected > ChannelChooserPanel.this.mList.getModel().getSize()) {
                    selected = ChannelChooserPanel.this.mList.getModel().getSize();
                }
                ChannelChooserPanel.this.mList.setSelectedIndex(selected);
                ChannelChooserPanel.this.mList.ensureIndexIsVisible(selected);
            }
        });
    }

    private void showChannel() {
        Channel selectedChannel = (Channel)this.mList.getSelectedValue();
        if (selectedChannel != null) {
            this.mParent.showChannel(selectedChannel);
        }
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            new ChannelContextMenu(e, (Channel)this.mList.getModel().getElementAt(this.mList.locationToIndex(e.getPoint())), this);
        }
    }

    public void updateChannelChooser() {
        this.mList.setCellRenderer(new ChannelListCellRenderer(Settings.propShowChannelIconsInChannellist.getBoolean(), Settings.propShowChannelNamesInChannellist.getBoolean(), false, false, true));
        this.mChannelChooserModel.removeAllElements();
        Channel[] channelList = ChannelList.getSubscribedChannels();
        String[] separatorArr = Settings.propSubscribedChannelsSeparators.getStringArray();
        Channel previousChannel = null;
        int lastSeparatorIndex = 0;
        if (channelList.length > 0) {
            this.mChannelChooserModel.addElement(channelList[0]);
            previousChannel = channelList[0];
        }
        for (int i = 1; i < channelList.length; ++i) {
            for (int j = lastSeparatorIndex; j < separatorArr.length; ++j) {
                String separator = separatorArr[j];
                if (!separator.endsWith(channelList[i].getUniqueId()) || previousChannel == null || !separator.startsWith(previousChannel.getUniqueId())) continue;
                this.mChannelChooserModel.addElement("##SEPARATOR##");
                lastSeparatorIndex = j + 1;
            }
            previousChannel = channelList[i];
            if (channelList[i - 1].getJointChannel() != null && channelList[i - 1].getJointChannel().equals(channelList[i])) continue;
            this.mChannelChooserModel.addElement(channelList[i]);
        }
    }

    @Override
    public void drop(JList source, JList target, int rows, boolean move) {
        Channel selected = (Channel)source.getSelectedValue();
        int pos = source.getSelectedIndex();
        UiUtilities.moveSelectedItems(target, rows, true);
        Channel additional = selected.getJointChannel();
        Object[] list = ((DefaultListModel)this.mList.getModel()).toArray();
        ArrayList<Channel> tempList = new ArrayList<Channel>();
        ArrayList<String> separators = new ArrayList<String>();
        String lastChannelId = "";
        for (int i = 0; i < list.length; ++i) {
            if (list[i] instanceof Channel) {
                Channel joint = ((Channel)list[i]).getJointChannel();
                if (additional != null && joint != null && additional.equals(joint)) {
                    joint = null;
                }
                if (i == pos) {
                    if (additional != null) {
                        tempList.add(additional);
                    }
                    tempList.add((Channel)list[i]);
                } else {
                    tempList.add((Channel)list[i]);
                }
                if (joint != null) {
                    tempList.add(joint);
                }
                if (lastChannelId.endsWith("##SEPARATOR##")) {
                    separators.add(lastChannelId + ";" + ((Channel)tempList.get(tempList.size() - 1)).getUniqueId());
                    lastChannelId = "";
                }
                lastChannelId = ((Channel)tempList.get(tempList.size() - 1)).getUniqueId();
                continue;
            }
            if (!(list[i] instanceof String) || lastChannelId.endsWith("##SEPARATOR##")) continue;
            lastChannelId = lastChannelId + ";##SEPARATOR##";
        }
        if (lastChannelId.endsWith("##SEPARATOR##")) {
            separators.add(lastChannelId);
        }
        Channel[] channelArr = tempList.toArray(new Channel[tempList.size()]);
        ChannelList.setSubscribeChannels(channelArr);
        Settings.propSubscribedChannels.setChannelArray(channelArr);
        Settings.propSubscribedChannelsSeparators.setStringArray(separators.toArray(new String[separators.size()]));
        if (!Settings.propTrayUseSpecialChannels.getBoolean()) {
            Channel[] tempArr = new Channel[channelArr.length > 10 ? 10 : channelArr.length];
            System.arraycopy(channelArr, 0, tempArr, 0, tempArr.length);
            Settings.propTraySpecialChannels.setChannelArray(tempArr);
        }
        ChannelList.reload();
        DefaultProgramTableModel model = MainFrame.getInstance().getProgramTableModel();
        model.setChannels(ChannelList.getSubscribedChannels());
        MainFrame.getInstance().updateChannellist();
        this.setChannelFilter(this.mChannelFilter);
    }

    public void selectChannel(Channel channel) {
        this.disableSync = true;
        this.mList.setSelectedValue(channel, true);
        this.mList.ensureIndexIsVisible(this.mList.getSelectedIndex());
    }

    public void setChannelFilter(ChannelFilter channelFilter) {
        this.mChannelFilter = channelFilter;
        Channel[] channels = null;
        if (channelFilter != null) {
            channels = channelFilter.getChannels();
        }
        ((ChannelListCellRenderer)this.mList.getCellRenderer()).setChannels(channels);
    }
}

