/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.macosx;

import java.awt.Toolkit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import tvbrowser.TVBrowser;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.MenuBar;

public class MacOSXMenuBar
extends MenuBar {
    private static final Logger LOGGER = Logger.getLogger(MacOSXMenuBar.class.getName());

    public MacOSXMenuBar(MainFrame mainFrame, JLabel label) {
        super(mainFrame, label);
        Thread toAddMenus = new Thread(){

            @Override
            public void run() {
                boolean osxMenuCreated = MacOSXMenuBar.this.createTVBrowserMenuItem();
                if (!osxMenuCreated) {
                    JMenu fileMenu = MacOSXMenuBar.this.createMenu("menu.main", "&File", true);
                    MacOSXMenuBar.this.add(fileMenu);
                    if (TVBrowser.restartEnabled()) {
                        fileMenu.add(MacOSXMenuBar.this.mRestartMI);
                    }
                    fileMenu.addSeparator();
                    fileMenu.add(MacOSXMenuBar.this.mQuitMI);
                }
                MacOSXMenuBar.this.createCommonMenus(!osxMenuCreated);
                if (MacOSXMenuBar.this.mEditMenu != null) {
                    MacOSXMenuBar.this.mEditMenu.add(MacOSXMenuBar.this.mSettingsMI);
                }
                int commandModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                MacOSXMenuBar.this.mQuitMI.setAccelerator(KeyStroke.getKeyStroke(81, commandModifier));
                MacOSXMenuBar.this.mSettingsMI.setAccelerator(KeyStroke.getKeyStroke(44, commandModifier));
                MacOSXMenuBar.this.mToolbarMI.setAccelerator(KeyStroke.getKeyStroke(84, commandModifier | 0x200));
            }
        };
        this.addAdditionalMenus(toAddMenus);
    }

    private boolean createTVBrowserMenuItem() {
        boolean menusCreated = false;
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            Method getApplication = applicationClass.getMethod("getApplication", new Class[0]);
            Method addAboutMenuItem = applicationClass.getMethod("addAboutMenuItem", new Class[0]);
            Method addPreferencesMenuItem = applicationClass.getMethod("addPreferencesMenuItem", new Class[0]);
            Method setEnabledAboutMenu = applicationClass.getMethod("setEnabledAboutMenu", Boolean.TYPE);
            Method setEnabledPreferencesMenu = applicationClass.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            Method addApplicationListener = applicationClass.getMethod("addApplicationListener", applicationListenerClass);
            Object app = getApplication.invoke(applicationClass, new Object[0]);
            addAboutMenuItem.invoke(app, new Object[0]);
            addPreferencesMenuItem.invoke(app, new Object[0]);
            setEnabledAboutMenu.invoke(app, true);
            setEnabledPreferencesMenu.invoke(app, true);
            Object applicationListener = Proxy.newProxyInstance(app.getClass().getClassLoader(), new Class[]{applicationListenerClass}, (InvocationHandler)new ApplicationListenerHandler(this));
            addApplicationListener.invoke(app, applicationListener);
            menusCreated = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "OS X specific classes not found.", e);
        }
        return menusCreated;
    }

    private static final class ApplicationListenerHandler
    implements InvocationHandler {
        private MacOSXMenuBar mMenuBar;

        public ApplicationListenerHandler(MacOSXMenuBar menuBar) {
            this.mMenuBar = menuBar;
        }

        private void handleAbout(Object event) {
            this.mMenuBar.getMainFrame().showAboutBox();
            this.setEventHandled(event);
        }

        private void handlePreferences(Object event) {
            this.mMenuBar.getMainFrame().showSettingsDialog();
            this.setEventHandled(event);
        }

        private void handleQuit(Object event) {
            this.mMenuBar.getMainFrame().quit();
        }

        private void setEventHandled(Object event) {
            try {
                Method setHandled = event.getClass().getMethod("setHandled", Boolean.TYPE);
                setHandled.invoke(event, true);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Method setHandled(boolean) for ApplicationEvent could not be called.", e);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method != null && args != null && args.length == 1) {
                if (method.getName().equals("handleAbout")) {
                    this.handleAbout(args[0]);
                } else if (method.getName().equals("handlePreferences")) {
                    this.handlePreferences(args[0]);
                } else if (method.getName().equals("handleQuit")) {
                    this.handleQuit(args[0]);
                }
            }
            return null;
        }
    }
}

