/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.pluginview.contextmenu;

import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFilter;
import devplugin.ProgramItem;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.pluginview.Node;
import tvbrowser.ui.pluginview.PluginTree;
import tvbrowser.ui.pluginview.contextmenu.ContextMenu;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.menu.MenuUtil;

public abstract class AbstractContextMenu
implements ContextMenu {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(AbstractContextMenu.class);
    private PluginTree mTree;

    protected AbstractContextMenu(PluginTree tree) {
        this.mTree = tree;
    }

    protected JMenuItem getExpandAllMenuItem(final TreePath treePath) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractContextMenu.this.mTree.expandAll(treePath);
            }
        };
        action.putValue("Name", mLocalizer.msg("expandAll", "Expand All"));
        JMenuItem item = new JMenuItem(action);
        item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
        return item;
    }

    protected JMenuItem getCollapseAllMenuItem(final TreePath treePath) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractContextMenu.this.mTree.collapseAll(treePath);
            }
        };
        action.putValue("Name", mLocalizer.msg("collapseAll", "Collapse All"));
        JMenuItem item = new JMenuItem(action);
        item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
        return item;
    }

    protected Action getCollapseExpandAction(final TreePath treePath) {
        final boolean mIsExpanded = this.mTree.isExpanded(treePath);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (mIsExpanded) {
                    AbstractContextMenu.this.mTree.collapsePath(treePath);
                } else {
                    AbstractContextMenu.this.mTree.expandPath(treePath);
                }
            }
        };
        if (mIsExpanded) {
            action.putValue("Name", mLocalizer.msg("collapse", "collapse"));
        } else {
            action.putValue("Name", mLocalizer.msg("expand", "expand"));
        }
        return action;
    }

    protected JMenu getExportMenu(TreePath paths) {
        PluginProxy[] plugins;
        JMenuItem item;
        final Node node = (Node)paths.getLastPathComponent();
        JMenu menu = new JMenu(mLocalizer.msg("export", "Export"));
        menu.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
        if (node.getChildCount() == 0 && node.getType() != 2) {
            menu.setEnabled(false);
            return menu;
        }
        Object o = this.getObjectForNode(node);
        Plugin currentPlugin = null;
        if (o instanceof Plugin) {
            currentPlugin = (Plugin)o;
        }
        for (InternalPluginProxyIf internalProxy : InternalPluginProxyList.getInstance().getAvailableProxys()) {
            ProgramReceiveIf receiveProxy;
            if (!(internalProxy instanceof ProgramReceiveIf) || !(receiveProxy = (ProgramReceiveIf)((Object)internalProxy)).canReceiveProgramsWithTarget() || o == internalProxy) continue;
            final ProgramReceiveTarget target = receiveProxy.getProgramReceiveTargets()[0];
            item = new JMenuItem(target.getTargetName());
            item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
            item.setIcon(internalProxy.getIcon());
            menu.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Program[] programs = AbstractContextMenu.this.collectProgramsFromNode(node);
                    if (programs != null && programs.length > 0) {
                        receiveProxy.receivePrograms(programs, target);
                    }
                }
            });
        }
        for (final PluginProxy plugin : plugins = PluginProxyManager.getInstance().getActivatedPlugins()) {
            Icon icon;
            if (!plugin.canReceiveProgramsWithTarget() || plugin.getProgramReceiveTargets() == null || plugin.getProgramReceiveTargets().length <= 0 || currentPlugin != null && currentPlugin.getId().equals(plugin.getId())) continue;
            ProgramReceiveTarget[] targets = plugin.getProgramReceiveTargets();
            if (!plugin.canReceiveProgramsWithTarget()) {
                item = new JMenuItem(plugin.getInfo().getName());
                item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
                icon = plugin.getPluginIcon();
                item.setIcon(icon != null ? icon : null);
                menu.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Program[] programs = AbstractContextMenu.this.collectProgramsFromNode(node);
                        if (programs != null && programs.length > 0) {
                            plugin.receivePrograms(programs, ProgramReceiveTarget.createDefaultTargetForProgramReceiveIfId(plugin.getId()));
                        }
                    }
                });
                continue;
            }
            if (!(targets.length != 1 || o instanceof ProgramReceiveTarget && o.equals(targets[0]))) {
                item = new JMenuItem(targets[0].toString());
                item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
                icon = plugin.getPluginIcon();
                item.setIcon(icon != null ? icon : null);
                menu.add(item);
                final ProgramReceiveTarget target = targets[0];
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Program[] programs = AbstractContextMenu.this.collectProgramsFromNode(node);
                        if (programs != null && programs.length > 0) {
                            plugin.receivePrograms(programs, target);
                        }
                    }
                });
                continue;
            }
            if (targets.length < 1) continue;
            JMenu subMenu = new JMenu(plugin.getInfo().getName());
            subMenu.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
            icon = plugin.getPluginIcon();
            subMenu.setIcon(icon != null ? icon : null);
            menu.add(subMenu);
            for (final ProgramReceiveTarget target : targets) {
                if (o != null && o.equals(target)) continue;
                JMenuItem item2 = new JMenuItem(target.toString());
                item2.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
                subMenu.add(item2);
                item2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Program[] programs = AbstractContextMenu.this.collectProgramsFromNode(node);
                        if (programs != null && programs.length > 0) {
                            plugin.receivePrograms(programs, target);
                        }
                    }
                });
            }
        }
        return menu;
    }

    protected JMenuItem getFilterMenuItem(TreePath treePath) {
        final Node node = (Node)treePath.getLastPathComponent();
        StringBuilder pathName = new StringBuilder();
        for (int i = 1; i < treePath.getPathCount(); ++i) {
            if (i > 1) {
                pathName.append("/");
            }
            pathName.append(treePath.getPathComponent(i));
        }
        final String filterName = mLocalizer.msg("pluginFilter.name", "Plugin filter ({0})", pathName.toString());
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Program[] programs = AbstractContextMenu.this.collectProgramsFromNode(node);
                final ArrayList<Program> programList = new ArrayList<Program>();
                if (programs != null) {
                    for (Program program : programs) {
                        programList.add(program);
                    }
                    if (programs.length > 0) {
                        ProgramFilter pluginFilter = new ProgramFilter(){

                            @Override
                            public boolean accept(Program prog) {
                                return programList.contains(prog);
                            }

                            @Override
                            public String getName() {
                                return filterName;
                            }
                        };
                        MainFrame.getInstance().setProgramFilter(pluginFilter);
                    } else {
                        JOptionPane.showMessageDialog(UiUtilities.getBestDialogParent(MainFrame.getInstance()), mLocalizer.msg("pluginFilter.noPrograms", "The plugin has marked no program, therefore your current filter will remain active."), mLocalizer.msg("pluginFilter.noProgramsTitle", "No programs marked"), 1);
                    }
                }
            }
        };
        action.putValue("Name", mLocalizer.msg("filter", "Show only contained programs"));
        JMenuItem item = new JMenuItem(action);
        item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
        item.setIcon(TVBrowserIcons.filter(16));
        return item;
    }

    public Object getObjectForNode(Node node) {
        Node parent;
        for (parent = node; parent != null && parent.getType() != 1 && parent != ReminderPlugin.getRootNode().getMutableTreeNode() && parent != FavoritesPlugin.getInstance().getRootNode().getMutableTreeNode() && parent.getProgramReceiveTarget() == null; parent = (Node)parent.getParent()) {
        }
        if (parent != null) {
            if (parent.getProgramReceiveTarget() != null) {
                return parent.getProgramReceiveTarget();
            }
            Object o = parent.getUserObject();
            if (o instanceof Plugin) {
                return o;
            }
            if (o instanceof String && o.equals(ReminderPlugin.getRootNode().getMutableTreeNode().getUserObject())) {
                return ReminderPluginProxy.getInstance();
            }
            if (o instanceof String && o.equals(FavoritesPlugin.getInstance().getRootNode().getMutableTreeNode().getUserObject())) {
                return FavoritesPluginProxy.getInstance();
            }
            return parent;
        }
        return null;
    }

    public Program[] collectProgramsFromNode(Node node) {
        if (node.getType() == 2) {
            return new Program[]{((ProgramItem)node.getUserObject()).getProgram()};
        }
        if (node.getChildCount() == 0) {
            return null;
        }
        ArrayList<Program> array = new ArrayList<Program>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Program[] programs = this.collectProgramsFromNode((Node)node.getChildAt(i));
            if (programs == null || programs.length == 0) continue;
            for (Program prg : programs) {
                if (array.contains(prg)) continue;
                array.add(prg);
            }
        }
        return array.toArray(new Program[array.size()]);
    }
}

