/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Channel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import util.browserlauncher.Launch;
import util.ui.ChannelContextMenu;
import util.ui.ChannelLabel;
import util.ui.ImageUtilities;
import util.ui.ToolTipWithIcon;
import util.ui.persona.Persona;

public class ProgramTableChannelLabel
extends ChannelLabel {
    private static Cursor linkCursor = new Cursor(12);
    private static Font channelNameFont;
    private Channel mChannel;
    private boolean mIsRollover;

    public ProgramTableChannelLabel(Channel ch, KeyListener keyListener) {
        super(Settings.propShowChannelIconsInProgramTable.getBoolean(), Settings.propShowChannelNamesInProgramTable.getBoolean(), false, false, true, false, Settings.propShowSortNumberInProgramTable.getBoolean());
        this.mChannel = ch;
        this.addKeyListener(keyListener);
        this.updatePersona();
        this.setChannel(this.mChannel);
        this.setToolTipText("");
        if (channelNameFont == null) {
            ProgramTableChannelLabel.fontChanged();
        }
        if (channelNameFont != null) {
            this.setFont(channelNameFont);
        }
        this.mIsRollover = false;
        this.setOpaque(false);
        this.setHorizontalAlignment(0);
        this.setCursor(linkCursor);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProgramTableChannelLabel.this.showPopUp(e);
                } else if (e.getButton() == 1) {
                    Launch.openURL(ProgramTableChannelLabel.this.mChannel.getWebpage());
                }
                super.mouseReleased(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProgramTableChannelLabel.this.showPopUp(e);
                }
                super.mouseReleased(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ProgramTableChannelLabel.this.mIsRollover = true;
                int r = ProgramTableChannelLabel.this.getForeground().getRed() + ProgramTableChannelLabel.this.getBackground().getRed() >> 1;
                int g = ProgramTableChannelLabel.this.getForeground().getGreen() + ProgramTableChannelLabel.this.getBackground().getGreen() >> 1;
                int b = ProgramTableChannelLabel.this.getForeground().getBlue() + ProgramTableChannelLabel.this.getBackground().getBlue() >> 1;
                e.getComponent().setForeground(new Color(r, g, b));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ProgramTableChannelLabel.this.mIsRollover = false;
                e.getComponent().setForeground(UIManager.getColor("List.selectionForeground"));
            }
        });
    }

    private void showPopUp(MouseEvent e) {
        new ChannelContextMenu(e, this.mChannel, this);
    }

    public static void fontChanged() {
        boolean useDefaults = Settings.propUseDefaultFonts.getBoolean();
        channelNameFont = useDefaults ? Settings.propChannelNameFont.getDefault() : Settings.propChannelNameFont.getFont();
    }

    @Override
    public JToolTip createToolTip() {
        Icon shownIcon;
        Icon channelIcon;
        if (!Settings.propShowChannelTooltipInProgramTable.getBoolean()) {
            return new ToolTipWithIcon(null, null);
        }
        boolean showIcon = false;
        boolean showText = false;
        Icon icon = channelIcon = this.mChannel.getJointChannel() != null ? ImageUtilities.createImageIcon(this.mChannel.getJointChannelIcon(), Color.WHITE, 4) : this.mChannel.getIcon();
        if (channelIcon != null && channelIcon instanceof ImageIcon && (shownIcon = this.getIcon()) != null && (channelIcon.getIconHeight() > shownIcon.getIconHeight() || channelIcon.getIconWidth() > shownIcon.getIconWidth())) {
            showIcon = true;
        }
        ToolTipWithIcon tip = showIcon ? new ToolTipWithIcon((ImageIcon)channelIcon) : new ToolTipWithIcon((ImageIcon)null);
        tip.setBackground(Color.WHITE);
        tip.setComponent(this);
        String text = null;
        if (showText) {
            text = this.mChannel.getName();
        }
        tip.setTipText(text);
        return tip;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int stringWidth = SwingUtilities.computeStringWidth(metrics, this.getText());
        int x = 0;
        Icon icon = this.mChannel.getJointChannel() != null ? this.mChannel.getJointChannelIcon() : this.getIcon();
        Icon channelIcon = this.mChannel.getJointChannel() != null ? this.mChannel.getJointChannelIcon() : this.mChannel.getIcon();
        int iconWidth = icon.getIconWidth();
        if (channelIcon != null) {
            iconWidth = channelIcon.getIconWidth();
        }
        int iconHeight = icon.getIconHeight();
        if (channelIcon != null) {
            iconHeight = channelIcon.getIconHeight();
        }
        if (icon != null) {
            x = (this.getWidth() - stringWidth - this.getIconTextGap() - icon.getIconWidth()) / 2;
            if (x < 0) {
                x = 0;
            }
            x += (icon.getIconWidth() - iconWidth) / 2;
        }
        int y = (this.getHeight() - iconHeight - 2) / 2;
        return new Point(x, y);
    }

    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null) {
            this.setForeground(Persona.getInstance().getTextColor());
        } else {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
            Color c = Persona.getInstance().getAccentColor();
            double test = 0.2126 * (double)Persona.getInstance().getTextColor().getRed() + 0.7152 * (double)Persona.getInstance().getTextColor().getGreen() + 0.0722 * (double)Persona.getInstance().getTextColor().getBlue();
            int alpha = 100;
            if (test <= 30.0) {
                c = Color.white;
                alpha = 200;
            } else if (test <= 40.0) {
                c = c.brighter().brighter().brighter().brighter().brighter().brighter();
                alpha = 200;
            } else if (test <= 60.0) {
                c = c.brighter().brighter().brighter();
                alpha = 160;
            } else if (test <= 100.0) {
                c = c.brighter().brighter();
                alpha = 140;
            } else if (test <= 145.0) {
                alpha = 120;
            } else if (test <= 170.0) {
                c = c.darker();
                alpha = 120;
            } else if (test <= 205.0) {
                c = c.darker().darker();
                alpha = 120;
            } else if (test <= 220.0) {
                c = c.darker().darker().darker();
                alpha = 100;
            } else if (test <= 235.0) {
                c = c.darker().darker().darker().darker();
                alpha = 100;
            } else {
                c = Color.black;
                alpha = 100;
            }
            Color textColor = Persona.getInstance().getTextColor();
            if (this.mIsRollover) {
                c = UIManager.getColor("List.selectionBackground");
                double test1 = 0.2126 * (double)c.getRed() + 0.7152 * (double)c.getGreen() + 0.0722 * (double)c.getBlue();
                double test2 = 0.2126 * (double)textColor.getRed() + 0.7152 * (double)textColor.getGreen() + 0.0722 * (double)textColor.getBlue();
                if (Math.abs(test2 - test1) <= 40.0) {
                    textColor = UIManager.getColor("List.selectionForeground");
                }
            }
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int iconX = this.getWidth() / 2;
            int iconY = this.getHeight() / 2;
            int iconWidth = 0;
            int iconTextGap = 0;
            FontMetrics metrics = g.getFontMetrics(this.getFont());
            String text = this.getText();
            int textWidth = metrics.stringWidth(text);
            int baseLine = this.getHeight() / 2 + metrics.getMaxDescent() + 1;
            Icon icon = this.getIcon();
            int iconTextLength = iconWidth + this.getIconTextGap() + textWidth;
            if (icon != null) {
                iconWidth = icon.getIconWidth();
                iconTextGap = this.getIconTextGap();
                iconTextLength += iconWidth;
            }
            while ((double)iconTextLength > this.getSize().getWidth()) {
                text = text.substring(0, text.length() - 4) + "...";
                iconTextLength = metrics.stringWidth(text) + iconWidth + this.getIconTextGap();
            }
            if (icon != null) {
                icon.paintIcon(this, g, iconX -= iconTextLength / 2, iconY -= icon.getIconHeight() / 2);
            } else {
                iconX -= textWidth / 2;
            }
            if (!Persona.getInstance().getShadowColor().equals(textColor) && Persona.getInstance().getTextColor().equals(textColor)) {
                g.setColor(Persona.getInstance().getShadowColor());
                g.drawString(text, iconX + iconWidth + iconTextGap + 1, baseLine + 1);
            }
            g.setColor(textColor);
            g.drawString(text, iconX + iconWidth + iconTextGap, baseLine);
        } else {
            super.paintComponent(g);
        }
    }
}

