/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Channel;
import devplugin.ContextMenuIf;
import devplugin.Program;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ChannelPanel;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import tvbrowser.ui.programtable.ProgramTable;
import tvbrowser.ui.programtable.ProgramTableModel;
import tvbrowser.ui.programtable.ProgramTableModelListener;
import tvbrowser.ui.programtable.background.BackgroundPainter;
import util.ui.persona.Persona;

public class ProgramTableScrollPane
extends JScrollPane
implements ProgramTableModelListener,
MouseWheelListener,
ChangeListener {
    private static final double SCROLL_OFFSET_FROM_TOP = 0.25;
    private ProgramTable mProgramTable;
    private ChannelPanel mChannelPanel;
    private boolean initialScrollingDone = false;
    private int mScrolledTime = -1;
    private KeyListener mKeyListener;
    private long mLastScrollTime;

    public ProgramTableScrollPane(ProgramTableModel model, KeyListener keyListener) {
        this.setFocusable(true);
        this.mKeyListener = keyListener;
        this.mProgramTable = new ProgramTable(model, keyListener);
        this.setViewportView(this.mProgramTable);
        this.getViewport().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.setWheelScrollingEnabled(false);
        this.addMouseWheelListener(this);
        this.getHorizontalScrollBar().setUnitIncrement(Settings.propColumnWidth.getInt());
        this.getVerticalScrollBar().setUnitIncrement(50);
        this.getHorizontalScrollBar().setFocusable(false);
        this.getVerticalScrollBar().setFocusable(false);
        this.mChannelPanel = new ChannelPanel(this.mProgramTable.getColumnWidth(), model.getShownChannels(), keyListener);
        JPanel dummy = new JPanel();
        dummy.setOpaque(false);
        this.setRowHeaderView(dummy);
        this.getRowHeader().setOpaque(false);
        this.setColumnHeaderView(this.mChannelPanel);
        this.getColumnHeader().setOpaque(false);
        this.getViewport().setOpaque(false);
        this.setOpaque(false);
        JPanel leftUpper = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getAccentColor() != null && Persona.getInstance().getHeaderImage() != null) {
                    ProgramTableScrollPane.this.paintComponentInternal(g);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        JPanel rightUpper = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getAccentColor() != null && Persona.getInstance().getHeaderImage() != null) {
                    ProgramTableScrollPane.this.paintComponentInternal(g);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        this.setCorner("UPPER_LEFT_CORNER", leftUpper);
        this.setCorner("UPPER_RIGHT_CORNER", rightUpper);
        model.addProgramTableModelListener(this);
        this.mProgramTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("backgroundpainter")) {
                    BackgroundPainter painter = (BackgroundPainter)evt.getNewValue();
                    ProgramTableScrollPane.this.handleBackgroundPainterChanged(painter);
                }
            }
        });
        this.handleBackgroundPainterChanged(this.mProgramTable.getBackgroundPainter());
        this.getViewport().addChangeListener(this);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ProgramTableScrollPane.this.updateScrollBars();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ProgramTableScrollPane.this.resetScrolledTime();
            }
        });
        this.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProgramTableScrollPane.this.requestFocus();
            }
        });
        this.getHorizontalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProgramTableScrollPane.this.requestFocus();
            }
        });
    }

    private void paintComponentInternal(Graphics g) {
        Color c = Persona.getInstance().getAccentColor().darker().darker().darker();
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 110));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        c = Persona.getInstance().getAccentColor();
        double test = 0.2126 * (double)Persona.getInstance().getTextColor().getRed() + 0.7152 * (double)Persona.getInstance().getTextColor().getGreen() + 0.0722 * (double)Persona.getInstance().getTextColor().getBlue();
        int alpha = 100;
        if (test <= 30.0) {
            c = Color.white;
            alpha = 200;
        } else if (test <= 40.0) {
            c = c.brighter().brighter().brighter().brighter().brighter().brighter();
            alpha = 200;
        } else if (test <= 60.0) {
            c = c.brighter().brighter().brighter();
            alpha = 160;
        } else if (test <= 100.0) {
            c = c.brighter().brighter();
            alpha = 140;
        } else if (test <= 145.0) {
            alpha = 120;
        } else if (test <= 170.0) {
            c = c.darker();
            alpha = 120;
        } else if (test <= 205.0) {
            c = c.darker().darker();
            alpha = 120;
        } else if (test <= 220.0) {
            c = c.darker().darker().darker();
            alpha = 100;
        } else if (test <= 235.0) {
            c = c.darker().darker().darker().darker();
            alpha = 100;
        } else {
            c = Color.black;
            alpha = 100;
        }
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public ProgramTable getProgramTable() {
        return this.mProgramTable;
    }

    public void forceRepaintAll() {
        this.getProgramTable().forceRepaintAll();
        this.tableDataChanged(null);
        this.getProgramTable().tableDataChanged(null);
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.mProgramTable != null) {
            this.mProgramTable.repaint();
        }
        if (this.mChannelPanel != null) {
            this.mChannelPanel.repaint();
        }
    }

    public void updateChannelPanel() {
        this.mChannelPanel = new ChannelPanel(this.mProgramTable.getColumnWidth(), this.mProgramTable.getModel().getShownChannels(), this.mKeyListener);
        this.setColumnHeaderView(this.mChannelPanel);
        this.repaint();
    }

    public void updateChannelLabelForChannel(Channel ch) {
        this.mChannelPanel.updateChannelLabelForChannel(ch);
        ((DefaultProgramTableModel)this.mProgramTable.getModel()).setChannels(ChannelList.getSubscribedChannels());
    }

    public void setColumnWidth(int columnWidth) {
        this.mProgramTable.setColumnWidth(columnWidth);
        this.mChannelPanel.setColumnWidth(columnWidth);
        this.getHorizontalScrollBar().setUnitIncrement(columnWidth);
        this.updateScrollBars();
    }

    public void scrollToChannel(Channel channel) {
        if (this.getHorizontalScrollBar().isVisible()) {
            channel = Channel.getChannelForChannel(channel);
            Channel[] shownChannelArr = this.mProgramTable.getModel().getShownChannels();
            for (int col = 0; col < shownChannelArr.length; ++col) {
                int max;
                Point scrollPos;
                if (!channel.equals(shownChannelArr[col]) || (scrollPos = this.getViewport().getViewPosition()) == null) continue;
                int visibleColumns = this.getViewport().getWidth() / this.mProgramTable.getColumnWidth();
                scrollPos.x = (col - visibleColumns / 2) * this.mProgramTable.getColumnWidth();
                if (scrollPos.x < 0) {
                    scrollPos.x = 0;
                }
                if (scrollPos.x > (max = this.mProgramTable.getWidth() - this.getViewport().getWidth())) {
                    scrollPos.x = max;
                }
                this.getViewport().setViewPosition(scrollPos);
            }
        }
    }

    public void scrollToTime(int minutesAfterMidnight) {
        int max;
        Point scrollPos = this.getViewport().getViewPosition();
        scrollPos.y = this.mProgramTable.getTimeY(minutesAfterMidnight) - (int)Math.round((double)this.getViewport().getHeight() * 0.25);
        if (scrollPos.y < 0) {
            scrollPos.y = 0;
        }
        if (scrollPos.y > (max = Math.max(0, this.mProgramTable.getHeight() - this.getViewport().getHeight()))) {
            scrollPos.y = max;
        }
        this.getViewport().setViewPosition(scrollPos);
        this.mScrolledTime = minutesAfterMidnight;
    }

    protected void handleBackgroundPainterChanged(BackgroundPainter painter) {
        this.setRowHeaderView(painter.getTableWest());
    }

    @Override
    public void tableDataChanged(Runnable callback) {
        this.mChannelPanel.setShownChannels(this.mProgramTable.getModel().getShownChannels(), this.mKeyListener);
        if (Settings.propTableBackgroundStyle.getString().equals("timeBlock") && Settings.propTimeBlockShowWest.getBoolean()) {
            this.getRowHeader().getView().repaint();
        }
        if (callback != null) {
            callback.run();
        }
    }

    @Override
    public void tableCellUpdated(int col, int row) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (Settings.propProgramTableAutoChangeDate.getBoolean() && (this.getVerticalScrollBar().getValue() + this.getVerticalScrollBar().getVisibleAmount() >= this.getVerticalScrollBar().getMaximum() || this.getVerticalScrollBar().getValue() == this.getVerticalScrollBar().getMinimum())) {
            if (System.currentTimeMillis() - this.mLastScrollTime <= 500L && System.currentTimeMillis() - this.mLastScrollTime >= 200L) {
                if (e.getWheelRotation() < 0) {
                    MainFrame.getInstance().goToPreviousDay(new Runnable(){

                        @Override
                        public void run() {
                            ProgramTableScrollPane.this.getVerticalScrollBar().setValue(ProgramTableScrollPane.this.getVerticalScrollBar().getMaximum());
                        }
                    });
                } else {
                    MainFrame.getInstance().goToNextDay(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.getInstance().scrollToTime(Settings.propProgramTableEndOfDay.getInt(), false);
                        }
                    });
                }
                e.consume();
                return;
            }
            if (System.currentTimeMillis() - this.mLastScrollTime > 500L) {
                this.mLastScrollTime = System.currentTimeMillis();
            }
        }
        JScrollBar scrollBar = null;
        int amount = 0;
        scrollBar = (e.getModifiersEx() & 0x40) != 0 || this.getComponentAt(e.getPoint()).equals(this.getColumnHeader()) || this.getComponentAt(e.getPoint()).equals(this.getHorizontalScrollBar()) ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (scrollBar != null) {
            if (e.getScrollType() == 0) {
                amount = e.getUnitsToScroll() * scrollBar.getUnitIncrement();
            } else if (e.getScrollType() == 1) {
                amount = e.getWheelRotation() * scrollBar.getBlockIncrement(1);
            }
            if (amount != 0) {
                scrollBar.setValue(scrollBar.getValue() + amount);
            }
        }
    }

    public void right() {
        this.mProgramTable.right();
    }

    public void up() {
        this.mProgramTable.up();
    }

    public void down() {
        this.mProgramTable.down();
    }

    public void left() {
        this.mProgramTable.left();
    }

    public void closePopupMenuIfVisible() {
        this.mProgramTable.closePopupMenuIfVisible();
    }

    public void togglePopupMenu() {
        this.mProgramTable.togglePopupFromKeyboard();
    }

    public void handleKeyboardAction(ContextMenuIf action) {
        this.mProgramTable.handleKeyboardAction(action);
    }

    public Program deSelectItem(boolean getProgram) {
        return this.mProgramTable.deSelectItem(getProgram);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Point viewPos;
        if (e.getSource() == this.viewport && (viewPos = this.viewport.getViewPosition()) != null) {
            Channel[] shownChannels = MainFrame.getInstance().getProgramTableModel().getShownChannels();
            if (shownChannels.length == 0) {
                return;
            }
            int columnIndex = (viewPos.x + this.viewport.getWidth() / 2) / this.mProgramTable.getColumnWidth();
            if (columnIndex >= shownChannels.length) {
                columnIndex = shownChannels.length - 1;
            }
            MainFrame.getInstance().selectChannel(shownChannels[columnIndex]);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this.initialScrollingDone) {
            this.initialScrollingDone = true;
            Calendar cal = Calendar.getInstance();
            int hour = cal.get(11);
            this.scrollToTime(hour * 60);
            this.updateScrollBars();
        }
    }

    private void updateScrollBars() {
        int columnWidth = this.mProgramTable.getColumnWidth();
        this.getHorizontalScrollBar().setBlockIncrement(this.getFullColumns() * columnWidth);
    }

    private int getFullColumns() {
        int columnWidth = this.mProgramTable.getColumnWidth();
        int fullColumns = (this.getViewport().getWidth() + 8) / columnWidth;
        if (fullColumns < 1) {
            return 1;
        }
        return fullColumns;
    }

    public int getScrolledTime() {
        return this.mScrolledTime;
    }

    public void resetScrolledTime() {
        this.mScrolledTime = -1;
    }

    public void scrollPageRight() {
        this.scrollPageHorizontal(1);
    }

    public void scrollPageLeft() {
        this.scrollPageHorizontal(-1);
    }

    private void scrollPageHorizontal(int direction) {
        int max;
        JScrollBar scrollBar = this.getHorizontalScrollBar();
        int pos = scrollBar.getValue() + direction * this.getFullColumns() * this.mProgramTable.getColumnWidth();
        if (pos > (max = scrollBar.getMaximum() - scrollBar.getVisibleAmount())) {
            pos = max;
        }
        if (pos < 0) {
            pos = 0;
        }
        scrollBar.setValue(pos);
    }

    public void updatePersona() {
        this.mChannelPanel.updatePersona();
    }
}

