/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable.background;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import tvbrowser.ui.programtable.ProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import tvbrowser.ui.programtable.background.BackgroundPainter;

public abstract class AbstractBackPainter
implements BackgroundPainter {
    @Override
    public void layoutChanged(ProgramTableLayout layout, ProgramTableModel model) {
    }

    protected void fillImage(Graphics grp, int x, int y, int width, int height, Image img, Rectangle clipBounds) {
        if (img == null) {
            grp.setColor(Color.WHITE);
            grp.fillRect(x, y, width, height);
        } else {
            if (!clipBounds.intersects(x, y, width, height)) {
                return;
            }
            int imgWidth = img.getWidth(null);
            int imgHeight = img.getHeight(null);
            if (imgWidth < 1 || imgHeight < 1) {
                return;
            }
            int minY = Math.max(y, clipBounds.y - (clipBounds.y - y) % imgHeight);
            int maxY = Math.min(y + height, clipBounds.y + clipBounds.height);
            for (int py = minY; py < maxY; py += imgHeight) {
                grp.drawImage(img, x, py, null);
            }
        }
    }

    @Override
    public JComponent getTableWest() {
        return null;
    }
}

