/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import util.ui.FontChooserPanel;
import util.ui.Localizer;

public class FontsSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FontsSettingsTab.class);
    private JCheckBox mUseDefaultFontsCB;
    private JCheckBox mEnableAntialiasingCB;
    private FontChooserPanel mTitleFontPanel;
    private FontChooserPanel mInfoFontPanel;
    private FontChooserPanel mChannelNameFontPanel;
    private FontChooserPanel mTimeFontPanel;
    private JLabel mTimeFontLabel;
    private JLabel mChannelNameFontLabel;
    private JLabel mInfoFontLabel;
    private JLabel mTitleFontLabel;

    @Override
    public JPanel createSettingsPanel() {
        PanelBuilder mainPanel = new PanelBuilder(new FormLayout("5dlu, 10dlu, pref, 3dlu, pref, fill:3dlu:grow", "pref, 5dlu, pref, 10dlu, pref, 5dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref"));
        mainPanel.border(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        mainPanel.addSeparator(mLocalizer.msg("Fonts", "Fonts"), cc.xyw(1, 1, 6));
        this.mEnableAntialiasingCB = new JCheckBox(mLocalizer.msg("EnableAntialiasing", "Enable antialiasing"));
        this.mEnableAntialiasingCB.setSelected(Settings.propEnableAntialiasing.getBoolean());
        mainPanel.add((Component)this.mEnableAntialiasingCB, cc.xyw(2, 3, 4));
        mainPanel.addSeparator(mLocalizer.msg("UserDefinedFonts", "Userdefined Fonts"), cc.xyw(1, 5, 6));
        this.mUseDefaultFontsCB = new JCheckBox(mLocalizer.msg("UseDefaultFonts", "Use default fonts"));
        this.mUseDefaultFontsCB.setSelected(Settings.propUseDefaultFonts.getBoolean());
        mainPanel.add((Component)this.mUseDefaultFontsCB, cc.xyw(2, 7, 4));
        this.mTitleFontLabel = new JLabel(mLocalizer.msg("ProgramTitle", "Program title"));
        mainPanel.add((Component)this.mTitleFontLabel, cc.xy(3, 9));
        this.mTitleFontPanel = new FontChooserPanel(Settings.propProgramTitleFont.getFont());
        mainPanel.add((Component)this.mTitleFontPanel, cc.xy(5, 9));
        this.mInfoFontLabel = new JLabel(mLocalizer.msg("ProgramInfo", "Program information"));
        mainPanel.add((Component)this.mInfoFontLabel, cc.xy(3, 11));
        this.mInfoFontPanel = new FontChooserPanel(Settings.propProgramInfoFont.getFont());
        mainPanel.add((Component)this.mInfoFontPanel, cc.xy(5, 11));
        this.mChannelNameFontLabel = new JLabel(mLocalizer.msg("ChannelNames", "Channel name"));
        mainPanel.add((Component)this.mChannelNameFontLabel, cc.xy(3, 13));
        this.mChannelNameFontPanel = new FontChooserPanel(Settings.propChannelNameFont.getFont());
        mainPanel.add((Component)this.mChannelNameFontPanel, cc.xy(5, 13));
        this.mTimeFontLabel = new JLabel(mLocalizer.msg("Time", "Time"));
        mainPanel.add((Component)this.mTimeFontLabel, cc.xy(3, 15));
        this.mTimeFontPanel = new FontChooserPanel(Settings.propProgramTimeFont.getFont());
        mainPanel.add((Component)this.mTimeFontPanel, cc.xy(5, 15));
        this.mUseDefaultFontsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontsSettingsTab.this.enableFontFields(!FontsSettingsTab.this.mUseDefaultFontsCB.isSelected());
            }
        });
        this.enableFontFields(!this.mUseDefaultFontsCB.isSelected());
        return mainPanel.getPanel();
    }

    private void enableFontFields(boolean enable) {
        this.mTitleFontLabel.setEnabled(enable);
        this.mTitleFontPanel.setEnabled(enable);
        this.mInfoFontLabel.setEnabled(enable);
        this.mInfoFontPanel.setEnabled(enable);
        this.mChannelNameFontLabel.setEnabled(enable);
        this.mChannelNameFontPanel.setEnabled(enable);
        this.mTimeFontLabel.setEnabled(enable);
        this.mTimeFontPanel.setEnabled(enable);
    }

    @Override
    public void saveSettings() {
        Settings.propProgramTitleFont.setFont(this.mTitleFontPanel.getChosenFont());
        Settings.propProgramInfoFont.setFont(this.mInfoFontPanel.getChosenFont());
        Settings.propChannelNameFont.setFont(this.mChannelNameFontPanel.getChosenFont());
        Settings.propProgramTimeFont.setFont(this.mTimeFontPanel.getChosenFont());
        Settings.propUseDefaultFonts.setBoolean(this.mUseDefaultFontsCB.isSelected());
        Settings.propEnableAntialiasing.setBoolean(this.mEnableAntialiasingCB.isSelected());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-font", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("Fonts", "Fonts");
    }
}

