/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.CancelableSettingsTab;
import devplugin.InfoIf;
import devplugin.PluginInfo;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tvbrowser.TVBrowser;
import tvbrowser.core.ChannelList;
import tvbrowser.core.PluginAndDataServiceComparator;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.ButtonsSettingsTab;
import tvbrowser.ui.settings.CenterPanelSettingsTab;
import tvbrowser.ui.settings.ChannelIconAndNameSettingsTab;
import tvbrowser.ui.settings.ChannelsSettingsTab;
import tvbrowser.ui.settings.ConfigDataServiceSettingsTab;
import tvbrowser.ui.settings.ConfigPluginSettingsTab;
import tvbrowser.ui.settings.ContextmenuSettingsTab;
import tvbrowser.ui.settings.DataPluginPostProcessingOrderSettingsTab;
import tvbrowser.ui.settings.DirectoriesSettingsTab;
import tvbrowser.ui.settings.FontsSettingsTab;
import tvbrowser.ui.settings.GenericPluginFilterSettingsTab;
import tvbrowser.ui.settings.GlobalPluginProgramFormatingSettings;
import tvbrowser.ui.settings.LocaleSettingsTab;
import tvbrowser.ui.settings.LookAndFeelSettingsTab;
import tvbrowser.ui.settings.MarkingsSettingsTab;
import tvbrowser.ui.settings.MouseSettingsTab;
import tvbrowser.ui.settings.NetworkSettingsTab;
import tvbrowser.ui.settings.PictureSettingsTab;
import tvbrowser.ui.settings.PluginSettingsTab;
import tvbrowser.ui.settings.ProgramPanelSettingsTab;
import tvbrowser.ui.settings.ProgramTableSettingsTab;
import tvbrowser.ui.settings.ProxySettingsTab;
import tvbrowser.ui.settings.StartupSettingsTab;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import tvbrowser.ui.settings.TrayImportantSettingsTab;
import tvbrowser.ui.settings.TrayNowSettingsTab;
import tvbrowser.ui.settings.TrayOnTimeSettingsTab;
import tvbrowser.ui.settings.TrayProgramsChannelsSettingsTab;
import tvbrowser.ui.settings.TraySoonSettingsTab;
import tvbrowser.ui.settings.WebbrowserSettingsTab;
import tvbrowser.ui.waiting.dlgs.SettingsWaitingDialog;
import util.browserlauncher.Launch;
import util.exc.ErrorHandler;
import util.misc.OperatingSystem;
import util.ui.ChannelLabel;
import util.ui.Localizer;
import util.ui.SingleAndDoubleClickTreeUI;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SettingsDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SettingsDialog.class);
    private JDialog mDialog;
    private JTree mSelectionTree;
    private JPanel mSettingsPn;
    private TreeNode mRootNode;
    private SettingNode mPluginSettingsNode;
    private static SettingsDialog mInstance;
    private JButton mHelpBt;

    public SettingsDialog(Window parent, String selectedTabId) {
        SettingNode n;
        mInstance = this;
        this.mDialog = UiUtilities.createDialog(parent, true);
        String title = Localizer.getLocalization("i18n_settings");
        if (OperatingSystem.isWindows()) {
            title = Localizer.getLocalization("i18n_options");
        }
        if (title.isEmpty()) {
            title = Localizer.getLocalization("i18n_settings");
        }
        this.mDialog.setTitle(title);
        UiUtilities.registerForClosing(this);
        JPanel main = new JPanel(new FormLayout("fill:min:grow", "fill:min:grow, 3dlu, pref"));
        CellConstraints cc = new CellConstraints();
        main.setBorder(Borders.DLU4);
        this.mDialog.setContentPane(main);
        final JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        main.add((Component)splitPane, cc.xy(1, 1));
        final SingleAndDoubleClickTreeUI treeUI = new SingleAndDoubleClickTreeUI(1, null);
        this.mRootNode = this.createSelectionTree();
        this.mSelectionTree = new JTree(this.mRootNode){

            @Override
            public void updateUI() {
                this.setUI(treeUI);
                this.invalidate();
            }
        };
        this.mSelectionTree.setRootVisible(false);
        this.mSelectionTree.setShowsRootHandles(true);
        this.mSelectionTree.getSelectionModel().setSelectionMode(1);
        this.mSelectionTree.setCellRenderer(new SettingNodeCellRenderer());
        this.mSelectionTree.setSelectionRow(1);
        this.mSelectionTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                SettingsDialog.this.showSettingsPanelForSelectedNode();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.mSelectionTree);
        scrollPane.setMinimumSize(new Dimension(150, 0));
        scrollPane.setBorder(null);
        splitPane.setLeftComponent(scrollPane);
        splitPane.setDividerLocation(Settings.propSettingsDialogDividerLocation.getInt());
        int categoryCount = this.mRootNode.getChildCount();
        for (int i = 1; i <= categoryCount; ++i) {
            this.mSelectionTree.collapseRow(i);
        }
        this.mSettingsPn = new JPanel(new BorderLayout());
        splitPane.setRightComponent(this.mSettingsPn);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.mHelpBt = new JButton(mLocalizer.msg("help", "Online help"));
        this.mHelpBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Launch.openURL(SettingsDialog.this.mHelpBt.getToolTipText());
            }
        });
        builder.addButton((JComponent)this.mHelpBt);
        JButton okBt = new JButton(Localizer.getLocalization("i18n_ok"));
        okBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.saveSettingsTab();
                SettingsDialog.this.saveSettings();
                SettingsDialog.this.invalidateTree();
                SettingsDialog.this.close();
            }
        });
        this.mDialog.getRootPane().setDefaultButton(okBt);
        JButton cancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancelBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.cancelSettings();
                SettingsDialog.this.close();
            }
        });
        JButton applyBt = new JButton(mLocalizer.msg("apply", "Apply"));
        applyBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.saveSettings();
                SettingsDialog.this.invalidateTree();
                Settings.handleChangedSettings();
                SettingsDialog.this.showSettingsPanelForSelectedNode();
            }
        });
        builder.addGlue();
        builder.addButton(okBt, cancelBt, applyBt);
        main.add((Component)builder.getPanel(), cc.xy(1, 3));
        this.mDialog.pack();
        if (selectedTabId == null) {
            selectedTabId = "#channels";
        }
        if ((n = this.findSettingNodeById((SettingNode)this.mRootNode, selectedTabId)) == null) {
            n = this.findSettingNodeByPath((SettingNode)this.mRootNode, selectedTabId);
        }
        if (n != null) {
            this.showSettingsPanelForNode(n);
            TreePath selectedPath = new TreePath(n.getPath());
            this.mSelectionTree.setSelectionPath(selectedPath);
            this.mSelectionTree.makeVisible(selectedPath);
            treeUI.setLastSelectedPath(selectedPath);
            if (selectedTabId.equals("#plugins")) {
                this.mSelectionTree.expandPath(selectedPath);
            }
        } else {
            this.showSettingsPanelForSelectedNode();
        }
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.propSettingsDialogDividerLocation.setInt(splitPane.getDividerLocation());
            }

            @Override
            public void windowClosed(WindowEvent e) {
                Settings.propSettingsDialogDividerLocation.setInt(splitPane.getDividerLocation());
                mInstance = null;
            }
        });
    }

    private void cancelSettings() {
        this.cancelSettings((SettingNode)this.mSelectionTree.getModel().getRoot());
    }

    private void cancelSettings(SettingNode node) {
        node.cancelSettings();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.cancelSettings((SettingNode)node.getChildAt(i));
        }
    }

    protected void saveSettingsTab() {
        TreePath selection = this.mSelectionTree.getSelectionPath();
        if (selection != null) {
            StringBuilder path = new StringBuilder();
            for (int i = 0; i < selection.getPathCount(); ++i) {
                path.append(selection.getPathComponent(i));
            }
            Settings.propLastUsedSettingsPath.setString(path.toString());
        }
    }

    void invalidateTree() {
        ((SettingNode)this.mRootNode).invalidate();
    }

    private SettingNode findSettingNodeById(SettingNode root, String tabId) {
        if (tabId.equals(root.getId())) {
            return root;
        }
        int cnt = root.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            SettingNode result = this.findSettingNodeById((SettingNode)root.getChildAt(i), tabId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private SettingNode findSettingNodeByPath(SettingNode root, String searchPath) {
        TreeNode[] rootPath;
        StringBuilder pathString = new StringBuilder();
        for (TreeNode treeNode : rootPath = root.getPath()) {
            pathString.append(((SettingNode)treeNode).toString());
        }
        if (searchPath.equals(pathString.toString())) {
            return root;
        }
        int cnt = root.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            SettingNode result = this.findSettingNodeByPath((SettingNode)root.getChildAt(i), searchPath);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void centerAndShow() {
        Settings.layoutWindow("main.settingsDialog", this.mDialog, new Dimension(800, 550));
        this.mDialog.setVisible(true);
    }

    private TreeNode createSelectionTree() {
        ImageIcon icon = TVBrowserIcons.preferences(16);
        SettingNode root = new SettingNode(new DefaultSettingsTab(Localizer.getLocalization("i18n_settings"), icon));
        SettingNode generalSettings = new SettingNode(new StartupSettingsTab(), "#startup");
        root.add(generalSettings);
        SettingNode graphicalSettings = new SettingNode(new LookAndFeelSettingsTab(this), "#lookandfeel");
        root.add(graphicalSettings);
        SettingNode technicalSettings = new SettingNode(new DefaultSettingsTab(mLocalizer.msg("technical", "Technical"), null));
        root.add(technicalSettings);
        if (TVBrowser.isUsingSystemTray()) {
            SettingNode traySettings = new SettingNode(new TrayBaseSettingsTab(), "#tray");
            root.add(traySettings);
            traySettings.add(new SettingNode(new TrayImportantSettingsTab()));
            traySettings.add(new SettingNode(new TrayNowSettingsTab()));
            traySettings.add(new SettingNode(new TraySoonSettingsTab()));
            traySettings.add(new SettingNode(new TrayOnTimeSettingsTab(), "#trayOnTime"));
            traySettings.add(new SettingNode(new TrayProgramsChannelsSettingsTab()));
        }
        generalSettings.add(new SettingNode(new ChannelsSettingsTab(), "#channels"));
        generalSettings.add(new SettingNode(new DataPluginPostProcessingOrderSettingsTab(), "#dataPluginPostProcessing"));
        generalSettings.add(new SettingNode(new LocaleSettingsTab(this)));
        generalSettings.add(new SettingNode(new ContextmenuSettingsTab(), "#contextmenu"));
        generalSettings.add(new SettingNode(new MouseSettingsTab(), "#mouse"));
        generalSettings.add(new SettingNode(new GenericPluginFilterSettingsTab()));
        generalSettings.add(new SettingNode(new GlobalPluginProgramFormatingSettings(), "#pluginprogramformat"));
        generalSettings.add(new SettingNode(new ButtonsSettingsTab(), "#timebuttons"));
        graphicalSettings.add(new SettingNode(new PictureSettingsTab(this), "#pictures"));
        graphicalSettings.add(new SettingNode(new CenterPanelSettingsTab(), "#centerpanelsetup"));
        graphicalSettings.add(new SettingNode(new ProgramTableSettingsTab(), "#programtablelook"));
        graphicalSettings.add(new SettingNode(new ProgramPanelSettingsTab(), "#programpanellook"));
        graphicalSettings.add(new SettingNode(new ChannelIconAndNameSettingsTab(this)));
        graphicalSettings.add(new SettingNode(new MarkingsSettingsTab(), "#programpanelmarking"));
        graphicalSettings.add(new SettingNode(new FontsSettingsTab()));
        technicalSettings.add(new SettingNode(new NetworkSettingsTab()));
        technicalSettings.add(new SettingNode(new ProxySettingsTab()));
        if (!TVBrowser.isTransportable()) {
            technicalSettings.add(new SettingNode(new DirectoriesSettingsTab()));
        }
        technicalSettings.add(new SettingNode(new WebbrowserSettingsTab(), "#webbrowser"));
        this.mPluginSettingsNode = new SettingNode(new PluginSettingsTab(this), "#plugins");
        root.add(this.mPluginSettingsNode);
        this.createPluginTreeItems(false);
        return root;
    }

    private void createPluginTreeItems(boolean refresh) {
        this.mPluginSettingsNode.removeAllChildren();
        InternalPluginProxyIf[] internalPluginProxies = InternalPluginProxyList.getInstance().getAvailableProxys();
        Arrays.sort(internalPluginProxies, new InternalPluginProxyIf.Comparator());
        for (InternalPluginProxyIf internalPluginProxy : internalPluginProxies) {
            if (internalPluginProxy.getSettingsTab() == null) continue;
            this.mPluginSettingsNode.add(new SettingNode(internalPluginProxy.getSettingsTab(), internalPluginProxy.getSettingsId()));
        }
        PluginProxy[] pluginList = PluginProxyManager.getInstance().getAllPlugins();
        TvDataServiceProxy[] services = TvDataServiceProxyManager.getInstance().getDataServices();
        InfoIf[] infoArr = new InfoIf[pluginList.length + services.length];
        System.arraycopy(pluginList, 0, infoArr, 0, pluginList.length);
        System.arraycopy(services, 0, infoArr, pluginList.length, services.length);
        Arrays.sort(infoArr, new PluginAndDataServiceComparator());
        ArrayList<SettingNode> nodeList = new ArrayList<SettingNode>();
        for (InfoIf plugin : infoArr) {
            if (plugin instanceof PluginProxy) {
                ConfigPluginSettingsTab tab = new ConfigPluginSettingsTab((PluginProxy)plugin);
                nodeList.add(new SettingNode(tab, ((PluginProxy)plugin).getId()));
                continue;
            }
            if (!(plugin instanceof TvDataServiceProxy)) continue;
            nodeList.add(new SettingNode(new ConfigDataServiceSettingsTab((TvDataServiceProxy)plugin), ((TvDataServiceProxy)plugin).getId()));
        }
        SettingNode[] nodes = new SettingNode[nodeList.size()];
        nodeList.toArray(nodes);
        Arrays.sort(nodes, new SettingNode.Comparator());
        for (SettingNode node : nodes) {
            this.mPluginSettingsNode.add(node);
        }
        if (this.mSelectionTree != null) {
            ((DefaultTreeModel)this.mSelectionTree.getModel()).reload(this.mPluginSettingsNode);
        }
    }

    public void createPluginTreeItems() {
        this.createPluginTreeItems(true);
    }

    public JDialog getDialog() {
        return this.mDialog;
    }

    void saveSettings() {
        this.saveSettings((SettingNode)this.mSelectionTree.getModel().getRoot());
    }

    private void saveSettings(SettingNode node) {
        node.saveSettings();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.saveSettings((SettingNode)node.getChildAt(i));
        }
    }

    private void waitForLoadedChannels() {
        final Thread t = ChannelList.getChannelLoadThread();
        if (t != null && t.isAlive()) {
            Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            final SettingsWaitingDialog dialog = new SettingsWaitingDialog(parent);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (t.isAlive()) {
                        UiUtilities.centerAndShow(dialog);
                    }
                }
            });
            try {
                t.join(10000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dialog.setVisible(false);
            dialog.dispose();
        }
    }

    private void showSettingsPanelForNode(SettingNode node) {
        JPanel pn;
        String nodeId = node.getId();
        if (nodeId != null && nodeId.equalsIgnoreCase("#channels")) {
            this.waitForLoadedChannels();
        }
        if ((pn = node.getSettingsPanel()) != null) {
            String help = node.getHelpUrl();
            if (help != null) {
                this.mHelpBt.setToolTipText(help);
                this.mHelpBt.setEnabled(true);
            } else {
                this.mHelpBt.setToolTipText(mLocalizer.msg("noHelp", "No help available"));
                this.mHelpBt.setEnabled(false);
            }
            JPanel scroll = new JPanel(new FormLayout("min:grow", "fill:default:grow"));
            scroll.add((Component)pn, new CellConstraints().xy(1, 1));
            final JScrollPane pane = new JScrollPane(scroll);
            pane.setBorder(BorderFactory.createEmptyBorder());
            pane.getHorizontalScrollBar().setUnitIncrement(50);
            pane.getVerticalScrollBar().setUnitIncrement(50);
            scroll.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            pane.getVerticalScrollBar().setValue(0);
                        }
                    });
                }
            });
            this.mSettingsPn.add(pane);
        } else {
            this.mHelpBt.setToolTipText(mLocalizer.msg("noHelp", "No help available"));
            this.mHelpBt.setEnabled(false);
        }
    }

    private void showSettingsPanelForSelectedNode() {
        this.mSettingsPn.removeAll();
        TreePath selection = this.mSelectionTree.getSelectionPath();
        if (selection != null) {
            SettingNode node = (SettingNode)selection.getLastPathComponent();
            this.showSettingsPanelForNode(node);
        }
        this.mSettingsPn.revalidate();
        this.mSettingsPn.repaint();
    }

    @Override
    public void close() {
        this.mDialog.dispose();
        ChannelLabel.clearIconCache();
    }

    @Override
    public JRootPane getRootPane() {
        return this.mDialog.getRootPane();
    }

    public void showSettingsTab(String id) {
        SettingNode node = this.findSettingNodeById((SettingNode)this.mRootNode, id);
        if (node != null) {
            TreePath selectedPath = new TreePath(node.getPath());
            this.mSelectionTree.setSelectionPath(selectedPath);
            this.mSettingsPn.removeAll();
            this.showSettingsPanelForNode(node);
            this.mSettingsPn.revalidate();
            this.mSettingsPn.repaint();
        }
        if (!this.mDialog.isVisible()) {
            this.mDialog.setVisible(true);
        }
    }

    public static SettingsDialog getInstance() {
        return mInstance;
    }

    private static class SettingNodeCellRenderer
    extends DefaultTreeCellRenderer {
        private SettingNodeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int rowIndex, boolean hasFocus) {
            SettingNode node;
            Icon icon;
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, rowIndex, hasFocus);
            if (label != null && UiUtilities.isGTKLookAndFeel()) {
                label.setBackground(tree.getBackground());
                label.setOpaque(!sel && !hasFocus);
            }
            if (value instanceof SettingNode && (icon = (node = (SettingNode)value).getIcon()) != null) {
                label.setIcon(icon);
            }
            if (UiUtilities.isNimbusLookAndFeel()) {
                if (sel) {
                    label.setOpaque(true);
                    label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    label.setOpaque(false);
                }
            }
            return label;
        }
    }

    private static class SettingNode
    extends DefaultMutableTreeNode {
        private Icon mIcon;
        private JPanel mSettingsPn;
        private SettingsTab mSettingsTab;
        private String mId;
        private String mHelpUrl;

        public SettingNode(Icon icon, String title, String id, String helpUrl) {
            super(title);
            this.mIcon = icon;
            this.mId = id;
            this.mHelpUrl = helpUrl;
        }

        public SettingNode(Icon icon, String title, String id) {
            this(icon, title, id, null);
        }

        public SettingsTab getSettingsTab() {
            return this.mSettingsTab;
        }

        public SettingNode(SettingsTab settingsTab, String id) {
            this(settingsTab.getIcon(), settingsTab.getTitle(), id);
            this.mSettingsTab = settingsTab;
        }

        public SettingNode(SettingsTab settingsTab) {
            this(settingsTab, null);
        }

        public String getId() {
            return this.mId;
        }

        public boolean isLoaded() {
            return this.mSettingsPn != null;
        }

        public void invalidate() {
            if (this.mSettingsTab instanceof ConfigPluginSettingsTab) {
                ((ConfigPluginSettingsTab)this.mSettingsTab).invalidate();
            }
            this.mSettingsPn = null;
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                SettingNode node = (SettingNode)e.nextElement();
                node.invalidate();
            }
        }

        public void saveSettings() {
            if (this.isLoaded()) {
                this.mSettingsTab.saveSettings();
            }
        }

        public void cancelSettings() {
            if (this.isLoaded() && this.mSettingsTab instanceof CancelableSettingsTab) {
                ((CancelableSettingsTab)this.mSettingsTab).cancel();
            }
        }

        public JPanel getSettingsPanel() {
            if (!this.isLoaded() && this.mSettingsTab != null) {
                try {
                    this.mSettingsPn = this.mSettingsTab.createSettingsPanel();
                }
                catch (Throwable e) {
                    ErrorHandler.handle(mLocalizer.msg("loadError", "An error occurred during loading of {0}", this.mSettingsTab.getTitle()), e);
                }
            }
            return this.mSettingsPn;
        }

        public Icon getIcon() {
            return this.mIcon;
        }

        public String getHelpUrl() {
            String url = this.mHelpUrl;
            if (url == null || url.equals("")) {
                if (this.mSettingsTab instanceof ConfigPluginSettingsTab) {
                    PluginProxy plugin = PluginProxyManager.getInstance().getPluginForId(this.mId);
                    url = plugin.getInfo().getHelpUrl();
                    if (url == null) {
                        url = PluginInfo.getHelpUrl(plugin.getId());
                    }
                } else {
                    url = mLocalizer.msg("settingsUrl", "http://enwiki.tvbrowser.org/index.php/Settings {0}", this.mSettingsTab.getTitle());
                }
            }
            return url;
        }

        public static class Comparator
        implements java.util.Comparator<SettingNode> {
            @Override
            public int compare(SettingNode o1, SettingNode o2) {
                return o1.getSettingsTab().getTitle().compareToIgnoreCase(o2.getSettingsTab().getTitle());
            }
        }
    }

    private static class DefaultSettingsTab
    implements SettingsTab {
        private String mTitle;
        private Icon mIcon;

        public DefaultSettingsTab(String title, Icon icon) {
            this.mTitle = title;
            this.mIcon = icon;
        }

        @Override
        public JPanel createSettingsPanel() {
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            contentPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JLabel titleLb = new JLabel(this.mTitle);
            titleLb.setFont(new Font("Dialog", 0, 32));
            JLabel lb = new JLabel(mLocalizer.msg("selectCategory", "Please select a category on the left."));
            lb.setFont(new Font("Dialog", 0, 14));
            lb.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
            contentPanel.add(titleLb);
            contentPanel.add(lb);
            return contentPanel;
        }

        @Override
        public void saveSettings() {
        }

        @Override
        public Icon getIcon() {
            return this.mIcon;
        }

        @Override
        public String getTitle() {
            return this.mTitle;
        }
    }
}

