/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RootKey;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.PeriodItem;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WideComboBox;

public class StartupSettingsTab
implements SettingsTab {
    public static final int VALUE_AUTO_CHANNEL_UPDATE_DISABLED = -1;
    private static final DayPeriod VALUE_AUTO_CHANNEL_UPDATE_PERIOD_DEFAULT = new DayPeriod(14);
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(StartupSettingsTab.class);
    private JPanel mSettingsPn;
    private JCheckBox mShowStartScreenChB;
    private JCheckBox mMinimizeAfterStartUpChB;
    private JCheckBox mStartFullscreen;
    private JCheckBox mAutostartWithWindows;
    private File mLinkFileFile;
    private LinkFile mLinkFile;
    private static final String[] AUTO_DOWNLOAD_MSG_ARR = new String[]{mLocalizer.msg("autoDownload.daily", "Once a day"), mLocalizer.msg("autoDownload.every3days", "Every three days"), mLocalizer.msg("autoDownload.weekly", "Weekly")};
    private JCheckBox mAutoDownload;
    private JCheckBox mAutoChannelDownload;
    private JRadioButton mStartDownload;
    private JRadioButton mRecurrentDownload;
    private JComboBox mAutoDownloadCombo;
    private WideComboBox mAutoChannelDownloadPeriod;
    private JComboBox mAutoDownloadPeriodCB;
    private JRadioButton mAskBeforeDownloadRadio;
    private JRadioButton mAskTimeRadio;
    private JLabel mHowOften;
    private JCheckBox mDateCheck;
    private JCheckBox mAutoDownloadWaitingTime;
    private JSpinner mAutoDownloadWaitingTimeSp;
    private JCheckBox mOnlyMinimizeWhenWindowClosingChB;
    private JCheckBox mAskForExitConfirmation;
    private JCheckBox mShowFinishDialog;
    private JLabel mSecondsLabel;

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu, pref, 3dlu, pref, fill:3dlu:grow, 3dlu", "pref, 5dlu, pref, 1dlu, pref, 1dlu, pref, 10dlu, pref, 10dlu, pref, 5dlu, pref, pref");
        this.mSettingsPn = new JPanel(layout);
        this.mSettingsPn.setBorder(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        int y = 1;
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("title", "Startup")), cc.xyw(1, y++, 5));
        this.mMinimizeAfterStartUpChB = new JCheckBox(mLocalizer.msg("minimizeAfterStartup", "Minimize main window after start up"), Settings.propMinimizeAfterStartup.getBoolean());
        this.mSettingsPn.add((Component)this.mMinimizeAfterStartUpChB, cc.xy(2, ++y));
        ++y;
        this.mStartFullscreen = new JCheckBox(mLocalizer.msg("startFullscreen", "Start in fullscreen mode"), Settings.propIsUsingFullscreen.getBoolean());
        this.mSettingsPn.add((Component)this.mStartFullscreen, cc.xy(2, ++y));
        this.mMinimizeAfterStartUpChB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    StartupSettingsTab.this.mStartFullscreen.setSelected(false);
                }
            }
        });
        this.mStartFullscreen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    StartupSettingsTab.this.mMinimizeAfterStartUpChB.setSelected(false);
                }
            }
        });
        ++y;
        this.mShowStartScreenChB = new JCheckBox(mLocalizer.msg("showStartScreen", "Show TV-Browser start screen during start up"), Settings.propStartScreenShow.getBoolean());
        this.mSettingsPn.add((Component)this.mShowStartScreenChB, cc.xy(2, ++y));
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && !TVBrowser.isTransportable()) {
            layout.insertRow(++y, RowSpec.decode("1dlu"));
            layout.insertRow(++y, RowSpec.decode("pref"));
            try {
                block9: {
                    RegistryKey shellFolders = new RegistryKey(RootKey.HKEY_CURRENT_USER, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                    String path = shellFolders.getValue("Startup").getData().toString();
                    if (path == null || path.length() < 1 || !new File(path).isDirectory()) {
                        throw new Exception();
                    }
                    this.mLinkFileFile = new File(path, "TV-Browser.url");
                    try {
                        this.mLinkFile = new LinkFile(this.mLinkFileFile);
                        if (!this.mLinkFileFile.isFile()) break block9;
                        try {
                            if (!this.mLinkFile.hasTarget(new File("tvbrowser.exe").getAbsoluteFile())) {
                                this.createLink(this.mLinkFile);
                            }
                        }
                        catch (Exception linkException) {
                            this.mLinkFileFile.delete();
                        }
                    }
                    catch (FileNotFoundException fe) {
                        // empty catch block
                    }
                }
                this.mAutostartWithWindows = new JCheckBox(mLocalizer.msg("autostart", "Start TV-Browser with Windows"), this.mLinkFileFile.isFile());
                this.mSettingsPn.add((Component)this.mAutostartWithWindows, cc.xy(2, y));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        ++y;
        this.mSettingsPn.add((Component)this.createRefreshPanel(), cc.xyw(1, ++y, 5));
        ++y;
        String msg = mLocalizer.msg("onlyMinimizeWhenWindowClosing", "When closing the main window only minimize TV-Browser, don't quit.");
        this.mOnlyMinimizeWhenWindowClosingChB = new JCheckBox(msg, Settings.propOnlyMinimizeWhenWindowClosing.getBoolean());
        this.mAskForExitConfirmation = new JCheckBox(mLocalizer.msg("askForExitConfirmation", "Ask for confirmation on TV-Browser exit"), !Settings.propHiddenMessageBoxes.containsItem("MainFrame.askForExitConfirm"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("closing", "Closing")), cc.xyw(1, ++y, 5));
        ++y;
        this.mSettingsPn.add((Component)this.mOnlyMinimizeWhenWindowClosingChB, cc.xyw(2, ++y, 4));
        this.mSettingsPn.add((Component)this.mAskForExitConfirmation, cc.xyw(2, ++y, 4));
        return this.mSettingsPn;
    }

    private void createLink(LinkFile link) throws Exception {
        File tvb = new File("tvbrowser.exe");
        if (tvb.getAbsoluteFile().isFile()) {
            this.mLinkFile = new LinkFile(this.mLinkFileFile, tvb, new File(tvb.getAbsoluteFile().getParent() + "\\imgs\\desktop.ico"), 0);
        }
    }

    @Override
    public void saveSettings() {
        Settings.propMinimizeAfterStartup.setBoolean(this.mMinimizeAfterStartUpChB.isSelected());
        Settings.propStartScreenShow.setBoolean(this.mShowStartScreenChB.isSelected());
        Settings.propIsUsingFullscreen.setBoolean(this.mStartFullscreen.isSelected());
        if (this.mAutoChannelDownload.isSelected()) {
            Settings.propAutoChannelUpdatePeriod.setInt(((DayPeriod)this.mAutoChannelDownloadPeriod.getSelectedItem()).mDays);
        } else {
            Settings.propAutoChannelUpdatePeriod.setInt(-1);
        }
        if (this.mAutostartWithWindows != null) {
            if (this.mAutostartWithWindows.isSelected()) {
                if (!this.mLinkFileFile.isFile()) {
                    try {
                        this.createLink(this.mLinkFile);
                    }
                    catch (Exception createLink) {
                        // empty catch block
                    }
                    if (!this.mLinkFileFile.isFile()) {
                        this.mAutostartWithWindows.setSelected(false);
                        JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("creationError", "Couldn't create autostart shortcut.\nMaybe your have not the right to write in the autostart directory."), Localizer.getLocalization("i18n_error"), 0);
                    }
                }
            } else if (this.mLinkFileFile.isFile() && !this.mLinkFileFile.delete()) {
                this.mAutostartWithWindows.setSelected(true);
                JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("deletionError", "Couldn't delete autostart shortcut.\nMaybe your have not the right to write in the autostart directory."), mLocalizer.msg("error", "Error"), 0);
            }
        }
        int inx = this.mAutoDownloadCombo.getSelectedIndex();
        if (!this.mAutoDownload.isSelected()) {
            Settings.propAutoDownloadType.setString("never");
        } else if (inx == 0) {
            Settings.propAutoDownloadType.setString("daily");
        } else if (inx == 1) {
            Settings.propAutoDownloadType.setString("every3days");
        } else if (inx == 2) {
            Settings.propAutoDownloadType.setString("weekly");
        }
        if (this.mShowFinishDialog.isSelected()) {
            Settings.propHiddenMessageBoxes.removeItem("downloadDone");
        } else if (!Settings.propHiddenMessageBoxes.containsItem("downloadDone")) {
            Settings.propHiddenMessageBoxes.addItem("downloadDone");
        }
        Settings.propAutoDataDownloadEnabled.setBoolean(this.mRecurrentDownload.isSelected() && this.mAutoDownload.isSelected());
        Settings.propAskForAutoDownload.setBoolean(this.mAskBeforeDownloadRadio.isSelected());
        PeriodItem periodItem = (PeriodItem)this.mAutoDownloadPeriodCB.getSelectedItem();
        Settings.propAutoDownloadPeriod.setInt(periodItem.getDays());
        Settings.propAutoDownloadWaitingTime.setShort(((Integer)this.mAutoDownloadWaitingTimeSp.getValue()).shortValue());
        Settings.propAutoDownloadWaitingEnabled.setBoolean(this.mAutoDownloadWaitingTime.isSelected());
        Settings.propNTPTimeCheck.setBoolean(this.mDateCheck.isSelected());
        if (this.mOnlyMinimizeWhenWindowClosingChB != null) {
            boolean checked = this.mOnlyMinimizeWhenWindowClosingChB.isSelected();
            Settings.propOnlyMinimizeWhenWindowClosing.setBoolean(checked);
        }
        if (this.mAskForExitConfirmation.isSelected()) {
            Settings.propHiddenMessageBoxes.removeItem("MainFrame.askForExitConfirm");
        } else if (!Settings.propHiddenMessageBoxes.containsItem("MainFrame.askForExitConfirm")) {
            Settings.propHiddenMessageBoxes.addItem("MainFrame.askForExitConfirm");
        }
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "document-properties", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("general", "General");
    }

    private JPanel createRefreshPanel() {
        PanelBuilder refreshSettings = new PanelBuilder(new FormLayout("5dlu, 9dlu, default, 3dlu, default, fill:3dlu:grow, 3dlu", "default, 5dlu, default, 3dlu, default, default, 3dlu, default, 5dlu, default, 3dlu, default,10dlu,default,3dlu,default"));
        CellConstraints cc = new CellConstraints();
        int y = 1;
        refreshSettings.addSeparator(mLocalizer.msg("titleRefresh", "Startup"), cc.xyw(1, y, 6));
        this.mAutoDownload = new JCheckBox(mLocalizer.msg("autoUpdate", "Automatically update TV listings"));
        this.mStartDownload = new JRadioButton(mLocalizer.msg("onStartUp", "Only on TV-Browser startup"));
        this.mRecurrentDownload = new JRadioButton(mLocalizer.msg("recurrent", "Recurrent"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mStartDownload);
        bg.add(this.mRecurrentDownload);
        refreshSettings.add((Component)this.mAutoDownload, cc.xyw(2, y += 2, 5));
        y += 2;
        refreshSettings.add((Component)this.mStartDownload, cc.xyw(3, y++, 4));
        refreshSettings.add((Component)this.mRecurrentDownload, cc.xyw(3, y, 4));
        this.mAutoDownloadCombo = new JComboBox<String>(AUTO_DOWNLOAD_MSG_ARR);
        String dlType = Settings.propAutoDownloadType.getString();
        if (dlType.equals("daily")) {
            this.mAutoDownloadCombo.setSelectedIndex(0);
        } else if (dlType.equals("every3days")) {
            this.mAutoDownloadCombo.setSelectedIndex(1);
        } else if (dlType.equals("weekly")) {
            this.mAutoDownloadCombo.setSelectedIndex(2);
        }
        JPanel panel = new JPanel(new FormLayout("10dlu, pref, 3dlu, pref", "pref, 3dlu, pref, 3dlu, pref, 5dlu, pref"));
        this.mStartDownload.setSelected(!dlType.equals("never") && !Settings.propAutoDataDownloadEnabled.getBoolean());
        this.mRecurrentDownload.setSelected(Settings.propAutoDataDownloadEnabled.getBoolean());
        this.mAutoDownload.setSelected(this.mStartDownload.isSelected() || this.mRecurrentDownload.isSelected());
        this.mStartDownload.setSelected(!this.mAutoDownload.isSelected() || this.mStartDownload.isSelected());
        this.mStartDownload.setEnabled(this.mAutoDownload.isSelected());
        this.mRecurrentDownload.setEnabled(this.mAutoDownload.isSelected());
        this.mHowOften = new JLabel(mLocalizer.msg("autoDownload.howOften", "How often?"));
        panel.add((Component)this.mHowOften, cc.xy(2, 1));
        panel.add((Component)this.mAutoDownloadCombo, cc.xy(4, 1));
        this.mAskBeforeDownloadRadio = new JRadioButton(mLocalizer.msg("autoDownload.ask", "Ask before downloading"));
        this.mAutoDownloadPeriodCB = new JComboBox<PeriodItem>(PeriodItem.getPeriodItems());
        int autoDLPeriod = Settings.propAutoDownloadPeriod.getInt();
        PeriodItem pi = new PeriodItem(autoDLPeriod);
        this.mAutoDownloadPeriodCB.setSelectedItem(pi);
        panel.add((Component)this.mAskBeforeDownloadRadio, cc.xyw(2, 3, 3));
        this.mAskTimeRadio = new JRadioButton(mLocalizer.msg("autoDownload.duration", "Automatically refresh for"));
        panel.add((Component)this.mAskTimeRadio, cc.xy(2, 5));
        panel.add((Component)this.mAutoDownloadPeriodCB, cc.xy(4, 5));
        ButtonGroup group = new ButtonGroup();
        group.add(this.mAskBeforeDownloadRadio);
        group.add(this.mAskTimeRadio);
        this.mAskBeforeDownloadRadio.setSelected(Settings.propAskForAutoDownload.getBoolean());
        this.mAskTimeRadio.setSelected(!Settings.propAskForAutoDownload.getBoolean());
        this.mAutoDownloadWaitingTime = new JCheckBox(mLocalizer.msg("autoDownload.waiting", "Delay auto update for"), Settings.propAutoDownloadWaitingEnabled.getBoolean());
        this.mAutoDownloadWaitingTimeSp = new JSpinner(new SpinnerNumberModel(Settings.propAutoDownloadWaitingTime.getShort(), 1, 60, 1));
        this.mSecondsLabel = new JLabel(mLocalizer.msg("autoDownload.seconds", "seconds"));
        this.mAutoDownload.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StartupSettingsTab.this.setAutoDownloadEnabled(e.getStateChange() == 1);
            }
        });
        this.mAskBeforeDownloadRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StartupSettingsTab.this.setAutoDownloadEnabled(StartupSettingsTab.this.mAutoDownload.isSelected());
            }
        });
        this.mAskTimeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartupSettingsTab.this.setAutoDownloadEnabled(StartupSettingsTab.this.mAskTimeRadio.isSelected());
            }
        });
        this.mAutoDownloadWaitingTime.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StartupSettingsTab.this.mAutoDownloadWaitingTimeSp.setEnabled(e.getStateChange() == 1);
            }
        });
        JPanel waitingPanel = new JPanel(new FormLayout("pref,2dlu,pref,2dlu,pref", "pref"));
        waitingPanel.add((Component)this.mAutoDownloadWaitingTime, cc.xy(1, 1));
        waitingPanel.add((Component)this.mAutoDownloadWaitingTimeSp, cc.xy(3, 1));
        waitingPanel.add((Component)this.mSecondsLabel, cc.xy(5, 1));
        panel.add((Component)waitingPanel, cc.xyw(1, 7, 4));
        refreshSettings.add((Component)panel, cc.xyw(3, y += 2, 4));
        this.mDateCheck = new JCheckBox(mLocalizer.msg("checkDate", "Check date via NTP if data download fails"));
        this.mDateCheck.setSelected(Settings.propNTPTimeCheck.getBoolean());
        refreshSettings.add((Component)this.mDateCheck, cc.xyw(2, y += 2, 5));
        this.mShowFinishDialog = new JCheckBox(mLocalizer.msg("showFinishDialog", "Show dialog when update is done"));
        this.mShowFinishDialog.setSelected(!Settings.propHiddenMessageBoxes.containsItem("downloadDone"));
        refreshSettings.add((Component)this.mShowFinishDialog, cc.xyw(2, y += 2, 5));
        this.setAutoDownloadEnabled(this.mAutoDownload.isSelected());
        this.mAutoChannelDownload = new JCheckBox(mLocalizer.msg("autoChannelUpdate", "Automatically update available channels"));
        this.mAutoChannelDownloadPeriod = new WideComboBox();
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(1));
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(7));
        this.mAutoChannelDownloadPeriod.addItem(VALUE_AUTO_CHANNEL_UPDATE_PERIOD_DEFAULT);
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(30));
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(61));
        this.mAutoChannelDownloadPeriod.addItem(new DayPeriod(183));
        if (Settings.propAutoChannelUpdatePeriod.getInt() > -1) {
            this.mAutoChannelDownload.setSelected(true);
            this.mAutoChannelDownloadPeriod.setSelectedItem(new DayPeriod(Settings.propAutoChannelUpdatePeriod.getInt()));
        } else {
            this.mAutoChannelDownloadPeriod.setSelectedItem(VALUE_AUTO_CHANNEL_UPDATE_PERIOD_DEFAULT);
            this.mAutoChannelDownloadPeriod.setEnabled(false);
        }
        this.mAutoChannelDownload.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StartupSettingsTab.this.mAutoChannelDownloadPeriod.setEnabled(e.getStateChange() == 1);
            }
        });
        refreshSettings.add((Component)this.mAutoChannelDownload, cc.xyw(2, y += 2, 5));
        refreshSettings.add((Component)this.mAutoChannelDownloadPeriod, cc.xyw(3, y += 2, 1));
        return refreshSettings.getPanel();
    }

    private void setAutoDownloadEnabled(boolean enabled) {
        this.mRecurrentDownload.setEnabled(enabled);
        this.mStartDownload.setEnabled(enabled);
        this.mAskBeforeDownloadRadio.setEnabled(enabled);
        this.mHowOften.setEnabled(enabled);
        this.mAutoDownloadCombo.setEnabled(enabled);
        this.mAskTimeRadio.setEnabled(enabled);
        this.mAutoDownloadWaitingTime.setEnabled(enabled);
        this.mAutoDownloadWaitingTimeSp.setEnabled(enabled && this.mAutoDownloadWaitingTime.isSelected());
        this.mSecondsLabel.setEnabled(enabled);
        enabled = !this.mAskBeforeDownloadRadio.isSelected() && enabled;
        this.mAutoDownloadPeriodCB.setEnabled(enabled);
    }

    private static final class DayPeriod {
        int mDays;

        DayPeriod(int days) {
            this.mDays = days;
        }

        public String toString() {
            return mLocalizer.msg("autoChannelUpdate.every" + this.mDays + "days", "Every " + this.mDays + " days");
        }

        public boolean equals(Object obj) {
            if (obj instanceof DayPeriod) {
                return this.mDays == ((DayPeriod)obj).mDays;
            }
            return super.equals(obj);
        }
    }

    private static class LinkFile {
        private String mTarget;

        private LinkFile(File linkFile, File target, File icon, int iconIndex) throws IOException {
            RandomAccessFile write = new RandomAccessFile(linkFile, "rw");
            write.getChannel().truncate(0L);
            write.writeBytes("[InternetShortcut]\r\n");
            write.writeBytes("URL=" + target.getAbsoluteFile().toURI().toURL() + "\r\n");
            write.writeBytes("WorkingDirectory=" + target.getParent());
            if (icon != null && icon.isFile()) {
                write.writeBytes("\r\nIconFile=" + icon.getAbsolutePath() + "\r\n");
                write.writeBytes("IconIndex=" + iconIndex);
            }
            write.close();
        }

        public LinkFile(File linkFile) throws IOException {
            RandomAccessFile read = new RandomAccessFile(linkFile, "r");
            String line = null;
            while ((line = read.readLine()) != null) {
                if (!line.startsWith("URL")) continue;
                this.mTarget = line.substring(line.indexOf(":/") + 2);
            }
            read.close();
        }

        public boolean hasTarget(File file) {
            return new File(this.mTarget).equals(file);
        }
    }
}

