/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.settings.TrayImportantSettingsTab;
import tvbrowser.ui.settings.TrayNowSettingsTab;
import tvbrowser.ui.settings.TrayOnTimeSettingsTab;
import tvbrowser.ui.settings.TrayProgramsChannelsSettingsTab;
import tvbrowser.ui.settings.TraySoonSettingsTab;
import util.misc.JavaVersion;
import util.misc.OperatingSystem;
import util.ui.Localizer;

public class TrayBaseSettingsTab
implements SettingsTab {
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(TrayBaseSettingsTab.class);
    private JCheckBox mTrayIsEnabled;
    private JCheckBox mMinimizeToTrayChb;
    private JCheckBox mNowOnRestore;
    private JCheckBox mTrayIsAnialiasing;
    private boolean mOldState;
    private static boolean mIsEnabled = Settings.propTrayIsEnabled.getBoolean();
    private JRadioButton mFilterAll;
    private JRadioButton mNoMarkedFiltering;
    private JRadioButton mNoFiltering;

    @Override
    public JPanel createSettingsPanel() {
        final PanelBuilder builder = new PanelBuilder(new FormLayout("5dlu, pref:grow, 5dlu", "pref, 5dlu, pref, pref, pref, pref, pref, 10dlu, pref, 5dlu, pref, pref, pref"));
        builder.border(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        String msg = mLocalizer.msg("trayIsEnabled", "Tray activated");
        this.mOldState = Settings.propTrayIsEnabled.getBoolean();
        this.mTrayIsEnabled = new JCheckBox(msg, this.mOldState);
        msg = mLocalizer.msg("minimizeToTray", "Minimize to Tray");
        boolean checked = Settings.propTrayMinimizeTo.getBoolean();
        this.mMinimizeToTrayChb = new JCheckBox(msg, checked && this.mOldState);
        this.mMinimizeToTrayChb.setEnabled(this.mTrayIsEnabled.isSelected());
        msg = mLocalizer.msg("nowOnDeIconify", "Jump to now when restoring application");
        checked = Settings.propNowOnRestore.getBoolean();
        this.mNowOnRestore = new JCheckBox(msg, checked);
        msg = mLocalizer.msg("trayAntialiasing", "Antialiasing enabled");
        checked = Settings.propTrayIsAntialiasing.getBoolean();
        this.mTrayIsAnialiasing = new JCheckBox(msg, checked);
        if (System.getProperty("os.name").toLowerCase().startsWith("linux") && (JavaVersion.getVersion() < 7 || OperatingSystem.isKDE())) {
            this.mMinimizeToTrayChb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TrayBaseSettingsTab.this.mMinimizeToTrayChb.isSelected()) {
                        JOptionPane.showMessageDialog(builder.getPanel(), mLocalizer.msg("minimizeToTrayWarning", "This function might not work as expected on Unix systems like KDE or Gnome.\nSo it's recommended not to select this checkbox."), mLocalizer.msg("warning", "Warning"), 2);
                    }
                }
            });
        }
        ButtonGroup filter = new ButtonGroup();
        msg = mLocalizer.msg("trayFilterAll", "Filter all programs");
        this.mFilterAll = new JRadioButton(msg);
        msg = mLocalizer.msg("trayFilterNotMarked", "Filter programs, if not marked");
        checked = Settings.propTrayFilterNotMarked.getBoolean();
        this.mNoMarkedFiltering = new JRadioButton(msg, checked);
        msg = mLocalizer.msg("trayFilterNot", "Don't filter programs");
        checked = Settings.propTrayFilterNot.getBoolean();
        this.mNoFiltering = new JRadioButton(msg, checked);
        if (!this.mNoFiltering.isSelected() && !this.mNoMarkedFiltering.isSelected()) {
            this.mFilterAll.setSelected(true);
        }
        filter.add(this.mFilterAll);
        filter.add(this.mNoMarkedFiltering);
        filter.add(this.mNoFiltering);
        builder.addSeparator(mLocalizer.msg("basics", "Basic settings"), cc.xyw(1, 1, 3));
        builder.add((Component)this.mTrayIsEnabled, cc.xy(2, 3));
        builder.add((Component)this.mTrayIsAnialiasing, cc.xy(2, 4));
        builder.add((Component)this.mMinimizeToTrayChb, cc.xy(2, 5));
        builder.add((Component)this.mNowOnRestore, cc.xy(2, 6));
        builder.addSeparator(mLocalizer.msg("filter", "Filter settings"), cc.xyw(1, 9, 3));
        builder.add((Component)this.mFilterAll, cc.xy(2, 11));
        builder.add((Component)this.mNoMarkedFiltering, cc.xy(2, 12));
        builder.add((Component)this.mNoFiltering, cc.xy(2, 13));
        this.mTrayIsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mIsEnabled = TrayBaseSettingsTab.this.mTrayIsEnabled.isSelected();
                TrayImportantSettingsTab.setTrayIsEnabled(mIsEnabled);
                TrayNowSettingsTab.setTrayIsEnabled(mIsEnabled);
                TrayOnTimeSettingsTab.setTrayIsEnabled(mIsEnabled);
                TraySoonSettingsTab.setTrayIsEnabled(mIsEnabled);
                TrayProgramsChannelsSettingsTab.setTrayIsEnabled(mIsEnabled);
                TrayBaseSettingsTab.this.mMinimizeToTrayChb.setEnabled(TrayBaseSettingsTab.this.mTrayIsEnabled.isSelected());
                TrayBaseSettingsTab.this.mNowOnRestore.setEnabled(TrayBaseSettingsTab.this.mTrayIsEnabled.isSelected());
                TrayBaseSettingsTab.this.mTrayIsAnialiasing.setEnabled(TrayBaseSettingsTab.this.mTrayIsEnabled.isSelected());
                TrayBaseSettingsTab.this.mFilterAll.setEnabled(TrayBaseSettingsTab.this.mTrayIsEnabled.isSelected());
                TrayBaseSettingsTab.this.mNoMarkedFiltering.setEnabled(TrayBaseSettingsTab.this.mTrayIsEnabled.isSelected());
                TrayBaseSettingsTab.this.mNoFiltering.setEnabled(TrayBaseSettingsTab.this.mTrayIsEnabled.isSelected());
            }
        });
        return builder.getPanel();
    }

    @Override
    public void saveSettings() {
        if (this.mTrayIsEnabled != null) {
            Settings.propTrayIsEnabled.setBoolean(this.mTrayIsEnabled.isSelected());
            if (this.mTrayIsEnabled.isSelected() && !this.mOldState) {
                TVBrowser.loadTray();
            } else if (!this.mTrayIsEnabled.isSelected() && this.mOldState) {
                TVBrowser.removeTray();
            }
        }
        if (this.mMinimizeToTrayChb != null) {
            boolean checked = this.mMinimizeToTrayChb.isSelected() && this.mTrayIsEnabled.isSelected();
            Settings.propTrayMinimizeTo.setBoolean(checked);
        }
        Settings.propNowOnRestore.setBoolean(this.mNowOnRestore.isSelected());
        Settings.propTrayIsAntialiasing.setBoolean(this.mTrayIsAnialiasing.isSelected());
        Settings.propTrayFilterNotMarked.setBoolean(this.mNoMarkedFiltering.isSelected());
        Settings.propTrayFilterNot.setBoolean(this.mNoFiltering.isSelected());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "document-properties", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Tray settings");
    }

    protected static boolean isTrayEnabled() {
        return mIsEnabled;
    }
}

