/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.tablebackgroundstyles;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.ProgramTableSettingsTab;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import util.ui.Localizer;
import util.ui.TabLayout;

public class SingleImageBackgroundStyle
implements TableBackgroundStyle {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SingleImageBackgroundStyle.class);
    private JTextField mOneImageBackgroundTF;
    private JPanel mContent;

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public JPanel createSettingsContent() {
        this.mContent = new JPanel(new TabLayout(3));
        this.mContent.add(new JLabel(mLocalizer.msg("oneImage.image", "Image")));
        this.mOneImageBackgroundTF = new JTextField(Settings.propOneImageBackground.getString(), 25);
        this.mContent.add(this.mOneImageBackgroundTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mOneImageBackgroundTF));
        return this.mContent;
    }

    @Override
    public void storeSettings() {
        if (this.mContent != null) {
            Settings.propOneImageBackground.setString(this.mOneImageBackgroundTF.getText());
        }
    }

    @Override
    public String getName() {
        return mLocalizer.msg("style", "One image");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSettingsString() {
        return "oneImage";
    }
}

