/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.tablebackgroundstyles;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.TimeBlockBackgroundStyle;
import util.ui.Localizer;

public class UiTimeBlockBackgroundStyle
implements TableBackgroundStyle {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(UiTimeBlockBackgroundStyle.class);
    private JSpinner mTimeBlockSizeSp;
    private JCheckBox mTimeBlockShowWestChB;
    private JPanel mContent;

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public JPanel createSettingsContent() {
        this.mTimeBlockSizeSp = new JSpinner(new SpinnerNumberModel(Settings.propTimeBlockSize.getInt(), 1, 23, 1));
        this.mTimeBlockShowWestChB = new JCheckBox(TimeBlockBackgroundStyle.mLocalizer.msg("timeBlock.showWest", "Show left border"), Settings.propTimeBlockShowWest.getBoolean());
        this.mContent = new JPanel(new FormLayout("default,5dlu,default:grow", "default,2dlu,default"));
        this.mContent.add((Component)new JLabel(TimeBlockBackgroundStyle.mLocalizer.msg("timeBlock.blockSize", "Block size")), CC.xy(1, 1));
        this.mContent.add((Component)this.mTimeBlockSizeSp, CC.xy(3, 1));
        this.mContent.add((Component)this.mTimeBlockShowWestChB, CC.xyw(1, 3, 3));
        return this.mContent;
    }

    @Override
    public void storeSettings() {
        if (this.mContent == null) {
            return;
        }
        Integer blockSize = (Integer)this.mTimeBlockSizeSp.getValue();
        Settings.propTimeBlockSize.setInt(blockSize);
        Settings.propTimeBlockShowWest.setBoolean(this.mTimeBlockShowWestChB.isSelected());
    }

    @Override
    public String getName() {
        return mLocalizer.msg("style", "Theme color time block");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSettingsString() {
        return "uiTimeBlock";
    }
}

