/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.waiting.dlgs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import util.ui.Localizer;

public class CopyWaitingDlg
extends JDialog {
    public static final byte COPY_MSG = 0;
    public static final byte IMPORT_MSG = 1;
    public static final byte APPDATA_MSG = 2;
    public static final byte IMPORT_SETTINGS_MSG = 3;
    public static final byte EXPORT_SETTINGS_MSG = 4;

    public CopyWaitingDlg(Window parent, byte messageType) {
        super(parent);
        this.setModal(true);
        this.createGUI(parent, messageType);
    }

    private void createGUI(Window parent, byte messageType) {
        this.setUndecorated(true);
        this.setCursor(new Cursor(3));
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panel.setLayout(new FormLayout("3dlu, pref, 3dlu", "3dlu, pref, 3dlu, pref, 3dlu"));
        CellConstraints cc = new CellConstraints();
        Localizer localizer = Localizer.getLocalizerFor(CopyWaitingDlg.class);
        String msg = localizer.msg("waitingHeader", "Importing TV data (this can take some minutes).");
        JTextArea header = new JTextArea();
        header.setPreferredSize(new Dimension(370, 40));
        if (messageType == 1) {
            msg = localizer.msg("waitingHeaderCopy", "Copying TV data (this can take some minutes).");
        } else if (messageType == 2) {
            msg = localizer.msg("appdataHeaderMsg", "Copying TV data (this can need some minutes).\nThe data and the settings are copied to the\nWindows appdata directory. You can delete the old TV-Browser settings directory\n if you don't use an old version of TV-Browser.");
            header.setPreferredSize(new Dimension(370, 90));
        } else if (messageType == 4) {
            msg = localizer.msg("exportHeader", "Copying TV data (this can need some minutes).\nThe data and the settings are copied to the\nsystem settings directory.");
            header.setPreferredSize(new Dimension(370, 60));
        } else {
            msg = localizer.msg("waitingSettingsHeader", "Importing the settings of a previous version (this may take some minutes).");
        }
        header.setText(msg);
        header.setEditable(false);
        header.setLineWrap(true);
        header.setWrapStyleWord(true);
        header.setBorder(null);
        header.setOpaque(false);
        JLabel label = new JLabel(localizer.msg("pleaseWait", "Please wait until the files were copied."));
        header.setFont(label.getFont());
        header.setFont(header.getFont().deriveFont(1, 13.0f));
        label.setFont(header.getFont());
        panel.add((Component)header, cc.xy(2, 2));
        panel.add((Component)label, cc.xy(2, 4));
        this.pack();
        this.setLocationRelativeTo(parent);
    }
}

