/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import devplugin.Date;
import devplugin.ProgressMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import util.exc.TvBrowserException;
import util.io.FileFormatException;
import util.io.IOUtilities;
import util.io.NetworkUtilities;
import util.ui.Localizer;

public class Mirror {
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(Mirror.class);
    private static final int MAX_UP_TO_DATE_CHECKS = 10;
    private static final int MAX_LAST_UPDATE_DAYS = 5;
    public static final String MIRROR_LIST_FILE_NAME = "mirrorlist.gz";
    private static final Logger mLog = Logger.getLogger(Mirror.class.getName());
    public static final int DEFAULT_WEIGHT = 100;
    private String mUrl;
    private int mWeight;
    private static ArrayList<String> BLOCKEDSERVERS = new ArrayList();
    private static boolean mMirrorDownloadRunning = true;
    private static boolean mDownloadException = false;
    private static byte[] mMirrorDownloadData = null;

    public Mirror(String url, int weight) {
        this.mUrl = IOUtilities.replace(url, " ", "%20");
        this.mWeight = weight;
    }

    public Mirror(String url) {
        this(url, 100);
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getWeight() {
        return this.mWeight;
    }

    public void setWeight(int weight) {
        this.mWeight = weight;
    }

    private static Mirror[] readMirrorListFromStream(InputStream stream) throws IOException, FileFormatException {
        String line;
        InputStream gIn = IOUtilities.openSaveGZipInputStream(stream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(gIn));
        ArrayList<Mirror> list = new ArrayList<Mirror>();
        int lineCount = 1;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() > 0) {
                int weight;
                StringTokenizer tokenizer = new StringTokenizer(line, ";");
                if (tokenizer.countTokens() < 2) {
                    throw new FileFormatException("Syntax error in mirror file line " + lineCount + ": '" + line + "'");
                }
                String url = tokenizer.nextToken();
                String weightAsString = tokenizer.nextToken();
                try {
                    weight = Integer.parseInt(weightAsString);
                }
                catch (Exception exc) {
                    throw new FileFormatException("Syntax error in mirror file line " + lineCount + ": weight is not a number: '" + weightAsString + "'");
                }
                list.add(new Mirror(url, weight));
            }
            ++lineCount;
        }
        gIn.close();
        Mirror[] mirrorArr = new Mirror[list.size()];
        list.toArray(mirrorArr);
        return mirrorArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mirror[] readMirrorListFromFile(File file) throws IOException, FileFormatException {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file), 8192);
            Mirror[] mirrorArray = Mirror.readMirrorListFromStream(stream);
            return mirrorArray;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeMirrorListToStream(OutputStream stream, Mirror[] mirrorArr) throws IOException {
        GZIPOutputStream gOut = new GZIPOutputStream(stream);
        PrintWriter writer = new PrintWriter(gOut);
        for (Mirror mirror : mirrorArr) {
            writer.print(mirror.getUrl());
            writer.print(";");
            writer.println(String.valueOf(mirror.getWeight()));
        }
        writer.close();
        gOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMirrorListToFile(File file, Mirror[] mirrorArr) throws IOException {
        try {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(file);
                Mirror.writeMirrorListToStream(stream, mirrorArr);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException exc) {
            file.delete();
            throw exc;
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.mUrl == null ? 0 : this.mUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mirror other = (Mirror)obj;
        return !(this.mUrl == null ? other.mUrl != null : !this.mUrl.equals(other.mUrl));
    }

    public static Mirror[] loadMirrorList(File file, String[] mirrorUrlArr, Mirror[] serverDefindedMirros) {
        try {
            int i;
            ArrayList<Mirror> mirrorList = new ArrayList<Mirror>(Arrays.asList(Mirror.readMirrorListFromFile(file)));
            for (i = 0; i < mirrorUrlArr.length; ++i) {
                Mirror basemirror = mirrorList.get(i);
                if (mirrorList.contains(basemirror)) continue;
                mirrorList.add(basemirror);
            }
            if (serverDefindedMirros != null) {
                for (i = 0; i < serverDefindedMirros.length; ++i) {
                    if (mirrorList.contains(serverDefindedMirros[i])) continue;
                    mirrorList.add(serverDefindedMirros[i]);
                }
            }
            return mirrorList.toArray(new Mirror[mirrorList.size()]);
        }
        catch (Exception exc) {
            ArrayList<Mirror> mirrorList = new ArrayList<Mirror>();
            for (int i = 0; i < mirrorUrlArr.length; ++i) {
                if (BLOCKEDSERVERS.contains(Mirror.getServerBase(mirrorUrlArr[i])) || mirrorUrlArr[i] == null) continue;
                mirrorList.add(new Mirror(mirrorUrlArr[i]));
            }
            return mirrorList.toArray(new Mirror[mirrorList.size()]);
        }
    }

    private static String getServerBase(String url) {
        if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        if (url.indexOf(47) >= 0) {
            url = url.substring(0, url.indexOf(47));
        }
        return url;
    }

    private static Mirror chooseMirror(Mirror[] mirrorArr, Mirror oldMirror, String name, Class caller) throws TvBrowserException {
        Mirror[] oldMirrorArr = mirrorArr;
        if (oldMirror != null) {
            ArrayList<Mirror> mirrors = new ArrayList<Mirror>();
            for (Mirror mirror : mirrorArr) {
                if (oldMirror == mirror) continue;
                mirrors.add(mirror);
            }
            mirrorArr = new Mirror[mirrors.size()];
            mirrors.toArray(mirrorArr);
        }
        int totalWeight = 0;
        for (Mirror mirror : mirrorArr) {
            totalWeight += mirror.getWeight();
        }
        if (totalWeight > 0) {
            int chosenWeight = (int)(Math.random() * (double)totalWeight);
            int currWeight = 0;
            for (Mirror mirror : mirrorArr) {
                if ((currWeight += mirror.getWeight()) <= chosenWeight) continue;
                if ((mirror == oldMirror || BLOCKEDSERVERS.contains(Mirror.getServerBase(mirror.getUrl()))) && mirrorArr.length > 1) {
                    ArrayList<Mirror> oldList = new ArrayList<Mirror>(oldMirrorArr.length);
                    for (Mirror m : oldMirrorArr) {
                        oldList.add(m);
                    }
                    ArrayList<Mirror> currentList = new ArrayList<Mirror>(mirrorArr.length);
                    for (Mirror m : mirrorArr) {
                        currentList.add(m);
                    }
                    Comparator<Mirror> comp = new Comparator<Mirror>(){

                        @Override
                        public int compare(Mirror m1, Mirror m2) {
                            return m1.getUrl().compareTo(m2.getUrl());
                        }
                    };
                    Collections.sort(oldList, comp);
                    Collections.sort(currentList, comp);
                    if (oldList.equals(currentList)) {
                        return mirror;
                    }
                    return Mirror.chooseMirror(mirrorArr, oldMirror, name, caller);
                }
                return mirror;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (Mirror mirror : oldMirrorArr) {
            buf.append(mirror.getUrl()).append('\n');
        }
        throw new TvBrowserException(caller, "error.2", "No mirror found\ntried following mirrors: ", (Object)name, buf.toString());
    }

    public static Mirror chooseWorkingMirror(Mirror[] mirrorArr, ProgressMonitor monitor, String name, String id, Class caller, String additionalErrorMsg, int timeout) throws TvBrowserException {
        Mirror mirror = null;
        for (int i = 0; i < mirrorArr.length; ++i) {
            Mirror oldMirror = mirror;
            if (oldMirror != null) {
                mLog.info("Mirror " + oldMirror.getUrl() + " is down. Choosing " + mirror.getUrl() + " instead.");
                if (monitor != null) {
                    monitor.setMessage(mLocalizer.msg("info.4", "Mirror {0} is out of date or down. Choosing {1}", oldMirror.getUrl(), mirror.getUrl()));
                }
            }
            mirror = Mirror.chooseMirror(mirrorArr, mirror, name, caller);
            if (monitor != null) {
                monitor.setMessage(mLocalizer.msg("info.3", "Try to connect to mirror {0}", mirror.getUrl()));
            }
            try {
                if (NetworkUtilities.checkConnection(new URL(mirror.getUrl()), timeout, false)) break;
                String blockedServer = Mirror.getServerBase(mirror.getUrl());
                BLOCKEDSERVERS.add(blockedServer);
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return mirror;
    }

    public static Mirror chooseUpToDateMirror(Mirror[] mirrorArr, ProgressMonitor monitor, String name, String id, Class caller, String additionalErrorMsg) throws TvBrowserException {
        Mirror chosenMirror = null;
        int chosenLastUpdate = Integer.MAX_VALUE;
        Mirror mirror = Mirror.chooseMirror(mirrorArr, null, name, caller);
        if (monitor != null) {
            monitor.setMessage(mLocalizer.msg("info.3", "Try to connect to mirror {0}", mirror.getUrl()));
        }
        for (int i = 0; i < 10; ++i) {
            Mirror oldMirror;
            try {
                int maxDays = (int)(Math.random() * 6.0);
                int currentLastUpdate = Mirror.daysSinceMirrorLastUpdate(mirror, id);
                if (currentLastUpdate <= maxDays || mirrorArr.length == 1) {
                    chosenMirror = mirror;
                    break;
                }
                if (currentLastUpdate < chosenLastUpdate) {
                    chosenLastUpdate = currentLastUpdate;
                    chosenMirror = mirror;
                }
                oldMirror = mirror;
                mirror = Mirror.chooseMirror(mirrorArr, mirror, name, caller);
                mLog.info("Mirror " + oldMirror.getUrl() + " is out of date or down. Choosing " + mirror.getUrl() + " instead.");
                if (monitor == null) continue;
                monitor.setMessage(mLocalizer.msg("info.4", "Mirror {0} is out of date or down. Choosing {1}", oldMirror.getUrl(), mirror.getUrl()));
                continue;
            }
            catch (TvBrowserException exc) {
                String blockedServer = Mirror.getServerBase(mirror.getUrl());
                BLOCKEDSERVERS.add(blockedServer);
                mLog.info("Server blocked : " + blockedServer);
                if (mirrorArr.length == 1 && mirrorArr[0].equals(mirror)) {
                    return chosenMirror;
                }
                oldMirror = mirror;
                mirror = Mirror.chooseMirror(mirrorArr, mirror, name, caller);
                mLog.info("Mirror " + oldMirror.getUrl() + " is not available. Choosing " + mirror.getUrl() + " instead.");
                if (monitor == null) continue;
                monitor.setMessage(mLocalizer.msg("info.5", "Mirror {0} is not available. Choosing {1}", oldMirror.getUrl(), mirror.getUrl()));
            }
        }
        return chosenMirror;
    }

    private static int daysSinceMirrorLastUpdate(Mirror mirror, String id) throws TvBrowserException {
        final String url = mirror.getUrl() + (mirror.getUrl().endsWith("/") ? "" : "/") + id + "_lastupdate";
        mMirrorDownloadRunning = true;
        mMirrorDownloadData = null;
        mDownloadException = false;
        mLog.info("Loading MirrorDate from " + url);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Mirror.access$002(IOUtilities.loadFileFromHttpServer(new URL(url), 10000));
                }
                catch (Exception e) {
                    mDownloadException = true;
                }
                mMirrorDownloadRunning = false;
            }
        }, "Load mirror date from " + url).start();
        int num = 0;
        while (mMirrorDownloadRunning && num < 100) {
            ++num;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (mMirrorDownloadRunning || mMirrorDownloadData == null || mDownloadException) {
            mLog.info("Server " + url + " is down!");
            return Integer.MAX_VALUE;
        }
        try {
            String asString = new String(mMirrorDownloadData);
            if (asString.length() > 10) {
                int year = Integer.parseInt(asString.substring(0, 4));
                int month = Integer.parseInt(asString.substring(5, 7));
                int day = Integer.parseInt(asString.substring(8, 10));
                Date lastupdated = new Date(year, month, day);
                mLog.info("Done !");
                return new Date().getNumberOfDaysSince(lastupdated);
            }
        }
        catch (NumberFormatException parseException) {
            mLog.info("The file on the server has the wrong format!");
        }
        return Integer.MAX_VALUE;
    }

    public static void resetBannedServers() {
        BLOCKEDSERVERS.clear();
    }

    static /* synthetic */ byte[] access$002(byte[] x0) {
        mMirrorDownloadData = x0;
        return x0;
    }
}

