/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import util.settings.Property;
import util.settings.PropertyManager;

public class ShortProperty
extends Property {
    private short mDefaultValue;
    private boolean mIsCacheFilled;
    private short mCachedValue;

    public ShortProperty(PropertyManager manager, String key, short defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mIsCacheFilled = false;
    }

    public short getDefault() {
        return this.mDefaultValue;
    }

    public short getShort() {
        if (!this.mIsCacheFilled) {
            String asString = this.getProperty();
            if (asString == null) {
                this.mCachedValue = this.mDefaultValue;
            } else {
                try {
                    this.mCachedValue = Short.parseShort(asString);
                }
                catch (Exception exc) {
                    this.mCachedValue = this.mDefaultValue;
                }
            }
            this.mIsCacheFilled = true;
        }
        return this.mCachedValue;
    }

    public void setShort(short value) {
        if (value == this.mDefaultValue) {
            this.setProperty(null);
        } else {
            this.setProperty(Short.toString(value));
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mIsCacheFilled = false;
    }
}

