/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import devplugin.Version;
import util.settings.Property;
import util.settings.PropertyManager;

public class VersionProperty
extends Property {
    private Version mDefaultValue;
    private Version mCachedValue;

    public VersionProperty(PropertyManager manager, String key, Version defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
    }

    public Version getDefault() {
        return this.mDefaultValue;
    }

    public Version getVersion() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            if (asString != null) {
                if (asString.contains(";")) {
                    String[] parts = asString.split(";");
                    this.mCachedValue = new Version(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
                } else {
                    try {
                        int asInt = Integer.parseInt(asString);
                        int major = asInt / 10000;
                        int minor = asInt % 10000 / 100;
                        int subMinor = asInt % 100;
                        if (asString.length() == 3) {
                            major = asInt / 100;
                            minor = asInt % 100;
                            subMinor = 0;
                        }
                        this.mCachedValue = new Version(major, minor, subMinor);
                        if (this.mCachedValue.getMajor() > 3 || this.mCachedValue.getMajor() == 3 && this.mCachedValue.getMinor() > 33 || this.mCachedValue.getMajor() == 3 && this.mCachedValue.getMinor() == 33 && this.mCachedValue.getSubMinor() >= 51) {
                            this.mCachedValue = new Version(3, 33, 50);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (this.mCachedValue == null) {
                this.mCachedValue = this.mDefaultValue;
            }
        }
        return this.mCachedValue;
    }

    public void setVersion(Version value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        if (value.equals(this.mDefaultValue)) {
            this.setProperty(null);
        } else {
            this.setProperty(value.getMajor() + ";" + value.getMinor() + ";" + value.getSubMinor());
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }
}

