/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Channel;
import devplugin.Plugin;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import util.ui.Localizer;
import util.ui.OrderChooser;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItemList;

public class ChannelChooserDlg
extends JDialog
implements WindowClosingIf {
    private Channel[] mResultChannelArr;
    private Channel[] mChannelArr;
    private OrderChooser mChannelOrderChooser;
    private SelectableItemList mChannelItemList;
    public static final int ORDER_CHOOSER = 0;
    public static final int SELECTABLE_ITEM_LIST = 1;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelChooserDlg.class);

    public ChannelChooserDlg(Window parent, Channel[] channelArr, String description) {
        super(parent);
        this.setModal(true);
        this.init(channelArr, description, 0);
    }

    @Deprecated
    public ChannelChooserDlg(Dialog parent, Channel[] channelArr, String description) {
        this((Window)parent, channelArr, description);
    }

    @Deprecated
    public ChannelChooserDlg(Frame parent, Channel[] channelArr, String description) {
        this((Window)parent, channelArr, description);
    }

    public ChannelChooserDlg(Window parent, Channel[] channelArr, String description, int type) {
        super(parent);
        this.setModal(true);
        this.init(channelArr, description, type);
    }

    @Deprecated
    public ChannelChooserDlg(Dialog parent, Channel[] channelArr, String description, int type) {
        this((Window)parent, channelArr, description, type);
    }

    @Deprecated
    public ChannelChooserDlg(Frame parent, Channel[] channelArr, String description, int type) {
        this((Window)parent, channelArr, description, type);
    }

    private void init(Channel[] channelArr, String description, int type) {
        this.setTitle(mLocalizer.msg("chooseChannels", "choose channels"));
        UiUtilities.registerForClosing(this);
        if (channelArr == null) {
            this.mChannelArr = new Channel[0];
            this.mResultChannelArr = new Channel[0];
        } else {
            this.mChannelArr = channelArr;
            this.mResultChannelArr = channelArr;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        FormLayout layout = new FormLayout("fill:pref:grow", "");
        contentPane.setLayout(layout);
        contentPane.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        if (type == 0) {
            this.mChannelOrderChooser = new OrderChooser(this.mResultChannelArr, Plugin.getPluginManager().getSubscribedChannels());
            this.mChannelItemList = null;
        } else {
            this.mChannelItemList = new SelectableItemList(this.mResultChannelArr, Plugin.getPluginManager().getSubscribedChannels());
            this.mChannelOrderChooser = null;
        }
        int pos = 1;
        layout.appendRow(RowSpec.decode("fill:default:grow"));
        layout.appendRow(RowSpec.decode("3dlu"));
        if (this.mChannelOrderChooser != null) {
            contentPane.add((Component)this.mChannelOrderChooser, cc.xy(1, pos));
        } else {
            contentPane.add((Component)this.mChannelItemList, cc.xy(1, pos));
        }
        pos += 2;
        if (description != null) {
            JLabel lb = new JLabel(description);
            layout.appendRow(RowSpec.decode("pref"));
            layout.appendRow(RowSpec.decode("3dlu"));
            contentPane.add((Component)lb, cc.xy(1, pos));
            pos += 2;
        }
        JButton okBt = new JButton(Localizer.getLocalization("i18n_ok"));
        JButton cancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        okBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object[] o = ChannelChooserDlg.this.mChannelOrderChooser != null ? ChannelChooserDlg.this.mChannelOrderChooser.getOrder() : ChannelChooserDlg.this.mChannelItemList.getSelection();
                ChannelChooserDlg.access$202(ChannelChooserDlg.this, new Channel[o.length]);
                for (int i = 0; i < o.length; ++i) {
                    ((ChannelChooserDlg)ChannelChooserDlg.this).mResultChannelArr[i] = (Channel)o[i];
                }
                ChannelChooserDlg.this.setVisible(false);
            }
        });
        cancelBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChannelChooserDlg.access$202(ChannelChooserDlg.this, null);
                ChannelChooserDlg.this.setVisible(false);
            }
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton(okBt, cancelBt);
        layout.appendRow(RowSpec.decode("pref"));
        contentPane.add((Component)builder.getPanel(), cc.xy(1, pos));
        this.pack();
    }

    public Channel[] getChannels() {
        if (this.mResultChannelArr == null) {
            return this.mChannelArr;
        }
        return this.mResultChannelArr;
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    static /* synthetic */ Channel[] access$202(ChannelChooserDlg x0, Channel[] x1) {
        x0.mResultChannelArr = x1;
        return x1;
    }
}

