/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import util.ui.AlphaColorChooser;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class ColorButton
extends JButton
implements ActionListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ColorButton.class);
    private Color mColor;
    private Color mStandardColor;

    public ColorButton() {
        this.mColor = Color.BLACK;
        this.mStandardColor = null;
        this.updateIcon();
        this.addActionListener(this);
    }

    public ColorButton(Color color) {
        this.mColor = color;
        this.mStandardColor = null;
        this.updateIcon();
        this.addActionListener(this);
    }

    private void updateIcon() {
        this.setIcon(this.createIcon());
    }

    private Icon createIcon() {
        BufferedImage img = new BufferedImage(50, 10, 1);
        Graphics2D g = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(img);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 50, 10);
        g.setColor(this.mColor);
        g.fillRect(0, 0, 50, 10);
        ImageIcon icon = new ImageIcon(img);
        return icon;
    }

    public void setStandardColor(Color color) {
        this.mStandardColor = color;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.mColor = AlphaColorChooser.showDialog(UiUtilities.getBestDialogParent(this.getParent()), mLocalizer.msg("ChooseColor", "Please choose the Color"), this.mColor, this.mStandardColor);
        this.updateIcon();
    }

    public void setColor(Color c) {
        this.mColor = c;
        this.updateIcon();
    }

    public Color getColor() {
        return this.mColor;
    }
}

