/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class CreditsScrollerPanel
extends JScrollPane
implements ActionListener {
    private int scrollOffset;
    private Timer timer;
    private boolean firstTime = true;
    private int locationY;

    private CreditsScrollerPanel(JComponent component, int delay, int scrollOffset) {
        super(component);
        this.scrollOffset = scrollOffset;
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
        component.setVisible(false);
        this.getViewport().setBackground(component.getBackground());
        this.timer = new Timer(delay, this);
    }

    public void startScrolling() {
        JComponent component = (JComponent)this.getViewport().getView();
        this.locationY = this.getViewport().getExtentSize().height;
        component.setVisible(true);
        component.setLocation(0, this.locationY);
        this.timer.start();
    }

    public void stopScrolling() {
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent component = (JComponent)this.getViewport().getView();
        this.locationY -= this.scrollOffset;
        component.setLocation(0, this.locationY);
        if (component.getPreferredSize().height + this.locationY < 0) {
            this.locationY = this.getViewport().getExtentSize().height;
            component.setVisible(true);
            component.setLocation(0, this.locationY);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D g2 = (Graphics2D)graphics;
        int w = this.getWidth();
        int h = 70;
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 255), 2.0f, h, new Color(255, 255, 255, 0), false);
        g2.setPaint(gradient);
        g2.fillRect(0, 0, w, h);
        gradient = new GradientPaint(0.0f, this.getHeight() - h, new Color(255, 255, 255, 0), 2.0f, this.getHeight(), new Color(255, 255, 255, 255), false);
        g2.setPaint(gradient);
        g2.fillRect(0, this.getHeight() - h, w, h);
    }

    public static CreditsScrollerPanel createScroller(String text) {
        JEditorPane textPane = new JEditorPane();
        textPane.setEditable(false);
        textPane.setContentType("text/html");
        textPane.setText(text);
        return new CreditsScrollerPanel(textPane, 50, 1);
    }
}

