/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.ui.Localizer;

public class DirectoryChooserPanel
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DirectoryChooserPanel.class);
    private JTextField mTextField;
    private JButton mBtn;
    private JLabel mLabel;

    public DirectoryChooserPanel(String title, String text) {
        this(title, text, true);
    }

    public DirectoryChooserPanel(String title, String text, boolean leftBorder) {
        this.setLayout(new BorderLayout(7, 0));
        this.mLabel = new JLabel(title);
        if (leftBorder) {
            this.mLabel.setBorder(BorderFactory.createEmptyBorder(0, 13, 0, 0));
        }
        this.add((Component)this.mLabel, "West");
        this.mTextField = new JTextField(text);
        this.add((Component)this.mTextField, "Center");
        this.mBtn = new JButton(mLocalizer.msg("change", "change"));
        this.mBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setApproveButtonText("Ok");
                fc.setCurrentDirectory(new File(DirectoryChooserPanel.this.mTextField.getText()));
                int retVal = fc.showOpenDialog(DirectoryChooserPanel.this.getParent());
                if (retVal == 0) {
                    File f = fc.getSelectedFile();
                    DirectoryChooserPanel.this.mTextField.setText(f.getAbsolutePath());
                }
            }
        });
        this.add((Component)this.mBtn, "East");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mTextField.setEnabled(enabled);
        this.mBtn.setEnabled(enabled);
        this.mLabel.setEnabled(enabled);
    }

    public String getText() {
        return this.mTextField.getText();
    }
}

