/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import util.ui.ListDropAction;

public class DragAndDropMouseListener
extends MouseAdapter {
    private int mLastSelectedIndex = 0;
    private JList mSource;
    private JList mTarget;
    private ListDropAction mAction;
    private DragGestureListener mListener;
    private boolean mMoveWithDoubleClick;

    public DragAndDropMouseListener(JList source, JList target, ListDropAction action, DragGestureListener listener) {
        this(source, target, action, listener, true);
    }

    public DragAndDropMouseListener(JList source, JList target, ListDropAction action, DragGestureListener listener, boolean moveWithDoubleClick) {
        this.mSource = source;
        this.mTarget = target;
        this.mAction = action;
        this.mListener = listener;
        this.mMoveWithDoubleClick = moveWithDoubleClick;
        this.restore();
    }

    public void restore() {
        MouseListener[] listeners = this.mSource.getMouseListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] instanceof ToolTipManager) continue;
            this.mSource.removeMouseListener(listeners[i]);
        }
        MouseMotionListener[] mlisteners = this.mSource.getMouseMotionListeners();
        for (int i = 0; i < mlisteners.length; ++i) {
            if (mlisteners[i] instanceof ToolTipManager) continue;
            this.mSource.removeMouseMotionListener(mlisteners[i]);
        }
        new DragSource().createDefaultDragGestureRecognizer(this.mSource, 2, this.mListener);
        this.mSource.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mSource.isEnabled() && !this.mSource.hasFocus()) {
            this.mSource.requestFocusInWindow();
        }
        if (this.mSource.isEnabled() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && this.mSource != this.mTarget && this.mMoveWithDoubleClick) {
            int index = this.mSource.locationToIndex(e.getPoint());
            this.mSource.setSelectedIndex(index);
            this.mAction.drop(this.mSource, this.mTarget, 0, true);
            this.mLastSelectedIndex = index;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mSource.isEnabled()) {
            int index;
            DefaultListSelectionModel model;
            if (e.isShiftDown() && SwingUtilities.isLeftMouseButton(e)) {
                int index2 = this.mSource.locationToIndex(e.getPoint());
                this.mSource.setSelectionInterval(index2, this.mLastSelectedIndex);
            } else if (!e.isControlDown() && !e.isShiftDown() && SwingUtilities.isLeftMouseButton(e) && !(model = (DefaultListSelectionModel)this.mSource.getSelectionModel()).isSelectedIndex(index = this.mSource.locationToIndex(e.getPoint()))) {
                this.mSource.setSelectedIndex(index);
                this.mLastSelectedIndex = index;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int index = this.mSource.locationToIndex(e.getPoint());
        if (this.mSource.isEnabled()) {
            if (e.isControlDown() && SwingUtilities.isLeftMouseButton(e)) {
                DefaultListSelectionModel model = (DefaultListSelectionModel)this.mSource.getSelectionModel();
                if (model.isSelectedIndex(index)) {
                    model.removeSelectionInterval(index, index);
                } else {
                    model.addSelectionInterval(index, index);
                }
                this.mLastSelectedIndex = index;
            } else if (!e.isShiftDown() && !e.isControlDown() && SwingUtilities.isLeftMouseButton(e)) {
                this.mSource.setSelectedIndex(index);
                this.mLastSelectedIndex = index;
            }
        }
    }
}

