/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Plugin;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.GlobalPluginProgramFormatingSettings;
import tvbrowser.ui.settings.SettingsDialog;
import util.program.AbstractPluginProgramFormating;
import util.program.LocalPluginProgramFormating;
import util.ui.LocalPluginProgramFormatingSettingsDialog;
import util.ui.Localizer;
import util.ui.OrderChooser;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class PluginProgramConfigurationPanel
extends JPanel
implements ActionListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginProgramConfigurationPanel.class);
    private OrderChooser mOrder;
    private JButton mAdd;
    private JButton mEdit;
    private JButton mDelete;
    private LocalPluginProgramFormating mDefaultLocalFormating;
    private boolean mShowTitleSetting;
    private boolean mShowEncodingSetting;
    private JEditorPane mHelpLabel;

    public PluginProgramConfigurationPanel(AbstractPluginProgramFormating[] selectedValues, LocalPluginProgramFormating[] availableLocalFormatings, LocalPluginProgramFormating defaultLocalFormating, boolean showTitleSetting, boolean showEncodingSetting) {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu,default:grow,5dlu", "pref,fill:default:grow,5dlu,pref,10dlu,pref"), this);
        this.mDefaultLocalFormating = defaultLocalFormating == null ? new LocalPluginProgramFormating("Plugin - Default", "{title}", "{channel_name} - {title}\n{leadingZero(start_day,\"2\")}.{leadingZero(start_month,\"2\")}.{start_year} {leadingZero(start_hour,\"2\")}:{leadingZero(start_minute,\"2\")}-{leadingZero(end_hour,\"2\")}:{leadingZero(end_minute,\"2\")}\n\n{splitAt(short_info,\"78\")}\n\n", "UTF-8") : defaultLocalFormating;
        this.mShowTitleSetting = showTitleSetting;
        this.mShowEncodingSetting = showEncodingSetting;
        AbstractPluginProgramFormating[] availableGlobalFormatings = Plugin.getPluginManager().getAvailableGlobalPuginProgramFormatings();
        if (availableLocalFormatings == null) {
            availableLocalFormatings = new LocalPluginProgramFormating[]{this.mDefaultLocalFormating};
        }
        ArrayList<AbstractPluginProgramFormating> formatingsList = new ArrayList<AbstractPluginProgramFormating>();
        for (AbstractPluginProgramFormating abstractPluginProgramFormating : availableGlobalFormatings) {
            if (abstractPluginProgramFormating == null) continue;
            formatingsList.add(abstractPluginProgramFormating);
        }
        for (AbstractPluginProgramFormating abstractPluginProgramFormating : availableLocalFormatings) {
            if (abstractPluginProgramFormating == null) continue;
            formatingsList.add(abstractPluginProgramFormating);
        }
        Object[] allArr = formatingsList.toArray(new AbstractPluginProgramFormating[formatingsList.size()]);
        FormLayout layout = new FormLayout("default,5dlu,default,5dlu,default", "pref");
        layout.setColumnGroups(new int[][]{{1, 3, 5}});
        JPanel buttonPanel = new JPanel(layout);
        this.mAdd = new JButton(Localizer.getLocalization("i18n_add"));
        this.mAdd.setIcon(TVBrowserIcons.newIcon(16));
        this.mAdd.addActionListener(this);
        this.mEdit = new JButton(Localizer.getLocalization("i18n_edit"));
        this.mEdit.setIcon(TVBrowserIcons.edit(16));
        this.mEdit.setEnabled(false);
        this.mEdit.addActionListener(this);
        this.mDelete = new JButton(Localizer.getLocalization("i18n_delete"));
        this.mDelete.setIcon(TVBrowserIcons.delete(16));
        this.mDelete.setEnabled(false);
        this.mDelete.addActionListener(this);
        buttonPanel.add((Component)this.mAdd, cc.xy(1, 1));
        buttonPanel.add((Component)this.mEdit, cc.xy(3, 1));
        buttonPanel.add((Component)this.mDelete, cc.xy(5, 1));
        this.mOrder = new OrderChooser(selectedValues == null ? allArr : selectedValues, allArr);
        this.mOrder.setSelectionMode(0);
        this.mOrder.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PluginProgramConfigurationPanel.this.mEdit.setEnabled(PluginProgramConfigurationPanel.this.mOrder.getSelectedValue() instanceof LocalPluginProgramFormating);
                    PluginProgramConfigurationPanel.this.mDelete.setEnabled(PluginProgramConfigurationPanel.this.mOrder.getSelectedValue() instanceof LocalPluginProgramFormating);
                }
            }
        });
        this.mOrder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2 && PluginProgramConfigurationPanel.this.mOrder.getSelectedValue() instanceof LocalPluginProgramFormating) {
                    LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), (LocalPluginProgramFormating)PluginProgramConfigurationPanel.this.mOrder.getSelectedValue(), PluginProgramConfigurationPanel.this.mDefaultLocalFormating, PluginProgramConfigurationPanel.this.mShowTitleSetting, PluginProgramConfigurationPanel.this.mShowEncodingSetting);
                    PluginProgramConfigurationPanel.this.mOrder.refreshList();
                }
            }
        });
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("help", "This list contains formattings that are provided by the plugin itself and formating available for all plugins. You can configure formatings, that are provided by the plugin itself, direct here. The formatings that are available for all plugins can be configured in <a href=\"#link\">{0}</a>.", GlobalPluginProgramFormatingSettings.mLocalizer.msg("title", "Plugin program formating")), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#pluginprogramformat");
                }
            }
        });
        pb.addLabel(mLocalizer.msg("title", "Formatings that should be shown for selection in the context menu:"), cc.xy(2, 1));
        pb.add((Component)this.mOrder, cc.xy(2, 2));
        pb.add((Component)buttonPanel, cc.xy(2, 4));
        pb.add((Component)this.mHelpLabel, cc.xy(2, 6));
    }

    public AbstractPluginProgramFormating[] getSelectedPluginProgramFormatings() {
        Object[] o = this.mOrder.getOrder();
        AbstractPluginProgramFormating[] configs = new AbstractPluginProgramFormating[o.length];
        for (int i = 0; i < o.length; ++i) {
            configs[i] = (AbstractPluginProgramFormating)o[i];
        }
        return configs;
    }

    public LocalPluginProgramFormating[] getAvailableLocalPluginProgramFormatings() {
        Object[] order = this.mOrder.getOrder();
        ArrayList<LocalPluginProgramFormating> list = new ArrayList<LocalPluginProgramFormating>();
        for (Object value : order) {
            if (!(value instanceof LocalPluginProgramFormating)) continue;
            list.add((LocalPluginProgramFormating)value);
        }
        return list.toArray(new LocalPluginProgramFormating[list.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mAdd) {
            LocalPluginProgramFormating newFormatting = new LocalPluginProgramFormating(mLocalizer.msg("newName", "New formatting"), this.mDefaultLocalFormating.getTitleValue(), this.mDefaultLocalFormating.getContentValue(), this.mDefaultLocalFormating.getEncodingValue());
            this.mOrder.addElement(newFormatting);
            this.mOrder.setSelectedIndex(this.mOrder.getItemCount() - 1);
            LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), (LocalPluginProgramFormating)this.mOrder.getSelectedValue(), this.mDefaultLocalFormating, this.mShowTitleSetting, this.mShowEncodingSetting);
            this.mOrder.refreshList();
        } else if (e.getSource() == this.mDelete) {
            int index = this.mOrder.getSelectedIndex();
            this.mOrder.removeElementAt(index);
            this.mOrder.setSelectedIndex(index);
        } else if (e.getSource() == this.mEdit) {
            LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), (LocalPluginProgramFormating)this.mOrder.getSelectedValue(), this.mDefaultLocalFormating, this.mShowTitleSetting, this.mShowEncodingSetting);
            this.mOrder.refreshList();
        }
    }
}

