/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.ContextMenuIf;
import devplugin.Marker;
import devplugin.Plugin;
import devplugin.PluginAccess;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramInfoHelper;
import devplugin.ToolTipIcon;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.icontheme.InfoIconTheme;
import tvbrowser.core.icontheme.InfoThemeLoader;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.PluginStateListener;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import util.io.IOUtilities;
import util.misc.StringPool;
import util.program.ProgramUtilities;
import util.programmouseevent.ProgramMouseAndContextMenuListener;
import util.programmouseevent.ProgramMouseEventHandler;
import util.settings.ProgramPanelSettings;
import util.ui.ChannelLabel;
import util.ui.Localizer;
import util.ui.MultipleFieldReader;
import util.ui.PictureAreaIcon;
import util.ui.TextAreaIcon;
import util.ui.TimeFormatter;

public class ProgramPanel
extends JComponent
implements ChangeListener,
PluginStateListener {
    private static final Logger mLog = Logger.getLogger(TextAreaIcon.class.getName());
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramPanel.class);
    private static final boolean USE_FULL_HEIGHT = true;
    private static final Composite NORMAL_COMPOSITE = AlphaComposite.SrcOver;
    private static final Composite PALE_COMPOSITE = AlphaComposite.getInstance(3, 0.5f);
    private int mMarkTime;
    private static Font mTitleFont;
    private static Font mTimeFont;
    private static Font mNormalFont;
    private static int fontSizeOffset;
    private static int columnWidthOffset;
    public static int WIDTH_LEFT;
    private static int WIDTH_RIGHT;
    private static int WIDTH_TOTAL;
    private static final TimeFormatter TIME_FORMATTER;
    private static final int ICON_DISTANCE_X = 2;
    private static final int ICON_DISTANCE_Y = 2;
    private int mHeight = 0;
    private int mPreferredHeight = 0;
    private ChannelLabel mChannelLabel;
    private String mProgramTimeAsString;
    private TextAreaIcon mTitleIcon;
    private TextAreaIcon mDescriptionIcon;
    private PictureAreaIcon mPictureAreaIcon;
    private Icon[] mIconArr;
    private Program mProgram;
    private Color mTextColor = !Settings.propTableBackgroundStyle.getString().equals("uiColor") && !Settings.propTableBackgroundStyle.getString().equals("uiTimeBlock") ? Settings.propProgramPanelForegroundColor.getColor() : UIManager.getColor("List.foreground");
    private boolean mMouseOver = false;
    private boolean mIsSelected = false;
    private boolean mHasChanged = false;
    private int mAxis = 1;
    private static int V_GAP;
    private ProgramPanelSettings mSettings;
    private boolean mPaintExpiredProgramsPale = true;
    private Rectangle mInfoIconRect;
    private byte mProgramImportance;
    private int mLogoWidth = 0;
    int textIconWidth = -1;

    public ProgramPanel() {
        this(new ProgramPanelSettings(Settings.propPictureType.getInt(), Settings.propPictureStartTime.getInt(), Settings.propPictureEndTime.getInt(), false, Settings.propIsPictureShowingDescription.getBoolean(), Settings.propPictureDuration.getInt(), Settings.propPicturePluginIds.getStringArray(), 1, false, Settings.propShowProgramTablePictureBorder.getBoolean(), false));
    }

    public ProgramPanel(ProgramPanelSettings settings) {
        this.setToolTipText("");
        this.mSettings = settings;
        this.mAxis = settings.getAxis();
        this.mMarkTime = -1;
        if (mTitleFont == null) {
            ProgramPanel.updateFonts();
        }
        this.calculateWidth();
        int minWidth = Math.max(WIDTH_RIGHT - 5 - this.mLogoWidth, 55 - WIDTH_LEFT);
        this.mTitleIcon = new TextAreaIcon(null, mTitleFont, minWidth);
        this.mDescriptionIcon = new TextAreaIcon(null, mNormalFont, minWidth);
        this.mDescriptionIcon.setMaximumLineCount(3);
        this.setBackground(UIManager.getColor("programPanel.background"));
    }

    public ProgramPanel(Program prog) {
        this();
        this.setProgram(prog);
    }

    public ProgramPanel(Program prog, ProgramPanelSettings settings) {
        this(settings);
        this.setProgram(prog);
    }

    public ProgramPanel(Program prog, int axis, ProgramPanelSettings settings) {
        this(settings);
        this.mAxis = axis;
        this.setProgram(prog);
    }

    private void calculateWidth() {
        if (this.mSettings.isShowingChannelLogo()) {
            this.mLogoWidth = 46;
        }
        if (WIDTH_LEFT == -1) {
            int distance = this.getFontMetrics(mTitleFont).stringWidth("n");
            if (distance > 7) {
                distance = 7;
            }
            WIDTH_LEFT = this.getFontMetrics(mTimeFont).stringWidth(TIME_FORMATTER.formatTime(23, 59)) + distance;
            WIDTH_RIGHT = Settings.propColumnWidth.getInt() + columnWidthOffset - WIDTH_LEFT;
            if (WIDTH_RIGHT - 5 < 50) {
                WIDTH_RIGHT = 50;
            }
            WIDTH_TOTAL = WIDTH_LEFT + WIDTH_RIGHT;
        }
    }

    public static boolean updateFonts(int newOffset) {
        Font oldTitleFont = mTitleFont;
        Font oldTimeFont = mTimeFont;
        Font oldNormalFont = mNormalFont;
        boolean useDefaults = Settings.propUseDefaultFonts.getBoolean();
        if (useDefaults) {
            mTitleFont = Settings.propProgramTitleFont.getDefault();
            mTimeFont = Settings.propProgramTimeFont.getDefault();
            mNormalFont = Settings.propProgramInfoFont.getDefault();
        } else {
            mTitleFont = Settings.propProgramTitleFont.getFont();
            mTimeFont = Settings.propProgramTimeFont.getFont();
            mNormalFont = Settings.propProgramInfoFont.getFont();
        }
        fontSizeOffset = newOffset == 0 ? 0 : (fontSizeOffset += newOffset);
        if (fontSizeOffset != 0) {
            mTitleFont = ProgramPanel.getDynamicFontSize(mTitleFont, fontSizeOffset);
            mTimeFont = ProgramPanel.getDynamicFontSize(mTimeFont, fontSizeOffset);
            mNormalFont = ProgramPanel.getDynamicFontSize(mNormalFont, fontSizeOffset);
        }
        if (mTitleFont.equals(oldTitleFont) && mTimeFont.equals(oldTimeFont) && mNormalFont.equals(oldNormalFont)) {
            return false;
        }
        WIDTH_LEFT = -1;
        return true;
    }

    private static Font getDynamicFontSize(Font font, int offset) {
        float size = font.getSize2D() + (float)offset;
        if (size < 4.0f) {
            size = 4.0f;
        }
        return font.deriveFont(size);
    }

    public static void updateFonts() {
        ProgramPanel.updateFonts(0);
    }

    public void setProgramPanelSettings(ProgramPanelSettings settings) {
        this.mSettings = settings;
    }

    public void forceRepaint() {
        this.calculateWidth();
        this.mTitleIcon = new TextAreaIcon(null, mTitleFont, WIDTH_RIGHT - 5);
        this.mDescriptionIcon = new TextAreaIcon(null, mNormalFont, WIDTH_RIGHT - 5);
        this.mDescriptionIcon.setMaximumLineCount(Settings.propProgramPanelMaxLines.getInt());
        this.mProgram.validateMarking();
        Program p = this.mProgram;
        this.mProgram = null;
        this.setProgram(p);
    }

    public static void updateColumnWidth() {
        ProgramPanel.updateColumnWidth(0);
    }

    public static int updateColumnWidth(int newOffset) {
        columnWidthOffset = newOffset == 0 ? 0 : (columnWidthOffset += 20 * newOffset);
        int columnWidth = Settings.propColumnWidth.getInt() + columnWidthOffset;
        if (columnWidth < 120) {
            columnWidthOffset = 120 - Settings.propColumnWidth.getInt();
        }
        if (columnWidth > 600) {
            columnWidthOffset = 600 - Settings.propColumnWidth.getInt();
        }
        columnWidth = Settings.propColumnWidth.getInt() + columnWidthOffset;
        WIDTH_RIGHT = columnWidth - WIDTH_LEFT;
        WIDTH_TOTAL = WIDTH_LEFT + WIDTH_RIGHT;
        return columnWidth;
    }

    public int getPreferredHeight() {
        return this.mPreferredHeight;
    }

    public void setHeight(int height) {
        if (this.mHeight != height) {
            this.setProgram(this.getProgram(), height);
            this.mHeight = height;
        }
    }

    public void setMaximumHeight() {
        this.setProgram(this.getProgram(), 10000);
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    public void setProgram(Program program) {
        this.setProgram(program, -1);
    }

    private boolean dontShowPictureAreaIcon(boolean dontShow) {
        if (this.mSettings.isShowingPictureForPlugins()) {
            String[] pluginIds = this.mSettings.getPluginIds();
            Marker[] markers = this.mProgram.getMarkerArr();
            if (markers != null && pluginIds != null) {
                block0: for (Marker marker : markers) {
                    for (String pluginId : pluginIds) {
                        if (marker.getId().compareTo(pluginId) != 0) continue;
                        dontShow = false;
                        continue block0;
                    }
                }
            }
        }
        return dontShow;
    }

    public boolean pictureStateChanged() {
        boolean show = this.showPicture(this.mProgram, this.dontShowPictureAreaIcon(true));
        if (!show && this.mPictureAreaIcon.getIconHeight() > 0 || show && this.mPictureAreaIcon.getIconHeight() == 0) {
            return this.mProgram.hasFieldValue(ProgramFieldType.PICTURE_TYPE);
        }
        return false;
    }

    public void setProgram(Program program, int maxHeight) {
        int additionalHeight;
        int maxDescLines;
        boolean programChanged;
        Program oldProgram = this.mProgram;
        this.mProgram = program;
        if (Settings.propProgramTableCutTitle.getBoolean()) {
            this.mTitleIcon.setMaximumLineCount(Settings.propProgramTableCutTitleLines.getInt());
        } else {
            this.mTitleIcon.setMaximumLineCount(-1);
        }
        this.mDescriptionIcon.setMaximumLineCount(-1);
        if (this.mSettings.isShowingChannelLogo()) {
            try {
                this.mChannelLabel = new ChannelLabel(true, false, false, false, false, false, false);
                this.mChannelLabel.setChannel(program.getChannel());
            }
            catch (Exception e) {
                mLog.log(Level.SEVERE, "Could not load channelLabel for program '" + program + "'", e);
            }
        }
        boolean bl = programChanged = oldProgram == null || !oldProgram.equals(program);
        if (programChanged) {
            this.mProgramTimeAsString = StringPool.getString(program.getTimeString());
            this.mTitleIcon.setText(program.getTitle());
            if (this.mProgram.getProgramState() == 0) {
                this.programHasChanged();
            }
        }
        int length = program.getLength();
        if (this.showPicture(program, this.dontShowPictureAreaIcon(true))) {
            int pictureWidth = Math.max(WIDTH_RIGHT - 4 - this.mLogoWidth, 56 - WIDTH_LEFT);
            if (this.textIconWidth - 156 > 0) {
                pictureWidth = Math.min(156, this.textIconWidth);
            }
            this.mPictureAreaIcon = new PictureAreaIcon(program, mNormalFont, pictureWidth, this.mSettings.isShowingPictureDescription(), true, false, this.mSettings.isShowingPictureBorder());
        } else {
            this.mPictureAreaIcon = new PictureAreaIcon();
        }
        int titleHeight = this.mTitleIcon.getIconHeight();
        if (Settings.propProgramPanelShortDurationActive.getBoolean() && length >= 0 && length <= Settings.propProgramPanelShortDurationMinutes.getInt()) {
            maxDescLines = 0;
            this.mDescriptionIcon.setText("");
            this.mDescriptionIcon.setMaximumLineCount(0);
        } else {
            maxDescLines = Settings.propProgramPanelMaxLines.getInt();
        }
        int n = additionalHeight = Settings.propProgramPanelUsesExtraSpaceForMarkIcons.getBoolean() && program.getMarkerArr().length > 0 ? 16 : 0;
        if (maxHeight != -1) {
            maxDescLines = (maxHeight - titleHeight - this.mPictureAreaIcon.getIconHeight() - additionalHeight - V_GAP) / mNormalFont.getSize();
        }
        if (programChanged || maxDescLines != this.mDescriptionIcon.getMaximumLineCount()) {
            int descHeight = 0;
            if (!this.mSettings.isShowingOnlyDateAndTitle() && program.getProgramState() == 0 && maxDescLines > 0) {
                this.mDescriptionIcon.setMaximumLineCount(maxDescLines);
                ProgramFieldType[] infoFieldArr = Settings.propProgramInfoFields.getProgramFieldTypeArray();
                String[] infoFieldSeparatorArr = Settings.propProgramInfoFieldsSeparators.getStringArray();
                MultipleFieldReader infoReader = new MultipleFieldReader(program, infoFieldArr, infoFieldSeparatorArr);
                try {
                    this.mDescriptionIcon.setText(infoReader);
                }
                catch (IOException exc) {
                    mLog.log(Level.WARNING, "Reading program info failed for " + program, exc);
                }
                descHeight = this.mDescriptionIcon.getIconHeight();
            } else {
                descHeight = 0;
            }
            int height = titleHeight + descHeight + this.mPictureAreaIcon.getIconHeight() + additionalHeight + V_GAP;
            this.mHeight = this.mChannelLabel != null ? Math.max(height, this.mChannelLabel.getPreferredSize().height) : height;
            this.setPreferredSize(new Dimension(WIDTH_TOTAL, this.mHeight));
            this.mPreferredHeight = titleHeight + maxDescLines * mNormalFont.getSize() + this.mPictureAreaIcon.getIconHeight() + additionalHeight + V_GAP;
            if (this.mHeight < this.mPreferredHeight) {
                this.mPreferredHeight = this.mHeight;
            }
        }
        if (this.isShowing()) {
            if (oldProgram != null) {
                oldProgram.removeChangeListener(this);
            }
            this.mProgram.addChangeListener(this);
            this.revalidate();
            this.repaint();
        }
    }

    private boolean showPicture(Program program, boolean dontShow) {
        if (!this.mSettings.isShowingOnlyDateAndTitle() && program.getProgramState() == 0 && this.mProgram.hasFieldValue(ProgramFieldType.PICTURE_TYPE) && (this.mSettings.isShowingPictureEver() || !dontShow || this.mSettings.isShowingPictureInTimeRange() && !ProgramUtilities.isNotInTimeRange(this.mSettings.getPictureTimeRangeStart(), this.mSettings.getPictureTimeRangeEnd(), program) || this.mSettings.isShowingPictureForDuration() && this.mSettings.getDuration() <= program.getLength()) || this.mSettings.isShowingPictureForFilter() && GenericFilterMap.getInstance().getGenericPictureFilter().accept(program)) {
            dontShow = false;
        }
        return !dontShow;
    }

    private Icon[] getPluginIcons(Program program) {
        String[] iconPluginArr = Settings.propProgramTableIconPlugins.getStringArray();
        if (program.getProgramState() != 0 || iconPluginArr == null || iconPluginArr.length == 0) {
            return new Icon[0];
        }
        PluginProxyManager mng = PluginProxyManager.getInstance();
        ArrayList<Icon> iconList = new ArrayList<Icon>();
        int info = program.getInfo();
        int[] infoBits = ProgramInfoHelper.getInfoBits();
        Icon[] infoIcons = ProgramInfoHelper.getInfoIcons();
        for (int pluginIdx = 0; pluginIdx < iconPluginArr.length; ++pluginIdx) {
            Icon[] iconArr;
            String asId;
            if (iconPluginArr[pluginIdx].equals("info.id")) {
                if (info == -1 || info == 0) continue;
                for (int i = 0; i < infoBits.length; ++i) {
                    if (!ProgramInfoHelper.bitSet(info, infoBits[i]) || infoIcons[i] == null) continue;
                    iconList.add(infoIcons[i]);
                }
                continue;
            }
            if (iconPluginArr[pluginIdx].equals("picture.id")) {
                if (!this.mProgram.hasFieldValue(ProgramFieldType.PICTURE_TYPE)) continue;
                iconList.add(InfoThemeLoader.getInstance().getIconThemeForIDOrDefault(Settings.propInfoIconThemeID.getString()).getInfoIcon(InfoIconTheme.INFO_HAS_PICTURE));
                continue;
            }
            if (iconPluginArr[pluginIdx].startsWith("FORMAT")) {
                int index;
                if (info == -1 || info == 0 || !ProgramInfoHelper.bitSet(info, infoBits[index = Integer.valueOf(iconPluginArr[pluginIdx].substring(7)).intValue()]) || infoIcons[index] == null) continue;
                iconList.add(infoIcons[index]);
                continue;
            }
            PluginProxy plugin = mng.getPluginForId(iconPluginArr[pluginIdx]);
            if (plugin == null && (plugin = mng.getPluginForId(asId = "java." + iconPluginArr[pluginIdx])) != null) {
                iconPluginArr[pluginIdx] = asId;
                Settings.propProgramTableIconPlugins.setStringArray(iconPluginArr);
            }
            if (plugin == null || !plugin.isActivated() || (iconArr = plugin.getProgramTableIcons(program)) == null) continue;
            for (Icon icon : iconArr) {
                iconList.add(icon);
            }
        }
        return iconList.toArray(new Icon[iconList.size()]);
    }

    @Override
    public void paintComponent(Graphics g) {
        Color c;
        Marker[] markedByPluginArr;
        if (this.mHasChanged) {
            this.mIconArr = this.getPluginIcons(this.mProgram);
            this.mProgramImportance = (byte)(!this.mSettings.isIgnoringProgramImportance() ? (int)ProgramUtilities.getProgramImportance(this.mProgram) : 10);
            this.mHasChanged = false;
        }
        if (this.mSettings.isIgnoringProgramImportance() || this.mProgram.getProgramState() == 2) {
            this.mProgramImportance = (byte)10;
        }
        if (this.mProgram.getProgramState() == 2) {
            this.setForeground(Color.red);
            this.mTextColor = Color.red;
        } else if (this.mProgram.getProgramState() == 1) {
            this.setForeground(Color.blue);
            this.mTextColor = Color.blue;
        }
        int width = this.getWidth();
        if (this.getTextIconWidth(width) != this.mDescriptionIcon.getIconWidth()) {
            this.recreateTextIcons(width);
        }
        int height = this.getHeight();
        Graphics2D grp = (Graphics2D)g;
        if (Settings.propEnableAntialiasing.getBoolean()) {
            grp.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Color lightBackground = Settings.propProgramTableColorOnAirLight.getColor();
        Color darkBackground = Settings.propProgramTableColorOnAirDark.getColor();
        int minutesAfterMidnight = IOUtilities.getMinutesAfterMidnight();
        if (this.mMarkTime >= 0 && Settings.propScrollToTimeMarkingActivated.getBoolean()) {
            minutesAfterMidnight = this.mMarkTime;
            lightBackground = Settings.propScrollToTimeProgramsLightBackground.getColor();
            darkBackground = Settings.propScrollToTimeProgramsDarkBackground.getColor();
        }
        if (this.mProgram.isOnAir() || this.mMarkTime >= 0 && Settings.propScrollToTimeMarkingActivated.getBoolean()) {
            Color c2;
            int borderWidth;
            int progLength = this.mProgram.getLength();
            int startTime = this.mProgram.getStartTime();
            int elapsedMinutes = minutesAfterMidnight - startTime;
            if (elapsedMinutes < 0) {
                elapsedMinutes += 1440;
            }
            if (progLength > 0) {
                if (elapsedMinutes > progLength) {
                    mLog.severe("paint program panel: elapsed minutes to large; sT=" + startTime + " mAM=" + minutesAfterMidnight + " pL=" + progLength + " eM=" + elapsedMinutes);
                }
                elapsedMinutes = Math.min(elapsedMinutes, progLength);
            }
            int n = borderWidth = Settings.propProgramTableOnAirProgramsShowingBorder.getBoolean() ? 1 : 0;
            if (this.mAxis == 0) {
                int progressX = 0;
                if (progLength > 0) {
                    progressX = elapsedMinutes * width / progLength;
                }
                c2 = darkBackground;
                grp.setColor(new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), (int)((double)(c2.getAlpha() * this.mProgramImportance) / 10.0)));
                int fillWidth = progressX - borderWidth;
                if (fillWidth > 0) {
                    grp.fillRect(borderWidth, borderWidth, fillWidth, height - borderWidth);
                }
                c2 = lightBackground;
                grp.setColor(new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), (int)((double)(c2.getAlpha() * this.mProgramImportance) / 10.0)));
                fillWidth = width - progressX - borderWidth * 2;
                if (fillWidth > 0) {
                    grp.fillRect(progressX, borderWidth, fillWidth, height - borderWidth);
                }
            } else {
                int progressY = 0;
                if (progLength > 0) {
                    progressY = elapsedMinutes * height / progLength;
                }
                c2 = darkBackground;
                grp.setColor(new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), (int)((double)(c2.getAlpha() * this.mProgramImportance) / 10.0)));
                int fillHeight = progressY - borderWidth;
                if (fillHeight > height) {
                    mLog.severe("paint program panel: fill height 1 to large");
                    fillHeight = height;
                }
                if (fillHeight > 0) {
                    grp.fillRect(borderWidth, borderWidth, width - borderWidth * 2, fillHeight);
                }
                c2 = lightBackground;
                grp.setColor(new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), (int)((double)(c2.getAlpha() * this.mProgramImportance) / 10.0)));
                fillHeight = height - progressY - borderWidth;
                if (fillHeight > height) {
                    mLog.severe("paint program panel: fill height 2 to large");
                    fillHeight = height;
                }
                if (fillHeight > 0) {
                    grp.fillRect(borderWidth, progressY, width - borderWidth * 2, fillHeight);
                }
            }
            if (Settings.propProgramTableOnAirProgramsShowingBorder.getBoolean()) {
                grp.draw3DRect(0, 0, width - 1, height - 1, true);
            }
        }
        if ((markedByPluginArr = this.mProgram.getMarkerArr()).length != 0) {
            Color c3 = Plugin.getPluginManager().getTvBrowserSettings().getColorForMarkingPriority(this.mProgram.getMarkPriority());
            if (c3 == null) {
                c3 = Settings.propProgramPanelMarkedMinPriorityColor.getColor();
            }
            int alphaValue = (int)((double)(c3.getAlpha() * this.mProgramImportance) / 10.0);
            if (this.mProgram.isExpired()) {
                grp.setColor(new Color(c3.getRed(), c3.getGreen(), c3.getBlue(), (int)((double)(alphaValue * 6) / 10.0)));
            } else {
                grp.setColor(new Color(c3.getRed(), c3.getGreen(), c3.getBlue(), alphaValue));
            }
            if (this.mProgram.getMarkPriority() > -1) {
                if (Settings.propProgramPanelWithMarkingsShowingBoder.getBoolean()) {
                    grp.fill3DRect(0, 0, width, height, true);
                } else {
                    grp.fillRect(0, 0, width, height);
                }
            }
        }
        if (this.mMouseOver || this.mIsSelected) {
            Color test = Settings.propProgramTableMouseOverColor.getColor();
            if (this.mIsSelected) {
                test = Settings.propKeyboardSelectedColor.getColor();
            }
            grp.setColor(test);
            grp.fillRect(0, 0, width - 1, height - 1);
            Stroke str = grp.getStroke();
            Color col = grp.getColor();
            float[] dash = new float[]{2.0f};
            int lineWidth = 1;
            BasicStroke dashed = new BasicStroke(lineWidth, 0, 0, 10.0f, dash, 0.0f);
            if (Settings.propTableBackgroundStyle.getString().contains("ui")) {
                grp.setColor(UIManager.getColor("List.foreground"));
            } else {
                grp.setColor(Settings.propProgramPanelForegroundColor.getColor());
            }
            grp.setStroke(dashed);
            grp.drawRect(lineWidth - 1, lineWidth - 1, width - lineWidth, height - lineWidth);
            grp.setStroke(str);
            grp.setColor(col);
        }
        int channelWidth = 0;
        if (this.mChannelLabel != null) {
            try {
                int yTranslation = this.getHeight() / 2 - this.mChannelLabel.getHeight() / 2;
                grp.translate(1, yTranslation);
                this.mChannelLabel.paint(grp);
                channelWidth = 46;
                grp.translate(channelWidth, -yTranslation);
            }
            catch (Exception e) {
                mLog.log(Level.SEVERE, "Error in drawing channel logo for program '" + this.mProgram + "'", e);
            }
        }
        if (this.mPaintExpiredProgramsPale && this.mProgram.isExpired()) {
            c = new Color(Color.gray.getRed(), Color.gray.getGreen(), Color.gray.getBlue(), (int)((double)(Color.gray.getAlpha() * this.mProgramImportance) / 10.0));
            this.setForeground(c);
            grp.setColor(c);
        } else {
            c = new Color(this.mTextColor.getRed(), this.mTextColor.getGreen(), this.mTextColor.getBlue(), (int)((double)(this.mTextColor.getAlpha() * this.mProgramImportance) / 10.0));
            this.setForeground(c);
            grp.setColor(c);
        }
        grp.setFont(mTimeFont);
        grp.drawString(this.mProgramTimeAsString, 1, mTimeFont.getSize());
        this.mTitleIcon.paintIcon(this, grp, WIDTH_LEFT, 0);
        if (!this.mSettings.isShowingOnlyDateAndTitle() && this.mProgram.getProgramState() == 0) {
            this.mPictureAreaIcon.paintIcon(this, grp, WIDTH_LEFT, this.mTitleIcon.getIconHeight());
            if (this.mHeight >= this.mPreferredHeight) {
                this.mDescriptionIcon.paintIcon(this, grp, WIDTH_LEFT, this.mTitleIcon.getIconHeight() + this.mPictureAreaIcon.getIconHeight());
            }
            if (this.mPaintExpiredProgramsPale && this.mProgram.isExpired() && this.mProgramImportance == 10) {
                grp.setComposite(PALE_COMPOSITE);
            } else if (this.mProgramImportance != 10) {
                grp.setComposite(AlphaComposite.getInstance(3, (float)this.mProgramImportance / 10.0f));
            }
        }
        int x = width - 1 - this.mLogoWidth;
        int y = this.mTitleIcon.getIconHeight() + this.mDescriptionIcon.getIconHeight() + this.mPictureAreaIcon.getIconHeight() + 18;
        y = Math.min(y, height - 1);
        for (Marker marker : markedByPluginArr) {
            Icon[] icons = marker.getMarkIcons(this.mProgram);
            if (icons == null) continue;
            for (int i = icons.length - 1; i >= 0; --i) {
                icons[i].paintIcon(this, grp, x -= icons[i].getIconWidth(), y - icons[i].getIconHeight());
            }
        }
        if (this.mIconArr != null) {
            x = 2;
            y = mTimeFont.getSize() + 3;
            Point iconsTopLeft = new Point(x, y);
            int sumHeights = -2;
            int maxWidth = 0;
            int rowWidth = 0;
            for (int i = 0; i < this.mIconArr.length; ++i) {
                sumHeights += this.mIconArr[i].getIconHeight() + 2;
                rowWidth = i % 2 == 0 ? this.mIconArr[i].getIconWidth() : (rowWidth += this.mIconArr[i].getIconWidth());
                if (rowWidth <= maxWidth) continue;
                maxWidth = rowWidth;
            }
            int colCount = 1;
            if (y + sumHeights >= this.mHeight && maxWidth + 6 < WIDTH_LEFT) {
                colCount = 2;
            }
            int iconHeight = 0;
            int currentX = x;
            for (int i = 0; i < this.mIconArr.length; ++i) {
                boolean nextColumn;
                Icon icon = this.mIconArr[i];
                boolean bl = nextColumn = colCount == 1 || i % 2 == 0;
                if (nextColumn) {
                    currentX = x;
                    iconHeight = icon.getIconHeight();
                } else {
                    iconHeight = Math.max(iconHeight, icon.getIconHeight());
                }
                if (y + iconHeight < this.mHeight) {
                    icon.paintIcon(this, grp, currentX, y);
                }
                if (nextColumn) {
                    currentX += icon.getIconWidth() + 2;
                }
                if (nextColumn && colCount != 1) continue;
                y += iconHeight + 2;
            }
            this.mInfoIconRect = colCount == 1 ? new Rectangle(iconsTopLeft.x + channelWidth, iconsTopLeft.y, currentX - iconsTopLeft.x, y - iconsTopLeft.y) : new Rectangle(iconsTopLeft.x + channelWidth, iconsTopLeft.y, maxWidth, y - iconsTopLeft.y + iconHeight);
        }
        if (this.mPaintExpiredProgramsPale && this.mProgram.isExpired()) {
            grp.setComposite(NORMAL_COMPOSITE);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mProgram.addChangeListener(this);
        PluginProxyManager.getInstance().addPluginStateListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.mProgram.removeChangeListener(this);
        PluginProxyManager.getInstance().removePluginStateListener(this);
    }

    public Program getProgram() {
        return this.mProgram;
    }

    public void addPluginContextMenuMouseListener(final ContextMenuIf caller) {
        ProgramMouseAndContextMenuListener listener = new ProgramMouseAndContextMenuListener(){

            @Override
            public void showContextMenu(MouseEvent e) {
                ProgramPanel.this.showPopup(e, caller);
            }

            @Override
            public void mouseEventActionFinished() {
            }

            @Override
            public Program getProgramForMouseEvent(MouseEvent e) {
                return ProgramPanel.this.mProgram;
            }
        };
        ProgramMouseEventHandler mouseHandler = new ProgramMouseEventHandler(listener, caller);
        this.addMouseListener(mouseHandler);
    }

    private void showPopup(MouseEvent evt, ContextMenuIf caller) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            JPopupMenu menu = PluginProxyManager.createPluginContextMenu(this.mProgram, caller);
            menu.show(evt.getComponent(), evt.getX() - 15, evt.getY() - 15);
        }
    }

    public void programHasChanged() {
        this.mHasChanged = true;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (this.mProgram.equals(evt.getSource())) {
            this.programHasChanged();
            this.repaint();
        }
    }

    public void setTextColor(Color col) {
        this.mTextColor = col;
    }

    public Color getTextColor() {
        return this.mTextColor;
    }

    public void paint(boolean mouse, boolean isSelected, Graphics g) {
        this.mMouseOver = mouse;
        this.mIsSelected = isSelected;
        super.paint(g);
    }

    public int getMinimumHeight() {
        return this.mTitleIcon.getIconHeight() + this.mPictureAreaIcon.getIconHeight() + 3 + (Settings.propProgramPanelUsesExtraSpaceForMarkIcons.getBoolean() && this.mProgram.getMarkerArr().length > 0 ? 16 : 0);
    }

    public void setPaintExpiredProgramsPale(boolean value) {
        this.mPaintExpiredProgramsPale = value;
    }

    @Override
    public void pluginActivated(PluginProxy plugin) {
        if (plugin.getProgramTableIcons(Plugin.getPluginManager().getExampleProgram()) != null) {
            this.updatePrograms();
        }
    }

    @Override
    public void pluginDeactivated(PluginProxy plugin) {
        this.updatePrograms();
    }

    private void updatePrograms() {
        this.programHasChanged();
        this.repaint();
    }

    @Override
    public void pluginLoaded(PluginProxy plugin) {
    }

    @Override
    public void pluginUnloaded(PluginProxy plugin) {
    }

    public String getToolTipText(int x, int y) {
        if (this.mInfoIconRect != null && this.mInfoIconRect.contains(x, y)) {
            return this.getProgramInfoTooltip();
        }
        Marker[] markers = this.mProgram.getMarkerArr();
        if (markers != null && markers.length > 0 && x >= this.getWidth() - markers.length * 16 - 2) {
            int markerY = this.mTitleIcon.getIconHeight() + this.mDescriptionIcon.getIconHeight() + this.mPictureAreaIcon.getIconHeight() + 2;
            if (y >= (markerY = Math.min(markerY, this.getHeight() - 16)) && y <= markerY + 16) {
                return this.getMarkedByTooltip();
            }
        }
        if (this.mTitleIcon.isTextCut()) {
            return this.mProgram.getTitle();
        }
        return null;
    }

    private String getMarkedByTooltip() {
        StringBuilder buffer = new StringBuilder();
        Marker[] markers = this.mProgram.getMarkerArr();
        for (int i = markers.length - 1; i >= 0; --i) {
            Marker marker = markers[i];
            String text = "";
            PluginAccess plugin = Plugin.getPluginManager().getActivatedPluginForId(marker.getId());
            if (plugin != null) {
                text = plugin.getInfo().getName();
            } else {
                InternalPluginProxyIf internalPlugin = InternalPluginProxyList.getInstance().getProxyForId(marker.getId());
                if (internalPlugin != null) {
                    text = internalPlugin.getName();
                    if (internalPlugin.equals(FavoritesPluginProxy.getInstance())) {
                        StringBuilder favTitles = new StringBuilder();
                        for (Favorite favorite : FavoriteTreeModel.getInstance().getFavoritesContainingProgram(this.mProgram)) {
                            if (favTitles.length() > 0) {
                                favTitles.append(", ");
                            }
                            favTitles.append(favorite.getName());
                        }
                        if (favTitles.length() > 0) {
                            text = text + " (" + favTitles.toString() + ')';
                        }
                    }
                }
            }
            if (text.length() <= 0) continue;
            buffer.append(text);
            buffer.append("<br/>");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "<html><b>" + mLocalizer.msg("markedBy", "Marked by") + "</b><br/>");
            buffer.append("</html>");
            return buffer.toString();
        }
        return null;
    }

    private String getProgramInfoTooltip() {
        StringBuilder buffer = new StringBuilder("");
        int info = this.mProgram.getInfo();
        if (info > 0) {
            int[] infoBitArr = ProgramInfoHelper.getInfoBits();
            Icon[] infoIcons = ProgramInfoHelper.getInfoIcons();
            String[] infoMsgArr = ProgramInfoHelper.getInfoIconMessages();
            for (int i = 0; i < infoBitArr.length; ++i) {
                if (!ProgramInfoHelper.bitSet(info, infoBitArr[i]) || infoIcons[i] == null) continue;
                buffer.append("<tr><td valign=\"middle\" align=\"center\"><img src=\"").append(infoIcons[i]).append("\"></td><td>&nbsp;").append(infoMsgArr[i]).append("</td></tr>");
            }
        }
        for (PluginProxy proxy : PluginProxyManager.getInstance().getActivatedPlugins()) {
            Icon[] pluginIcons = proxy.getProgramTableIcons(this.mProgram);
            String singleText = proxy.getProgramTableIconText();
            ToolTipIcon[] toolTipIcons = proxy.getProgramTableToolTipIcons(this.mProgram);
            if (toolTipIcons == null && pluginIcons != null && pluginIcons.length > 0 && singleText != null) {
                buffer.append("<tr><td valign=\"middle\" align=\"center\"></td><td>&nbsp;").append(singleText).append("</td></tr>");
                continue;
            }
            if (toolTipIcons == null) continue;
            for (ToolTipIcon icons : toolTipIcons) {
                icons.append(buffer);
            }
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "<html><table cellpadding=\"1\">");
            buffer.append("</table></html>");
            return buffer.toString();
        }
        return null;
    }

    public int getTitleX() {
        return WIDTH_LEFT;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText(event.getX(), event.getY());
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.setWidth(d.width);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setWidth(width);
    }

    public void setWidth(int newWidth) {
        if (newWidth > 120) {
            int oldWidth = this.getWidth();
            int textIconWidth = this.getTextIconWidth(newWidth);
            if (oldWidth != newWidth && newWidth > 0 || textIconWidth != this.mDescriptionIcon.getIconWidth() && textIconWidth > 0) {
                this.recreateTextIcons(newWidth);
            }
        }
    }

    private int getTextIconWidth(int fullWidth) {
        return fullWidth - WIDTH_LEFT - 5 - this.mLogoWidth;
    }

    private void recreateTextIcons(int newWidth) {
        this.textIconWidth = this.getTextIconWidth(newWidth);
        this.mTitleIcon = new TextAreaIcon(null, mTitleFont, this.textIconWidth);
        this.mDescriptionIcon = new TextAreaIcon(null, mNormalFont, this.textIconWidth);
        this.mDescriptionIcon.setMaximumLineCount(3);
        if (this.mProgram != null) {
            this.mProgram.validateMarking();
            Program p = this.mProgram;
            this.mProgram = null;
            this.setProgram(p);
        }
    }

    public void setMarkTime(int time) {
        this.mMarkTime = time;
    }

    static {
        fontSizeOffset = 0;
        columnWidthOffset = 0;
        WIDTH_LEFT = -1;
        WIDTH_RIGHT = Settings.propColumnWidth.getInt() - WIDTH_LEFT;
        WIDTH_TOTAL = WIDTH_LEFT + WIDTH_RIGHT;
        TIME_FORMATTER = new TimeFormatter();
        V_GAP = 5;
    }
}

