/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import util.ui.Localizer;
import util.ui.PluginChooserDlg;
import util.ui.UiUtilities;

public class ProgramReceiveTargetSelectionPanel
extends JPanel {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramReceiveTargetSelectionPanel.class);
    private JLabel mReceiveTargetLabel;
    private ProgramReceiveTarget[] mReceiveTargets;
    private ChangeListener[] mChangeListenerArray = new ChangeListener[0];

    public ProgramReceiveTargetSelectionPanel(final Window parent, ProgramReceiveTarget[] receiveTargetArr, final String description, final ProgramReceiveIf caller, boolean withTitle, String title) {
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu,default,5dlu:grow,default,5dlu", withTitle ? "pref,5dlu,pref" : "pref"), this);
        this.mReceiveTargets = receiveTargetArr;
        this.mReceiveTargetLabel = new JLabel();
        JButton selectionButton = new JButton(LOCALIZER.msg("selectionButton", "Select targets"));
        final ProgramReceiveTargetSelectionPanel thisPanel = this;
        selectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Window w = UiUtilities.getLastModalChildOf(parent);
                    PluginChooserDlg chooser = null;
                    chooser = new PluginChooserDlg(w, ProgramReceiveTargetSelectionPanel.this.mReceiveTargets, description, caller);
                    chooser.setVisible(true);
                    if (chooser.getReceiveTargets() != null) {
                        ProgramReceiveTargetSelectionPanel.access$002(ProgramReceiveTargetSelectionPanel.this, chooser.getReceiveTargets());
                        for (ChangeListener listener : ProgramReceiveTargetSelectionPanel.this.mChangeListenerArray) {
                            listener.stateChanged(new ChangeEvent(thisPanel));
                        }
                    }
                    ProgramReceiveTargetSelectionPanel.this.handlePluginSelection();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        CellConstraints cc = new CellConstraints();
        if (withTitle) {
            pb.addSeparator(title == null ? LOCALIZER.msg("defaultTitle", "Send programs to:") : title, cc.xyw(1, 1, 5));
            pb.add((Component)this.mReceiveTargetLabel, cc.xy(2, 3));
            pb.add((Component)selectionButton, cc.xy(4, 3));
        } else {
            pb.add((Component)this.mReceiveTargetLabel, cc.xy(2, 1));
            pb.add((Component)selectionButton, cc.xy(4, 1));
        }
        this.handlePluginSelection();
    }

    private void handlePluginSelection() {
        ArrayList<ProgramReceiveIf> plugins = new ArrayList<ProgramReceiveIf>();
        if (this.mReceiveTargets != null) {
            for (ProgramReceiveTarget target : this.mReceiveTargets) {
                if (plugins.contains(target.getReceifeIfForIdOfTarget()) || target.getReceifeIfForIdOfTarget() == null) continue;
                plugins.add(target.getReceifeIfForIdOfTarget());
            }
            ProgramReceiveIf[] mClientPlugins = plugins.toArray(new ProgramReceiveIf[plugins.size()]);
            if (mClientPlugins.length > 0) {
                this.mReceiveTargetLabel.setText(mClientPlugins[0].toString());
                this.mReceiveTargetLabel.setEnabled(true);
            } else {
                this.mReceiveTargetLabel.setText(LOCALIZER.msg("noTargets", "No targets choosen"));
                this.mReceiveTargetLabel.setEnabled(false);
            }
            for (int i = 1; i < (mClientPlugins.length > 4 ? 3 : mClientPlugins.length); ++i) {
                this.mReceiveTargetLabel.setText(this.mReceiveTargetLabel.getText() + ", " + mClientPlugins[i]);
            }
            if (mClientPlugins.length > 4) {
                this.mReceiveTargetLabel.setText(this.mReceiveTargetLabel.getText() + " (" + (mClientPlugins.length - 3) + " " + LOCALIZER.msg("otherTargets", "others...") + ")");
            }
        }
    }

    public ProgramReceiveTarget[] getCurrentSelection() {
        return this.mReceiveTargets;
    }

    public void addChangeListener(ChangeListener listener) {
        ChangeListener[] newArray = new ChangeListener[this.mChangeListenerArray.length + 1];
        System.arraycopy(this.mChangeListenerArray, 0, newArray, 0, this.mChangeListenerArray.length);
        newArray[this.mChangeListenerArray.length] = listener;
        this.mChangeListenerArray = newArray;
    }

    static /* synthetic */ ProgramReceiveTarget[] access$002(ProgramReceiveTargetSelectionPanel x0, ProgramReceiveTarget[] x1) {
        x0.mReceiveTargets = x1;
        return x1;
    }
}

