/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramFieldType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import tvbrowser.core.Settings;
import util.ui.LinkButton;
import util.ui.Localizer;
import util.ui.OrderChooser;
import util.ui.SearchFormSettings;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SearchForm
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchForm.class);
    private static final String[] TIME_STRING_ARR = new String[]{Localizer.getLocalization("i18n_today"), Localizer.getLocalization("i18n_tomorrow"), mLocalizer.msg("search.7", "Next week"), mLocalizer.msg("search.14", "2 weeks"), mLocalizer.msg("search.21", "3 weeks"), mLocalizer.msg("search.1000", "All data")};
    private static final int[] TIME_VALUE_ARR = new int[]{0, 1, 7, 14, 21, -1};
    private static final int MAX_HISTORY_LENGTH = 50;
    public static final int LAYOUT_HORIZONTAL = 1;
    public static final int LAYOUT_VERTICAL = 2;
    private static ProgramFieldType[] mSearchableFieldTypes;
    private JTextField mPatternTF;
    private JComboBox mPatternCB;
    private DefaultComboBoxModel mPatternCBModel;
    private JComboBox mTimeCB;
    private JRadioButton mSearchTitleRB;
    private JRadioButton mSearchAllRB;
    private JRadioButton mSearchUserDefinedRB;
    private JButton mChangeSearchFieldsBt;
    private JRadioButton mSearcherTypeExactlyRB;
    private JRadioButton mSearcherTypeKeywordRB;
    private JRadioButton mSearcherTypeRegexRB;
    private JRadioButton mSearcherTypeBooleanRB;
    private JRadioButton mSearcherTypeWholeTermRB;
    private JCheckBox mCaseSensitiveChB;
    private ProgramFieldType[] mUserDefinedFieldTypeArr;
    private ProgramFieldType[] mUserDefaultFieldTypeArr;
    private FieldSelectionDialog mFieldSelectionDlg;
    private JDialog mParent;

    public SearchForm(boolean showHistory, boolean showTimeSelection) {
        this(true, showHistory, showTimeSelection);
    }

    public SearchForm(boolean showInputfield, boolean showHistory, boolean showTimeSelection) {
        this(showInputfield, showHistory, showTimeSelection, 2);
    }

    public SearchForm(boolean showInputfield, boolean showHistory, boolean showTimeSelection, int layout) {
        this(showInputfield, showHistory, showTimeSelection, layout, false);
    }

    public SearchForm(boolean showInputfield, boolean showHistory, boolean showTimeSelection, int layout, final boolean showDefaultSelection) {
        FormLayout layoutTop = new FormLayout("default, 3dlu, fill:10dlu:grow", "");
        FormLayout layoutSearchIn = new FormLayout("3dlu, default:grow", "default, 3dlu, default, default, default");
        FormLayout layoutOptions = new FormLayout("3dlu, default, fill:default:grow", "default, 3dlu, default, default, default, default, default, default, 3dlu, default");
        JPanel topPanel = new JPanel(layoutTop);
        PanelBuilder searchInPanel = new PanelBuilder(layoutSearchIn);
        PanelBuilder optionsPanel = new PanelBuilder(layoutOptions);
        DefaultFormBuilder topBuilder = new DefaultFormBuilder(layoutTop, topPanel);
        if (showInputfield) {
            if (showHistory) {
                this.mPatternCBModel = new DefaultComboBoxModel();
                this.mPatternCB = new JComboBox(this.mPatternCBModel);
                this.mPatternCB.setEditable(true);
                this.mPatternCB.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent evt) {
                        Object selection;
                        if (evt.getStateChange() == 1 && (selection = SearchForm.this.mPatternCB.getSelectedItem()) instanceof SearchFormSettings) {
                            SearchForm.this.setSearchFormSettings((SearchFormSettings)selection, false);
                        }
                    }
                });
                topBuilder.append(mLocalizer.msg("searchTerm", "Search term"), (Component)this.mPatternCB);
            } else {
                this.mPatternTF = new JTextField(20);
                topBuilder.append(mLocalizer.msg("searchTerm", "Search term"), (Component)this.mPatternTF);
            }
        }
        if (showTimeSelection) {
            this.mTimeCB = new JComboBox<String>(TIME_STRING_ARR);
            topBuilder.append(mLocalizer.msg("period", "Period"), (Component)this.mTimeCB);
        }
        ButtonGroup bg = new ButtonGroup();
        searchInPanel.addSeparator(mLocalizer.msg("searchIn", "Search in"), CC.xyw(1, 1, 2));
        ActionListener updateEnabledListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchForm.this.updateEnabled();
            }
        };
        this.mSearchTitleRB = new JRadioButton(mLocalizer.msg("onlyTitle", "Only in title"));
        this.mSearchTitleRB.setSelected(true);
        this.mSearchTitleRB.addActionListener(updateEnabledListener);
        bg.add(this.mSearchTitleRB);
        searchInPanel.add((Component)this.mSearchTitleRB, CC.xy(2, 3));
        String msg = mLocalizer.msg("allFields", "All fields");
        this.mSearchAllRB = new JRadioButton(msg);
        this.mSearchAllRB.addActionListener(updateEnabledListener);
        bg.add(this.mSearchAllRB);
        searchInPanel.add((Component)this.mSearchAllRB, CC.xy(2, 4));
        this.mSearchUserDefinedRB = new JRadioButton(mLocalizer.msg("certainFields", "Certain Fields"));
        this.mSearchUserDefinedRB.addActionListener(updateEnabledListener);
        bg.add(this.mSearchUserDefinedRB);
        this.mChangeSearchFieldsBt = new JButton(Localizer.getLocalization("i18n_select"));
        this.mChangeSearchFieldsBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchForm.this.showSelectSearchFieldsDialog(showDefaultSelection);
            }
        });
        JPanel panel = new JPanel(new FormLayout("pref,1dlu:grow,pref", "pref"));
        panel.add((Component)this.mSearchUserDefinedRB, CC.xy(1, 1));
        panel.add((Component)this.mChangeSearchFieldsBt, CC.xy(3, 1));
        searchInPanel.add((Component)panel, CC.xy(2, 5));
        optionsPanel.addSeparator(Localizer.getLocalization("i18n_options"), CC.xyw(1, 1, 3));
        this.mCaseSensitiveChB = new JCheckBox(mLocalizer.msg("caseSensitive", "Case sensitive"));
        optionsPanel.add((Component)this.mCaseSensitiveChB, CC.xy(2, 3));
        bg = new ButtonGroup();
        this.mSearcherTypeExactlyRB = new JRadioButton(mLocalizer.msg("matchExactly", "Match exactly"));
        bg.add(this.mSearcherTypeExactlyRB);
        optionsPanel.add((Component)this.mSearcherTypeExactlyRB, CC.xy(2, 4));
        this.mSearcherTypeWholeTermRB = new JRadioButton(mLocalizer.msg("wholeTerm", "Whole term"));
        bg.add(this.mSearcherTypeWholeTermRB);
        optionsPanel.add((Component)this.mSearcherTypeWholeTermRB, CC.xy(2, 5));
        this.mSearcherTypeKeywordRB = new JRadioButton(mLocalizer.msg("matchSubstring", "Term is a keyword"));
        this.mSearcherTypeKeywordRB.setSelected(true);
        bg.add(this.mSearcherTypeKeywordRB);
        optionsPanel.add((Component)this.mSearcherTypeKeywordRB, CC.xy(2, 6));
        this.mSearcherTypeBooleanRB = new JRadioButton(mLocalizer.msg("matchBoolean", "Term is a boolean (with AND, OR, a.s.o.)"));
        bg.add(this.mSearcherTypeBooleanRB);
        optionsPanel.add((Component)this.mSearcherTypeBooleanRB, CC.xy(2, 7));
        this.mSearcherTypeRegexRB = new JRadioButton(mLocalizer.msg("matchRegex", "Term is a regular expression"));
        bg.add(this.mSearcherTypeRegexRB);
        optionsPanel.add((Component)this.mSearcherTypeRegexRB, CC.xy(2, 8));
        LinkButton b = new LinkButton("(" + mLocalizer.msg("regExHelp", "Help for regular expressions") + ")", mLocalizer.msg("regExUrl", "http://wiki.tvbrowser.org/index.php/Regul%C3%A4re_Ausdr%C3%BCcke"));
        b.setHorizontalAlignment(0);
        optionsPanel.add((Component)b, CC.xy(2, 10));
        this.setSearchFormSettings(new SearchFormSettings(""));
        this.updateEnabled();
        if (layout == 1) {
            this.setLayout(new FormLayout("pref:grow, 3dlu, pref:grow", "pref, 3dlu, top:pref"));
            this.add((Component)topPanel, CC.xyw(1, 1, 3));
            this.add((Component)searchInPanel.getPanel(), CC.xy(1, 3));
            this.add((Component)optionsPanel.getPanel(), CC.xy(3, 3));
        } else if (layout == 2) {
            this.setLayout(new FormLayout("pref:grow", "pref, 3dlu, pref, 3dlu, pref"));
            this.add((Component)topPanel, CC.xy(1, 1));
            this.add((Component)searchInPanel.getPanel(), CC.xy(1, 3));
            this.add((Component)optionsPanel.getPanel(), CC.xy(1, 5));
        } else {
            throw new IllegalArgumentException("invalid layout type: " + layout);
        }
    }

    public void setParentDialog(JDialog parent) {
        this.mParent = parent;
    }

    public void addPatternActionListener(final ActionListener listener) {
        if (this.mPatternCB != null) {
            ActionListener invokeLaterListener = new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            listener.actionPerformed(evt);
                        }
                    });
                }
            };
            this.mPatternCB.getEditor().addActionListener(invokeLaterListener);
        } else {
            this.mPatternTF.addActionListener(listener);
        }
    }

    public void addPatternChangeListener(DocumentListener listener) {
        if (this.mPatternCB != null) {
            JTextField textField = (JTextField)this.mPatternCB.getEditor().getEditorComponent();
            textField.getDocument().addDocumentListener(listener);
        } else {
            this.mPatternTF.getDocument().addDocumentListener(listener);
        }
    }

    @Override
    public boolean hasFocus() {
        if (this.mPatternCB != null) {
            return this.mPatternCB.getEditor().getEditorComponent().hasFocus();
        }
        if (this.mPatternTF != null) {
            return this.mPatternTF.hasFocus();
        }
        return false;
    }

    public void setSearchFormSettings(SearchFormSettings settings) {
        this.setSearchFormSettings(settings, true);
    }

    public void setSearchFormSettings(SearchFormSettings settings, boolean updatePattern) {
        if (updatePattern) {
            this.setPattern(settings.getSearchText());
        }
        switch (settings.getSearchIn()) {
            case 1: {
                this.mSearchTitleRB.setSelected(true);
                break;
            }
            case 2: {
                this.mSearchAllRB.setSelected(true);
                break;
            }
            case 3: {
                this.mSearchUserDefinedRB.setSelected(true);
                this.updateEnabled();
            }
        }
        this.mUserDefinedFieldTypeArr = settings.getUserDefinedFieldTypes();
        this.mUserDefaultFieldTypeArr = settings.getUserDefaultFieldTypes();
        switch (settings.getSearcherType()) {
            case 1: {
                this.mSearcherTypeExactlyRB.setSelected(true);
                break;
            }
            case 5: {
                this.mSearcherTypeWholeTermRB.setSelected(true);
                break;
            }
            case 2: {
                this.mSearcherTypeKeywordRB.setSelected(true);
                break;
            }
            case 3: {
                this.mSearcherTypeRegexRB.setSelected(true);
                break;
            }
            case 4: {
                this.mSearcherTypeBooleanRB.setSelected(true);
            }
        }
        this.mCaseSensitiveChB.setSelected(settings.getCaseSensitive());
        this.setNrDays(settings.getNrDays());
    }

    public SearchFormSettings getSearchFormSettings() {
        int searchIn;
        SearchFormSettings settings = new SearchFormSettings(this.getPattern());
        if (this.mSearchTitleRB.isSelected()) {
            searchIn = 1;
        } else if (this.mSearchAllRB.isSelected()) {
            searchIn = 2;
        } else {
            searchIn = 3;
            settings.setUserDefinedFieldTypes(this.mUserDefinedFieldTypeArr);
        }
        settings.setUserDefaultFieldTypes(this.mUserDefaultFieldTypeArr);
        settings.setSearchIn(searchIn);
        int searcherType = this.mSearcherTypeExactlyRB.isSelected() ? 1 : (this.mSearcherTypeWholeTermRB.isSelected() ? 5 : (this.mSearcherTypeKeywordRB.isSelected() ? 2 : (this.mSearcherTypeRegexRB.isSelected() ? 3 : 4)));
        settings.setSearcherType(searcherType);
        settings.setCaseSensitive(this.mCaseSensitiveChB.isSelected());
        settings.setNrDays(this.getNrDays());
        return settings;
    }

    public void setHistory(SearchFormSettings[] history) {
        if (this.mPatternCB != null) {
            this.mPatternCBModel.removeAllElements();
            if (history != null) {
                for (SearchFormSettings element : history) {
                    this.mPatternCBModel.addElement(element);
                }
            }
            this.mPatternCB.getEditor().selectAll();
            this.updateEnabled();
        }
    }

    public SearchFormSettings[] getHistory() {
        ArrayList<SearchFormSettings> list = new ArrayList<SearchFormSettings>(this.mPatternCBModel.getSize());
        for (int i = 0; i < this.mPatternCBModel.getSize(); ++i) {
            Object item = this.mPatternCBModel.getElementAt(i);
            if (!(item instanceof SearchFormSettings)) continue;
            list.add((SearchFormSettings)item);
        }
        SearchFormSettings settings = this.getSearchFormSettings();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            SearchFormSettings hist = (SearchFormSettings)iter.next();
            if (!settings.getSearchText().equals(hist.getSearchText())) continue;
            iter.remove();
        }
        list.add(0, settings);
        while (list.size() > 50) {
            list.remove(list.size() - 1);
        }
        SearchFormSettings[] history = new SearchFormSettings[list.size()];
        list.toArray(history);
        this.setHistory(history);
        return history;
    }

    public int getNrDays() {
        if (this.mTimeCB != null) {
            return TIME_VALUE_ARR[this.mTimeCB.getSelectedIndex()];
        }
        return -1;
    }

    public void setNrDays(int nrDays) {
        if (this.mTimeCB != null) {
            for (int i = 0; i < TIME_VALUE_ARR.length; ++i) {
                if (nrDays != TIME_VALUE_ARR[i]) continue;
                this.mTimeCB.setSelectedIndex(i);
                break;
            }
        }
    }

    private void updateEnabled() {
        this.mChangeSearchFieldsBt.setEnabled(this.mSearchUserDefinedRB.isSelected());
    }

    private String getPattern() {
        if (this.mPatternCB != null) {
            return this.mPatternCB.getSelectedItem().toString();
        }
        if (this.mPatternTF != null) {
            return this.mPatternTF.getText();
        }
        return "";
    }

    public void setPattern(String pattern) {
        if (this.mPatternCB != null) {
            this.mPatternCB.setSelectedItem(pattern);
        } else if (this.mPatternTF != null) {
            this.mPatternTF.setText(pattern);
        }
    }

    public static final ProgramFieldType[] getSearchableFieldTypes() {
        if (mSearchableFieldTypes == null) {
            ArrayList<ProgramFieldType> list = new ArrayList<ProgramFieldType>();
            Iterator<ProgramFieldType> iter = ProgramFieldType.getTypeIterator();
            while (iter.hasNext()) {
                ProgramFieldType type = iter.next();
                if (type.getFormat() == 2 || type == ProgramFieldType.PICTURE_COPYRIGHT_TYPE || type == ProgramFieldType.INFO_TYPE || type == ProgramFieldType.CUSTOM_TYPE) continue;
                list.add(type);
            }
            mSearchableFieldTypes = list.toArray(new ProgramFieldType[list.size()]);
        }
        return (ProgramFieldType[])mSearchableFieldTypes.clone();
    }

    private void showSelectSearchFieldsDialog(boolean showDefaultSelection) {
        this.mFieldSelectionDlg = new FieldSelectionDialog(this, this.mUserDefinedFieldTypeArr, this.mUserDefaultFieldTypeArr, showDefaultSelection);
        this.mFieldSelectionDlg.centerAndShow(this.mParent);
        if (this.mParent != null) {
            this.mParent.requestFocus();
        }
        this.mUserDefinedFieldTypeArr = this.mFieldSelectionDlg.getSelectedTypes();
        this.mUserDefaultFieldTypeArr = this.mFieldSelectionDlg.getDefaultTypes();
    }

    public boolean isSearchFieldsSelectionDialogVisible() {
        return this.mFieldSelectionDlg != null && this.mFieldSelectionDlg.isVisible();
    }

    public void focusSearchFieldButton() {
        this.mChangeSearchFieldsBt.requestFocusInWindow();
    }

    private static class FieldSelectionDialog {
        private JDialog mDlg;
        private ProgramFieldType[] mSelectedTypeArr;
        private ProgramFieldType[] mDefaultTypeArr;
        private OrderChooser mSelectableItemList;
        private JCheckBox mDefaultSelection;

        public FieldSelectionDialog(Component parent, ProgramFieldType[] selectedTypeArr, ProgramFieldType[] defaultTypeArr, boolean showDefaultSelection) {
            if (selectedTypeArr == null) {
                selectedTypeArr = defaultTypeArr == null ? new ProgramFieldType[]{} : defaultTypeArr;
            }
            this.mSelectedTypeArr = selectedTypeArr;
            this.mDefaultTypeArr = defaultTypeArr;
            this.mDlg = UiUtilities.createDialog(parent, true);
            String msg = mLocalizer.msg("chooseSearchFields", "Choose search fields");
            this.mDlg.setTitle(msg);
            UiUtilities.registerForClosing(new WindowClosingIf(){

                @Override
                public void close() {
                    FieldSelectionDialog.this.mDlg.dispose();
                }

                @Override
                public JRootPane getRootPane() {
                    return FieldSelectionDialog.this.mDlg.getRootPane();
                }
            });
            JPanel main = new JPanel(new BorderLayout());
            main.setBorder(UiUtilities.DIALOG_BORDER);
            this.mDlg.setContentPane(main);
            msg = mLocalizer.msg("chooseSearchFieldHelp", "Please select the fields to search for");
            main.add((Component)UiUtilities.createHelpTextArea(msg + "\n"), "North");
            this.mSelectableItemList = new OrderChooser(selectedTypeArr, SearchForm.getSearchableFieldTypes(), false);
            main.add((Component)this.mSelectableItemList, "Center");
            ButtonBarBuilder buttons = new ButtonBarBuilder();
            buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            if (showDefaultSelection) {
                this.mDefaultSelection = new JCheckBox(mLocalizer.msg("showDefaultSelection", "Save selected as default"));
                buttons.addButton((JComponent)this.mDefaultSelection);
            }
            buttons.addGlue();
            main.add((Component)buttons.getPanel(), "South");
            JButton okBt = new JButton(Localizer.getLocalization("i18n_ok"));
            okBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FieldSelectionDialog.this.handleOk();
                }
            });
            this.mDlg.getRootPane().setDefaultButton(okBt);
            buttons.addButton((JComponent)okBt);
            buttons.addRelatedGap();
            JButton cancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
            cancelBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FieldSelectionDialog.this.mDlg.dispose();
                }
            });
            buttons.addButton((JComponent)cancelBt);
            Settings.layoutWindow("searchFormFieldSelectionDlg", this.mDlg, new Dimension(380, 320));
        }

        private void handleOk() {
            Object[] o = this.mSelectableItemList.getOrder();
            this.mSelectedTypeArr = new ProgramFieldType[o.length];
            for (int i = 0; i < o.length; ++i) {
                this.mSelectedTypeArr[i] = (ProgramFieldType)o[i];
            }
            if (this.mDefaultSelection != null && this.mDefaultSelection.isSelected()) {
                this.mDefaultTypeArr = this.mSelectedTypeArr;
            }
            this.mDlg.dispose();
        }

        public boolean isVisible() {
            return this.mDlg.isVisible();
        }

        public void centerAndShow(JDialog parent) {
            if (parent != null) {
                this.mDlg.setLocationRelativeTo(parent);
                this.mDlg.setVisible(true);
            } else {
                this.centerAndShow();
            }
        }

        public void centerAndShow() {
            UiUtilities.centerAndShow(this.mDlg);
        }

        public ProgramFieldType[] getSelectedTypes() {
            return this.mSelectedTypeArr;
        }

        public ProgramFieldType[] getDefaultTypes() {
            return this.mDefaultTypeArr;
        }
    }
}

