/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class TabLayout
implements LayoutManager {
    protected int anzahlSpalten;
    protected int xAbs;
    protected int yAbs;
    protected boolean dontMaximizeComponents;

    public TabLayout(int columns) {
        this(columns, false);
    }

    public TabLayout(int columns, int xAbs, int yAbs) {
        this(columns, xAbs, yAbs, false);
    }

    public TabLayout(int columns, boolean dontMaximizeComponents) {
        this(columns, 3, 3, dontMaximizeComponents);
    }

    public TabLayout(int columns, int xAbs, int yAbs, boolean dontMaximizeComponents) {
        if (columns < 1) {
            columns = 1;
        }
        this.anzahlSpalten = columns;
        this.dontMaximizeComponents = dontMaximizeComponents;
        this.xAbs = xAbs;
        this.yAbs = yAbs;
    }

    Component[][] getComponentFeld(Container c) {
        int anzahlComp = c.getComponentCount();
        int hoehe = (int)Math.ceil((double)anzahlComp / (double)this.anzahlSpalten);
        Component[][] comp = new Component[this.anzahlSpalten][hoehe > 0 ? hoehe : 1];
        int aktSpalte = 0;
        int aktZeile = 0;
        for (int i = 0; i < anzahlComp; ++i) {
            comp[aktSpalte][aktZeile] = c.getComponent(i);
            if (++aktSpalte < this.anzahlSpalten) continue;
            aktSpalte = 0;
            ++aktZeile;
        }
        return comp;
    }

    int[] getBreiten(int gesBreite, Component[][] comp) {
        int[] breite = new int[comp.length];
        for (int i = 0; i < breite.length; ++i) {
            breite[i] = 0;
        }
        for (int y = 0; y < comp[0].length; ++y) {
            for (int x = 0; x < comp.length; ++x) {
                if (comp[x][y] == null || !comp[x][y].isVisible()) continue;
                Dimension d = comp[x][y].getPreferredSize();
                breite[x] = Math.max(breite[x], d.width);
            }
        }
        if (gesBreite > 0) {
            int prefGesBreite = -this.xAbs;
            for (int element : breite) {
                prefGesBreite += element + this.xAbs;
            }
            double skal = (double)gesBreite / (double)prefGesBreite;
            for (int i = 0; i < breite.length; ++i) {
                breite[i] = (int)((double)breite[i] * skal);
            }
        }
        return breite;
    }

    int[] getHoehen(int gesHoehe, Component[][] comp) {
        int[] hoehe = new int[comp[0].length];
        for (int i = 0; i < hoehe.length; ++i) {
            hoehe[i] = 0;
        }
        for (int y = 0; y < comp[0].length; ++y) {
            for (Component[] element : comp) {
                if (element[y] == null || !element[y].isVisible()) continue;
                Dimension d = element[y].getPreferredSize();
                hoehe[y] = Math.max(hoehe[y], d.height);
            }
        }
        if (gesHoehe > 0) {
            int prefGesHoehe = -this.yAbs;
            for (int element : hoehe) {
                prefGesHoehe += element + this.yAbs;
            }
            double d = (double)gesHoehe / (double)prefGesHoehe;
            for (int i = 0; i < hoehe.length; ++i) {
                hoehe[i] = (int)((double)hoehe[i] * d);
            }
        }
        return hoehe;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container c) {
        Object object = c.getTreeLock();
        synchronized (object) {
            Component[][] comp = this.getComponentFeld(c);
            int[] breite = this.getBreiten(0, comp);
            int[] hoehe = this.getHoehen(0, comp);
            Dimension dim = new Dimension(-this.xAbs, -this.yAbs);
            for (int element : breite) {
                dim.width += element + this.xAbs;
            }
            for (int element : hoehe) {
                dim.height += element + this.yAbs;
            }
            Insets insets = c.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int i;
            Insets insets = target.getInsets();
            Component[][] comp = this.getComponentFeld(target);
            int[] breite = this.getBreiten(target.getSize().width - insets.left - insets.right, comp);
            int[] hoehe = this.getHoehen(target.getSize().height - insets.top - insets.bottom, comp);
            int[] xPos = new int[comp.length];
            int[] yPos = new int[comp[0].length];
            xPos[0] = insets.left;
            yPos[0] = insets.top;
            for (i = 1; i < xPos.length; ++i) {
                xPos[i] = xPos[i - 1] + breite[i - 1] + this.xAbs;
            }
            for (i = 1; i < yPos.length; ++i) {
                yPos[i] = yPos[i - 1] + hoehe[i - 1] + this.yAbs;
            }
            for (int y = 0; y < comp[0].length; ++y) {
                for (int x = 0; x < comp.length; ++x) {
                    if (comp[x][y] == null || !comp[x][y].isVisible()) continue;
                    int currBreite = breite[x];
                    int currHoehe = hoehe[y];
                    if (this.dontMaximizeComponents) {
                        Dimension currPreferredSize = comp[x][y].getPreferredSize();
                        currBreite = Math.min(currBreite, currPreferredSize.width);
                        currHoehe = Math.min(currHoehe, currPreferredSize.height);
                    }
                    comp[x][y].setSize(currBreite, currHoehe);
                    comp[x][y].setLocation(xPos[x], yPos[y]);
                }
            }
        }
    }
}

