/*
 * Decompiled with CFR 0.152.
 */
package util.ui.progress;

import devplugin.ProgressMonitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends FilterInputStream {
    private ProgressMonitor mMonitor;
    private int mPosition;

    public ProgressInputStream(InputStream in, ProgressMonitor monitor) {
        this(in, monitor, 0);
    }

    public ProgressInputStream(InputStream in, ProgressMonitor monitor, int position) {
        super(in);
        this.mMonitor = monitor;
        this.mPosition = position;
    }

    @Override
    public int read() throws IOException {
        ++this.mPosition;
        this.mMonitor.setValue(this.mPosition);
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        this.mPosition += read;
        this.mMonitor.setValue(this.mPosition);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.mPosition += read;
        this.mMonitor.setValue(this.mPosition);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        this.mPosition = (int)((long)this.mPosition + skip);
        this.mMonitor.setValue(this.mPosition);
        return skip;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public int getCurrentPosition() {
        return this.mPosition;
    }
}

