/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.gui;

import com._17od.upm.database.PasswordDatabase;
import com._17od.upm.gui.EscapeDialog;
import com._17od.upm.transport.Transport;
import com._17od.upm.transport.TransportException;
import com._17od.upm.util.Translator;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DatabasePropertiesDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private boolean databaseNeedsSaving = false;

    public DatabasePropertiesDialog(final JFrame frame, ArrayList accountNames, final PasswordDatabase database) {
        super(frame, Translator.translate("databaseProperties"), true);
        Container container = this.getContentPane();
        Border emptyBorder = BorderFactory.createEmptyBorder(2, 5, 5, 5);
        JPanel emptyBorderPanel = new JPanel();
        emptyBorderPanel.setLayout(new BoxLayout(emptyBorderPanel, 1));
        emptyBorderPanel.setBorder(emptyBorder);
        container.add(emptyBorderPanel);
        Border etchedBorder = BorderFactory.createEtchedBorder(1);
        TitledBorder etchedTitleBorder = BorderFactory.createTitledBorder(etchedBorder, ' ' + Translator.translate("remoteLocation") + ' ');
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(etchedTitleBorder);
        emptyBorderPanel.add(mainPanel);
        GridBagConstraints c = new GridBagConstraints();
        JLabel urlLabel = new JLabel(Translator.translate("url"));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = new Insets(0, 3, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)urlLabel, c);
        final JTextField urlTextField = new JTextField(database.getDbOptions().getRemoteLocation(), 20);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 21;
        c.insets = new Insets(0, 3, 3, 3);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)urlTextField, c);
        JLabel authLabel = new JLabel(Translator.translate("authenticationCredentials"));
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 21;
        c.insets = new Insets(3, 3, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        mainPanel.add((Component)authLabel, c);
        Object[] sAccountNames = new String[accountNames.size() + 1];
        sAccountNames[0] = "";
        System.arraycopy(accountNames.toArray(), 0, sAccountNames, 1, accountNames.size());
        Arrays.sort(sAccountNames);
        final JComboBox<Object> auth = new JComboBox<Object>(sAccountNames);
        auth.setSelectedItem(database.getDbOptions().getAuthDBEntry());
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 21;
        c.insets = new Insets(0, 3, 3, 3);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        mainPanel.add(auth, c);
        Component verticalSpace = Box.createVerticalGlue();
        c.gridx = 0;
        c.gridy = 4;
        c.weighty = 1.0;
        mainPanel.add(verticalSpace, c);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        emptyBorderPanel.add(buttonPanel);
        JButton okButton = new JButton(Translator.translate("ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabasePropertiesDialog.this.saveDatabaseOptions(frame, urlTextField.getText().trim(), (String)auth.getSelectedItem(), database);
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Translator.translate("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabasePropertiesDialog.this.databaseNeedsSaving = false;
                DatabasePropertiesDialog.this.setVisible(false);
                DatabasePropertiesDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
    }

    private URL validateURL(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    private void saveDatabaseOptions(JFrame parentFrame, String remoteLocation, String authEntry, PasswordDatabase database) {
        boolean canCloseWindow = false;
        if (!database.getDbOptions().getRemoteLocation().equals(remoteLocation) || !database.getDbOptions().getAuthDBEntry().equals(authEntry)) {
            this.databaseNeedsSaving = true;
        } else {
            canCloseWindow = true;
        }
        if (!remoteLocation.equals("")) {
            URL url = this.validateURL(remoteLocation);
            if (url != null) {
                if (Transport.isASupportedProtocol(url.getProtocol())) {
                    if (!database.getDbOptions().getRemoteLocation().equals(remoteLocation)) {
                        try {
                            Transport transport = Transport.getTransportForURL(url);
                            if (!authEntry.equals("")) {
                                String userId = database.getAccount(authEntry).getUserId();
                                String password = database.getAccount(authEntry).getPassword();
                                transport.put(remoteLocation, database.getDatabaseFile(), userId, password);
                            } else {
                                transport.put(remoteLocation, database.getDatabaseFile());
                            }
                            canCloseWindow = true;
                        }
                        catch (TransportException e) {
                            JOptionPane.showMessageDialog(parentFrame, e.getMessage(), Translator.translate("transportError"), 0);
                        }
                    } else {
                        canCloseWindow = true;
                    }
                } else {
                    JOptionPane.showMessageDialog(parentFrame, Translator.translate("unsupportedProtocol"), Translator.translate("invalidProtocol"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(parentFrame, Translator.translate("givenURLIsInvalid"), Translator.translate("invalidURL"), 0);
            }
        } else {
            canCloseWindow = true;
        }
        if (canCloseWindow) {
            try {
                if (this.databaseNeedsSaving) {
                    database.getDbOptions().setAuthDBEntry(authEntry);
                    database.getDbOptions().setRemoteLocation(remoteLocation);
                }
                this.setVisible(false);
                this.dispose();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(parentFrame, e.getMessage(), Translator.translate("problemSavingDB"), 0);
            }
        }
    }

    public boolean getDatabaseNeedsSaving() {
        return this.databaseNeedsSaving;
    }
}

