/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.util;

import com._17od.upm.util.FileChangedCallback;
import java.io.File;

public class FileMonitor
implements Runnable {
    private FileChangedCallback fileChangedCallback;
    private File fileToMonitor;
    private long previousLastModified;
    private boolean paused;

    public FileMonitor(File fileToMonitor, FileChangedCallback fileChangedCallback) {
        this.fileChangedCallback = fileChangedCallback;
        this.fileToMonitor = fileToMonitor;
        this.previousLastModified = fileToMonitor.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            FileMonitor fileMonitor = this;
            synchronized (fileMonitor) {
                if (!this.paused && this.fileChanged()) {
                    this.fileChangedCallback.fileChanged(this.fileToMonitor);
                    this.paused = true;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void start() {
        this.previousLastModified = this.fileToMonitor.lastModified();
        this.paused = false;
    }

    public synchronized void pause() {
        this.paused = true;
    }

    public boolean fileChanged() {
        boolean fileModified = false;
        long currentLastModified = this.fileToMonitor.lastModified();
        if (this.previousLastModified != currentLastModified) {
            fileModified = true;
        }
        this.previousLastModified = currentLastModified;
        return fileModified;
    }
}

