/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.image.ImageObserver;
import java.io.File;

class ViewPanel
extends Panel {
    Image img;
    Image texture;
    ImageObserver iObserver;
    String str;
    Dimension dimension;

    public boolean load(File file) {
        if (this.img != null) {
            this.img.flush();
        }
        try {
            this.img = this.getToolkit().getImage(file.toString());
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.img, 1);
            mediaTracker.waitForAll();
            this.repaint();
            return true;
        }
        catch (Exception exception) {
            this.img = null;
            return false;
        }
    }

    public boolean load(byte[] byArray) {
        if (this.img != null) {
            this.img.flush();
        }
        try {
            this.img = this.getToolkit().createImage(byArray);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.img, 1);
            mediaTracker.waitForAll();
            this.repaint();
            return true;
        }
        catch (Exception exception) {
            this.img = null;
            return false;
        }
    }

    public void setImage(Image image, ImageObserver imageObserver, String string) {
        this.img = image;
        this.iObserver = imageObserver;
        this.str = string;
    }

    public void setTexture(Image image) {
        this.texture = image;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.dimension = new Dimension(n3, n4);
        super.setBounds(n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        Image image = this.createImage(this.dimension.width, this.dimension.height);
        Graphics graphics2 = image.getGraphics();
        if (graphics2 == null) {
            return;
        }
        Dimension dimension = this.dimension;
        Dimension dimension2 = new Dimension(this.texture.getWidth(this.iObserver), this.texture.getHeight(this.iObserver));
        int n2 = 0;
        while (n2 < dimension.height) {
            n = 0;
            while (n < dimension.width) {
                graphics2.drawImage(this.texture, n, n2, this.iObserver);
                n += dimension2.width;
            }
            n2 += dimension2.height;
        }
        graphics2.setColor(this.getBackground().brighter());
        graphics2.drawRect(1, 1, dimension.width - 2, dimension.height - 2);
        graphics2.setColor(this.getBackground().darker());
        graphics2.drawRect(0, 0, dimension.width - 2, dimension.height - 2);
        if (this.img != null) {
            dimension2 = new Dimension(this.img.getWidth(this.iObserver), this.img.getHeight(this.iObserver));
            n = dimension.width / 2 - dimension2.width / 2;
            int n3 = dimension.height / 2 - dimension2.height / 2;
            graphics2.fill3DRect(n - 4, n3 - 4, dimension2.width + 8, dimension2.height + 8, true);
            graphics2.drawImage(this.img, n, n3, this.iObserver);
            graphics2.drawString(this.str, n, n3 + dimension2.height + 20);
        }
        graphics2.dispose();
        graphics.drawImage(image, 0, 0, this);
    }

    ViewPanel() {
    }
}

