/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    protected int bufferPosition = 0;
    protected int bufferFilled = 0;
    protected byte[] buffer = null;
    protected static final int WRITE = 0;
    protected static final int READ = 1;
    protected int mode = 1;

    BufferedRandomAccessFile(File file, String string) throws IOException {
        super(file, string);
        this.buffer = new byte[2048];
    }

    BufferedRandomAccessFile(File file, String string, int n) throws IOException {
        super(file, string);
        this.buffer = new byte[n];
    }

    BufferedRandomAccessFile(String string, String string2) throws IOException {
        super(string, string2);
        this.buffer = new byte[2048];
    }

    BufferedRandomAccessFile(String string, String string2, int n) throws IOException {
        super(string, string2);
        this.buffer = new byte[n];
    }

    protected void fillBuffer() throws IOException {
        if (this.mode == 0) {
            this.flushBuffer();
        }
        this.mode = 1;
        if (this.bufferPosition >= this.bufferFilled) {
            this.bufferFilled = super.read(this.buffer);
            this.bufferPosition = 0;
        }
    }

    public void flushBuffer() throws IOException {
        if (this.mode == 1) {
            this.seek(this.getFilePointer());
        }
        this.mode = 0;
        if (this.bufferPosition > 0) {
            super.write(this.buffer, 0, this.bufferPosition);
        }
        this.bufferFilled = 0;
        this.bufferPosition = 0;
    }

    public long getFilePointer() throws IOException {
        if (this.mode == 1) {
            return super.getFilePointer() - (long)(this.bufferFilled - this.bufferPosition);
        }
        if (this.mode == 0) {
            return super.getFilePointer() + (long)this.bufferPosition;
        }
        return super.getFilePointer();
    }

    public long length() throws IOException {
        if (this.mode == 0) {
            return super.length() + Math.max(0L, super.getFilePointer() + 1L - super.length() + (long)this.bufferPosition);
        }
        return super.length();
    }

    public int read() throws IOException {
        this.fillBuffer();
        if (this.bufferPosition < this.bufferFilled) {
            return this.buffer[this.bufferPosition++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.readBuffered(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBuffered(byArray, n, n2);
    }

    protected int readBuffered(byte[] byArray, int n, int n2) throws IOException {
        if (this.mode == 0) {
            this.flushBuffer();
        }
        this.mode = 1;
        int n3 = this.bufferFilled - this.bufferPosition;
        if (n2 <= n3) {
            System.arraycopy(this.buffer, this.bufferPosition, byArray, n, n2);
            this.bufferPosition += n2;
            return n2;
        }
        System.arraycopy(this.buffer, this.bufferPosition, byArray, n, n3);
        this.bufferPosition += n3;
        return super.read(byArray, n + n3, n2 - n3) + n3;
    }

    public void seek(long l) throws IOException {
        if (this.mode == 0) {
            this.flushBuffer();
        } else if (this.mode == 1) {
            this.bufferFilled = 0;
            this.bufferPosition = 0;
        }
        super.seek(l);
    }

    public void write(int n) throws IOException {
        if (this.mode == 1) {
            this.seek(this.getFilePointer());
            this.mode = 0;
        } else if (this.mode == 0 && this.bufferPosition >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.bufferPosition++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBuffered(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBuffered(byArray, n, n2);
    }

    protected void writeBuffered(byte[] byArray, int n, int n2) throws IOException {
        if (this.mode == 1) {
            this.seek(this.getFilePointer());
            this.mode = 0;
        } else if (this.mode == 0 && this.buffer.length - this.bufferPosition < n2) {
            this.flushBuffer();
        }
        if (this.buffer.length - this.bufferPosition >= n2) {
            System.arraycopy(byArray, n, this.buffer, this.bufferPosition, n2);
            this.bufferPosition += n2;
        } else {
            super.write(byArray, n, n2);
        }
    }
}

