/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

public class PropertiesDialog
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Ok");
    JButton cancel = new JButton("Cancel");
    JPanel buttonPane = new JPanel();
    JCheckBox stickButton = new JCheckBox("Stick with selection");
    JTabbedPane tabbedPane = new JTabbedPane();
    JPanel dialog1Pane;
    HDataNode aNode;
    TreePath aPath;
    JTextField fileNameField;
    JTextField descField;
    JTextField dateField;
    JTextField lengthField;
    JTextField typeField;
    JTextField pathField;
    JPanel dialog2Pane;
    JTextField titleField;
    JTextField artistField;
    JTextField albumField;
    JTextField yearField;
    JTextField commentField;
    JComboBox genreList;
    JPanel dialog3Pane;
    ImageIcon thumbnail;
    JLabel thumbnailLabel;
    HDatabase database;
    JFrame mainFrame;
    HDataNode newNode;
    EventListenerList eventListeners = new EventListenerList();
    static /* synthetic */ Class class$PropertiesChangeListener;
    static /* synthetic */ Class class$PropertiesStickListener;

    public PropertiesDialog(JFrame jFrame, HDataNode hDataNode, TreePath treePath, HDatabase hDatabase) {
        super(jFrame, String.valueOf(String.valueOf(hDataNode)) + " - Properties", false);
        this.mainFrame = jFrame;
        this.aNode = this.newNode = hDataNode;
        this.aPath = treePath;
        this.database = hDatabase;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel2.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel.add(new JLabel("Filename"));
        this.fileNameField = new JTextField();
        jPanel2.add(this.fileNameField);
        jPanel.add(new JLabel("Description"));
        this.descField = new JTextField();
        jPanel2.add(this.descField);
        jPanel.add(new JLabel("Last Modified"));
        this.dateField = new JTextField();
        jPanel2.add(this.dateField);
        this.dateField.setEditable(false);
        jPanel.add(new JLabel("Length"));
        this.lengthField = new JTextField();
        jPanel2.add(this.lengthField);
        this.lengthField.setEditable(false);
        jPanel.add(new JLabel("Type"));
        this.typeField = new JTextField();
        jPanel2.add(this.typeField);
        this.typeField.setEditable(false);
        jPanel.add(new JLabel("Path"));
        this.pathField = new JTextField();
        jPanel2.add(this.pathField);
        this.pathField.setEditable(false);
        this.loadGeneral();
        this.dialog1Pane = new JPanel();
        this.dialog1Pane.setLayout(new BorderLayout(10, 10));
        this.dialog1Pane.add((Component)jPanel, "West");
        this.dialog1Pane.add((Component)jPanel2, "Center");
        this.dialog1Pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tabbedPane.addTab("General", this.dialog1Pane);
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel4.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel3.add(new JLabel("Title"));
        this.titleField = new JTextField();
        jPanel4.add(this.titleField);
        jPanel3.add(new JLabel("Artist"));
        this.artistField = new JTextField();
        jPanel4.add(this.artistField);
        jPanel3.add(new JLabel("Album"));
        this.albumField = new JTextField();
        jPanel4.add(this.albumField);
        jPanel3.add(new JLabel("Year"));
        this.yearField = new JTextField();
        jPanel4.add(this.yearField);
        jPanel3.add(new JLabel("Comment"));
        this.commentField = new JTextField();
        jPanel4.add(this.commentField);
        jPanel3.add(new JLabel("Genre"));
        ID3Tag cfr_ignored_0 = hDataNode.id3tag;
        this.genreList = new JComboBox<String>(ID3Tag.GENRES);
        jPanel4.add(this.genreList);
        ID3Tag cfr_ignored_1 = hDataNode.id3tag;
        this.genreList.setSelectedIndex(ID3Tag.GENRES.length - 1);
        this.loadID3Tag();
        this.dialog2Pane = new JPanel();
        this.dialog2Pane.setLayout(new BorderLayout(10, 10));
        this.dialog2Pane.add((Component)jPanel3, "West");
        this.dialog2Pane.add((Component)jPanel4, "Center");
        this.dialog2Pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tabbedPane.addTab("ID3 Tag", this.dialog2Pane);
        this.dialog3Pane = new JPanel();
        this.dialog3Pane.setLayout(new FlowLayout(0));
        this.thumbnailLabel = new JLabel();
        this.thumbnailLabel.setVerticalAlignment(1);
        this.thumbnailLabel.setHorizontalAlignment(2);
        this.thumbnailLabel.setVerticalTextPosition(1);
        this.dialog3Pane.add(this.thumbnailLabel);
        this.loadThumbnail();
        this.tabbedPane.addTab("Thumbnail", this.dialog3Pane);
        this.addWindowListener(new WindowAdapter(){
            boolean focusSet = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (!this.focusSet) {
                    PropertiesDialog.this.cancel.requestFocus();
                }
                this.focusSet = true;
            }

            public void windowClosing(WindowEvent windowEvent) {
                PropertiesDialog.this.fireRemoveStickDialog();
                PropertiesDialog.this.mainFrame.requestFocus();
            }
        });
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
        this.buttonPane.add(this.ok);
        this.buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.buttonPane.add(this.cancel);
        this.buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.buttonPane.add(this.stickButton);
        this.buttonPane.setAlignmentX(0.0f);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.stickButton.addActionListener(this);
        this.ok.setMnemonic(79);
        this.cancel.setMnemonic(67);
        this.stickButton.setMnemonic(83);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)this.tabbedPane, "Center");
        container.add((Component)this.buttonPane, "South");
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent var1_1) {
        block14: {
            block13: {
                var2_2 = var1_1.getActionCommand();
                if (var2_2 != "Ok") break block13;
                if (this.aNode.fileName == null && this.fileNameField.getText().length() != 0 || this.aNode.desc == null && this.descField.getText().length() != 0 || this.aNode.fileName != null && this.fileNameField.getText().equals(this.aNode.fileName) == false || this.aNode.desc != null && !this.descField.getText().equals(this.aNode.desc)) {
                    if (this.newNode == this.aNode) {
                        this.newNode = (HDataNode)this.aNode.clone();
                    }
                    this.newNode.fileName = this.fileNameField.getText();
                    this.newNode.desc = this.descField.getText();
                }
                if (this.aNode.id3tag != null) ** GOTO lbl-1000
                if (this.titleField.getText().length() != 0 || this.artistField.getText().length() != 0 || this.albumField.getText().length() != 0 || this.yearField.getText().length() != 0 || this.commentField.getText().length() != 0) ** GOTO lbl-1000
                this.aNode.id3tag;
                if (this.genreList.getSelectedIndex() != ID3Tag.GENRES.length - 1) lbl-1000:
                // 2 sources

                {
                    if (this.newNode == this.aNode) {
                        this.newNode = (HDataNode)this.aNode.clone();
                    }
                    this.newNode.id3tag = new ID3Tag();
                    this.newNode.id3tag.title = this.titleField.getText();
                    this.newNode.id3tag.artist = this.artistField.getText();
                    this.newNode.id3tag.album = this.albumField.getText();
                    this.newNode.id3tag.year = this.yearField.getText();
                    this.newNode.id3tag.comment = this.commentField.getText();
                    this.newNode.id3tag.genre = this.genreList.getSelectedIndex();
                } else if (!(this.aNode.id3tag == null || this.titleField.getText().equals(this.aNode.id3tag.title) && this.artistField.getText().equals(this.aNode.id3tag.artist) && this.albumField.getText().equals(this.aNode.id3tag.album) && this.yearField.getText().equals(this.aNode.id3tag.year) && this.commentField.getText().equals(this.aNode.id3tag.comment) && this.genreList.getSelectedIndex() == this.aNode.id3tag.genre)) {
                    if (this.newNode == this.aNode) {
                        this.newNode = (HDataNode)this.aNode.clone();
                    }
                    this.newNode.id3tag.title = this.titleField.getText();
                    this.newNode.id3tag.artist = this.artistField.getText();
                    this.newNode.id3tag.album = this.albumField.getText();
                    this.newNode.id3tag.year = this.yearField.getText();
                    this.newNode.id3tag.comment = this.commentField.getText();
                    this.newNode.id3tag.genre = this.genreList.getSelectedIndex();
                }
                if (this.newNode != this.aNode) {
                    this.fireNodeChanged();
                }
                this.dispose();
                this.fireRemoveStickDialog();
                this.mainFrame.requestFocus();
                break block14;
            }
            if (var2_2 == "Cancel") {
                this.dispose();
                this.fireRemoveStickDialog();
                this.mainFrame.requestFocus();
            } else if (var2_2 == "Stick with selection") {
                if (this.stickButton.isSelected()) {
                    this.fireAddStickDialog();
                } else {
                    this.fireRemoveStickDialog();
                }
            }
        }
    }

    public void addPropertiesChangeListener(PropertiesChangeListener propertiesChangeListener) {
        this.eventListeners.add(class$PropertiesChangeListener != null ? class$PropertiesChangeListener : (class$PropertiesChangeListener = PropertiesDialog.class$("PropertiesChangeListener")), propertiesChangeListener);
    }

    public void addPropertiesStickListener(PropertiesStickListener propertiesStickListener) {
        this.eventListeners.add(class$PropertiesStickListener != null ? class$PropertiesStickListener : (class$PropertiesStickListener = PropertiesDialog.class$("PropertiesStickListener")), propertiesStickListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        this.aNode = null;
        this.aPath = null;
        this.database = null;
        this.newNode = null;
        this.eventListeners = null;
        super.finalize();
    }

    protected void fireAddStickDialog() {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$PropertiesStickListener != null ? class$PropertiesStickListener : PropertiesDialog.class$("PropertiesStickListener"))) {
                ((PropertiesStickListener)objectArray[n + 1]).addStickDialog(this);
            }
            n -= 2;
        }
    }

    protected void fireNodeChanged() {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$PropertiesChangeListener != null ? class$PropertiesChangeListener : PropertiesDialog.class$("PropertiesChangeListener"))) {
                ((PropertiesChangeListener)objectArray[n + 1]).nodeChanged(this.aNode, this.newNode, this.aPath);
            }
            n -= 2;
        }
    }

    protected void fireRemoveStickDialog() {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$PropertiesStickListener != null ? class$PropertiesStickListener : PropertiesDialog.class$("PropertiesStickListener"))) {
                ((PropertiesStickListener)objectArray[n + 1]).removeStickDialog(this);
            }
            n -= 2;
        }
    }

    protected void loadGeneral() {
        this.fileNameField.setText(this.aNode.fileName);
        if (this.aNode.desc == null) {
            this.descField.setText("");
        } else {
            this.descField.setText(this.aNode.desc);
        }
        this.dateField.setText(DateFormat.getDateTimeInstance(0, 0).format(new Date(this.aNode.dateModified)));
        this.lengthField.setText(NumberFormat.getInstance().format(this.aNode.length));
        String string = null;
        switch (this.aNode.type) {
            case 102: {
                string = "Data File";
                break;
            }
            case 100: {
                string = "Disk Directory";
                break;
            }
            case 118: {
                string = "Disk Volume";
                break;
            }
            case 99: {
                string = "Container";
                break;
            }
            case 122: {
                string = "Zip File";
                break;
            }
        }
        this.typeField.setText(string);
        String string2 = "";
        if (this.aPath == null) {
            string2 = "/";
        } else {
            int n = 0;
            while (n < this.aPath.getPathCount()) {
                string2 = String.valueOf(string2) + "/" + this.aPath.getPathComponent(n);
                ++n;
            }
        }
        this.pathField.setText(string2);
    }

    protected void loadID3Tag() {
        if (this.aNode.id3tag != null) {
            this.titleField.setText(this.aNode.id3tag.title);
            this.artistField.setText(this.aNode.id3tag.artist);
            this.albumField.setText(this.aNode.id3tag.album);
            this.yearField.setText(this.aNode.id3tag.year);
            this.commentField.setText(this.aNode.id3tag.comment);
            ID3Tag cfr_ignored_0 = this.aNode.id3tag;
            if (this.aNode.id3tag.genre >= ID3Tag.GENRES.length) {
                ID3Tag cfr_ignored_1 = this.aNode.id3tag;
                this.genreList.setSelectedIndex(ID3Tag.GENRES.length - 1);
            } else {
                this.genreList.setSelectedIndex(this.aNode.id3tag.genre);
            }
        } else {
            this.titleField.setText("");
            this.artistField.setText("");
            this.albumField.setText("");
            this.yearField.setText("");
            this.commentField.setText("");
            ID3Tag cfr_ignored_2 = this.aNode.id3tag;
            this.genreList.setSelectedIndex(ID3Tag.GENRES.length - 1);
        }
    }

    public void loadNode(HDataNode hDataNode, TreePath treePath) {
        this.setTitle(String.valueOf(String.valueOf(hDataNode)) + " - Properties");
        this.aNode = this.newNode = hDataNode;
        this.aPath = treePath;
        this.loadGeneral();
        this.loadID3Tag();
        this.loadThumbnail();
    }

    protected void loadThumbnail() {
        try {
            if (this.database.retrieveBlob(this.aNode)) {
                this.thumbnailLabel.setIcon(new ImageIcon(this.aNode.thumbnail));
                this.thumbnailLabel.setText(String.valueOf(this.aNode.width) + "x" + this.aNode.height);
            } else {
                this.thumbnailLabel.setIcon(null);
                this.thumbnailLabel.setText("No thumbnail.");
            }
        }
        catch (IOException iOException) {
            this.thumbnailLabel.setIcon(null);
            this.thumbnailLabel.setText("No thumbnail. Error reading database.");
        }
    }

    public void removePropertiesChangeListener(PropertiesChangeListener propertiesChangeListener) {
        this.eventListeners.remove(class$PropertiesChangeListener != null ? class$PropertiesChangeListener : (class$PropertiesChangeListener = PropertiesDialog.class$("PropertiesChangeListener")), propertiesChangeListener);
    }

    public void removePropertiesStickListener(PropertiesStickListener propertiesStickListener) {
        this.eventListeners.remove(class$PropertiesStickListener != null ? class$PropertiesStickListener : (class$PropertiesStickListener = PropertiesDialog.class$("PropertiesStickListener")), propertiesStickListener);
    }

    public static void showDialog(JFrame jFrame, HDataNode hDataNode, TreePath treePath, HDatabase hDatabase, PropertiesStickListener propertiesStickListener, PropertiesChangeListener propertiesChangeListener) {
        PropertiesDialog propertiesDialog = new PropertiesDialog(jFrame, hDataNode, treePath, hDatabase);
        propertiesDialog.addPropertiesStickListener(propertiesStickListener);
        propertiesDialog.addPropertiesChangeListener(propertiesChangeListener);
        ((Component)propertiesDialog).setVisible(true);
    }
}

