/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.html.*;

public class AboutDialog extends JDialog implements ActionListener
{
   JFrame mainFrame;
   Properties options;
   JButton validSigButton, ok;

   JLabel regLabel = new JLabel();

   JLabel statusUnregLabel;

AboutDialog(JFrame frame, Properties options, JLabel statusUnregLabel)
{
   super(frame,"About Disk Indexer",true);
   mainFrame = frame;
   this.options = options;
   this.statusUnregLabel = statusUnregLabel;

   // logo

   JPanel rowPane = new JPanel();
   rowPane.setLayout(new BoxLayout(rowPane, BoxLayout.X_AXIS));
   JLabel d = new JLabel(new ImageIcon("DiskIndexer.gif"));
//   JLabel d = new JLabel("Disk Indexer");
//   Font f = d.getFont();
//   d.setFont(new Font(f.getName(),f.getStyle(),f.getSize()*3));
//   d.setForeground(Color.blue);
   d.setAlignmentY(BOTTOM_ALIGNMENT);
   rowPane.add(d);
   rowPane.add(Box.createRigidArea(new Dimension(5,0)));
   JLabel v = new JLabel(DiskIndexer.VERSION);
   v.setAlignmentY(BOTTOM_ALIGNMENT);
   rowPane.add(v);
   rowPane.setAlignmentX(LEFT_ALIGNMENT);

   // copyright
   JPanel row2Pane = new JPanel();
   row2Pane.add(new JLabel("(C) 1999-2000 "));
   JTextArea e = new JTextArea("Samuel Audet <guardia@cam.org>");
   e.setEditable(false);
   e.setOpaque(false);
   row2Pane.add(e);
   row2Pane.setAlignmentX(LEFT_ALIGNMENT);

   // registration messages

   JPanel regPane = new JPanel();
   regPane.setLayout(new FlowLayout(FlowLayout.LEFT));
   regPane.setAlignmentX(LEFT_ALIGNMENT);
   regPane.add(new JLabel("Registered to: "));
   regPane.add(regLabel);

   setRegLabel();

   // creating buttons

   ok = new JButton("Ok");
   ok.addActionListener(this);
   ok.setMnemonic(KeyEvent.VK_O);
   validSigButton = new JButton("Validate Signature...");
   validSigButton.addActionListener(this);
   validSigButton.setMnemonic(KeyEvent.VK_V);

   JPanel buttonPane = new JPanel();
   buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
   buttonPane.add(ok);
   buttonPane.add(Box.createRigidArea(new Dimension(5,0)));
   buttonPane.add(validSigButton);
   buttonPane.setAlignmentX(LEFT_ALIGNMENT);


   // putting all that together in the dialog

   JPanel dialogPane = new JPanel();
   dialogPane.setLayout(new BoxLayout(dialogPane, BoxLayout.Y_AXIS));
   dialogPane.add(rowPane);
   dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
   JTextArea t = new JTextArea("This program is Shareware. If you like this program,\n" +
                               "you should register.  If used for commercial purposes,\n" +
                               "please contact author for arrangements. Thank you!");
   t.setAlignmentX(LEFT_ALIGNMENT);
   t.setEditable(false);
   t.setOpaque(false);
   dialogPane.add(t);
   dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
   dialogPane.add(row2Pane);
   dialogPane.add(Box.createRigidArea(new Dimension(0,20)));
   dialogPane.add(regPane);
   dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
   dialogPane.add(buttonPane);

   dialogPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));


   this.getContentPane().add(dialogPane);
   this.pack();
   setLocationRelativeTo(frame);
}

private void setRegLabel()
{
   String regName = DiskIndexer.registeredTo;
   if( regName != null)
   {
      regLabel.setText(regName);
      regLabel.setForeground(Color.blue);
   }
   else
   {
      regLabel.setText("Unregistered");
      regLabel.setForeground(Color.red);
   }
}

public void actionPerformed(ActionEvent e)
{
   String command = e.getActionCommand();

   if(command == "Ok")
   {
      this.dispose();
      mainFrame.requestFocus();
   }
   else if(command == "Validate Signature...")
   {
      ValidateSignature dialog = new ValidateSignature(mainFrame);
      dialog.setVisible(true);

      if(dialog.rc)
      {
         DiskIndexer.loadRegisteredTo(mainFrame);
         setRegLabel();
         if(DiskIndexer.registeredTo == null)
            statusUnregLabel.setText("Unregistered");
         else
            statusUnregLabel.setText("");

         DiskIndexer.saveProperties();
      }
   }

}

   class ValidateSignature extends JDialog implements ActionListener
   {
      JTextField nameField = new JTextField();
      JTextArea sigField = new JTextArea(2,25);

      JButton ok = new JButton("Ok"), cancel = new JButton("Cancel");
      JPanel buttonPane = new JPanel();

      boolean rc = false;

   ValidateSignature(JFrame frame)
   {
      super(frame,"Signature Validation",true);

      String name = options.getProperty("registration.name");
      String encodedSig = options.getProperty("registration.signature");

      if(name != null) nameField.setText(name);
      nameField.setAlignmentX(LEFT_ALIGNMENT);
      if(encodedSig != null) sigField.setText(encodedSig);
      sigField.setAlignmentX(LEFT_ALIGNMENT);
      sigField.setLineWrap(true);

      buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
      buttonPane.add(ok);
      buttonPane.add(Box.createRigidArea(new Dimension(5,0)));
      buttonPane.add(cancel);
      buttonPane.setAlignmentX(LEFT_ALIGNMENT);
      ok.addActionListener(this);
      cancel.addActionListener(this);
      ok.setMnemonic(KeyEvent.VK_O);
      cancel.setMnemonic(KeyEvent.VK_C);

      JPanel dialogPane = new JPanel();
      dialogPane.setLayout(new BoxLayout(dialogPane, BoxLayout.Y_AXIS));
      dialogPane.add(new JLabel("Name"));
      dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
      dialogPane.add(nameField);
      dialogPane.add(Box.createRigidArea(new Dimension(0,10)));
      dialogPane.add(new JLabel("Signature"));
      dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
      dialogPane.add(sigField);
      dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
      dialogPane.add(buttonPane);

      dialogPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

      this.getContentPane().add(dialogPane);
      this.pack();
      setLocationRelativeTo(frame);
   }

   public void actionPerformed(ActionEvent e)
   {
      String command = e.getActionCommand();

      if(command == "Ok")
      {
         options.put("registration.name",nameField.getText().trim());
         options.put("registration.signature",sigField.getText().trim());

         rc = true;
      }
      else if(command == "Cancel")
      {

      }

      this.dispose();
   }

   }

}

