/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

/* IMPORTANT NOTE!!!!!! DO NOT USE writeBytes(String) or writeChars(String)
   AS THEY CANNOT BE OVERRIDEN (final methods) !!!  AND NEITHER CAN THE private
   METHOD writeBytes(bytes) WHICH THEY DEPEND ON. - Samuel Audet <guardia@cam.org> */

import java.io.*;

public class BufferedRandomAccessFile extends RandomAccessFile
{
   protected int bufferPosition = 0; // where to read or write the next byte
   protected int bufferFilled = 0; // how much bytes are loaded for read
   protected byte[] buffer = null;

   protected final static int WRITE = 0, READ = 1;
   protected int mode = READ;

BufferedRandomAccessFile(File file, String mode, int bufferLength) throws IOException
{
   super(file,mode);
   buffer = new byte[bufferLength];
}

BufferedRandomAccessFile(String name, String mode, int bufferLength) throws IOException
{
   super(name,mode);
   buffer = new byte[bufferLength];
}

BufferedRandomAccessFile(File file, String mode) throws IOException
{
   super(file,mode);
   buffer = new byte[2048];
}

BufferedRandomAccessFile(String name, String mode) throws IOException
{
   super(name,mode);
   buffer = new byte[2048];
}

public int read() throws IOException
{
   fillBuffer();
   if(bufferPosition < bufferFilled)
      return (int) buffer[bufferPosition++] & 0xFF;
   else
      return -1;
}

protected void fillBuffer() throws IOException
{
   if(mode == WRITE)
      flushBuffer();

   mode = READ;

   if(bufferPosition >= bufferFilled)
   {
      bufferFilled = super.read(buffer);
      bufferPosition = 0;
   }
}

public void flushBuffer() throws IOException
{
   if(mode == READ)
      seek(getFilePointer()); // doesn't do nothing

   mode = WRITE;

   if(bufferPosition > 0)
      super.write(buffer,0,bufferPosition);

   bufferFilled = 0;
   bufferPosition = 0;
}

public int read(byte b[], int off, int len) throws IOException
{
   return readBuffered(b,off,len);
}

public int read(byte b[]) throws IOException
{
   return readBuffered(b,0,b.length);
}

protected int readBuffered(byte b[], int off, int len) throws IOException
{
   if(mode == WRITE)
      flushBuffer();

   mode = READ;

   int available = (bufferFilled-bufferPosition);

   if(len <= available)
   {
      System.arraycopy(buffer,bufferPosition,b,off,len);
      bufferPosition += len;
      return len;
   }
   else
   {
      System.arraycopy(buffer,bufferPosition,b,off,available);
      bufferPosition += available;
      return super.read(b,off+available,len-available)+available;
   }
}

public void write(int b) throws IOException
{
   if(mode == READ)
   {
      seek(getFilePointer()); // doesn't do nothing
      mode = WRITE;
   }
   else if(mode == WRITE && bufferPosition >= buffer.length)
      flushBuffer();

   buffer[bufferPosition++] = (byte) b;
}

public void write(byte b[]) throws IOException
{
   writeBuffered(b,0,b.length);
}

public void write(byte b[], int off, int len) throws IOException
{
   writeBuffered(b,off,len);
}

protected void writeBuffered(byte b[], int off, int len) throws IOException
{
   if(mode == READ)
   {
      seek(getFilePointer()); // doesn't do nothing
      mode = WRITE;
   }
   else if(mode == WRITE && buffer.length - bufferPosition < len)
      flushBuffer();

   if(buffer.length - bufferPosition >= len)
   {
      System.arraycopy(b,off,buffer,bufferPosition,len);
      bufferPosition += len;
   }
   else
      super.write(b,off,len);
}


public void seek(long pos) throws IOException
{
   if(mode == WRITE)
      flushBuffer();
   else if(mode == READ)
   {
      bufferFilled = 0;
      bufferPosition = 0;
   }

   super.seek(pos);
}

public long getFilePointer() throws IOException
{
   if(mode == READ)
      return super.getFilePointer()-(bufferFilled-bufferPosition);
   else if(mode == WRITE)
      return super.getFilePointer()+bufferPosition;
   else
      return super.getFilePointer();
}

public long length() throws IOException
{
   if(mode == WRITE)
      return super.length()+Math.max(0,super.getFilePointer()+1-super.length()+bufferPosition);
   else
      return super.length();
}

}
