/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.Discogs.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.plugins.Discogs.AlbumGetter;
import net.sf.jmp3renamer.plugins.Discogs.TrackGetter;
import net.sf.jmp3renamer.plugins.Discogs.gui.TitleID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscogsPanel
extends JPanel
implements ActionListener,
KeyListener,
MouseListener,
Observer {
    private static transient Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jmp3renamer$plugins$Discogs$gui$DiscogsPanel == null ? (class$net$sf$jmp3renamer$plugins$Discogs$gui$DiscogsPanel = DiscogsPanel.class$("net.sf.jmp3renamer.plugins.Discogs.gui.DiscogsPanel")) : class$net$sf$jmp3renamer$plugins$Discogs$gui$DiscogsPanel));
    private JLabel lAlbum = new JLabel();
    private JLabel lArtist = new JLabel();
    private JScrollPane scrolltree = new JScrollPane();
    private JProgressBar progress = new JProgressBar();
    private JTextField tAlbum = new JTextField();
    private JTextField tArtist = new JTextField();
    private DefaultListModel model = new DefaultListModel();
    private JList resultList = new JList(this.model);
    static /* synthetic */ Class class$net$sf$jmp3renamer$plugins$Discogs$gui$DiscogsPanel;

    public DiscogsPanel() {
        this.initGUI();
        DataManager.getInstance().addObserver((Observer)this);
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lArtist, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tArtist, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lAlbum, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tAlbum, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.progress, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.scrolltree, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.lAlbum.setText(I18N.translate((String)"album"));
        this.lArtist.setText(I18N.translate((String)"artist"));
        this.progress.setVisible(false);
        this.scrolltree.getViewport().add((Component)this.resultList, null);
        this.tArtist.addActionListener(this);
        this.tAlbum.addActionListener(this);
        this.resultList.addMouseListener(this);
        this.resultList.addKeyListener(this);
    }

    public void setRunning() {
        this.progress.setVisible(true);
        this.progress.setStringPainted(true);
        this.progress.setString(I18N.translate((String)"getting_data"));
        this.progress.setIndeterminate(true);
        this.tAlbum.setEnabled(false);
        this.tArtist.setEnabled(false);
        this.resultList.setEnabled(false);
    }

    public void setEnded() {
        this.progress.setMinimum(0);
        this.progress.setMaximum(100);
        this.progress.setValue(100);
        this.progress.setIndeterminate(false);
        this.progress.setString(I18N.translate((String)"finished"));
        this.progress.setVisible(false);
        this.tAlbum.setEnabled(true);
        this.tArtist.setEnabled(true);
        this.resultList.setEnabled(true);
    }

    public void addResult(TitleID titleID) {
        logger.debug("Adding result {}", (Object)titleID.getTitle());
        this.model.addElement(titleID);
    }

    private void getTracks() {
        int n = this.resultList.getSelectedIndex();
        if (n >= 0) {
            TitleID titleID = (TitleID)this.model.get(n);
            new TrackGetter(this, titleID.getId());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getSource() == this.resultList && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                this.getTracks();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.resultList && keyEvent.getKeyCode() == 10) {
            this.getTracks();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public String getArtist() {
        return this.tArtist.getText();
    }

    public String getAlbum() {
        return this.tAlbum.getText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tArtist || actionEvent.getSource() == this.tAlbum) {
            this.model.removeAllElements();
            new AlbumGetter(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == DataManager.getInstance()) {
            Vector vector = (Vector)object;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                DataSet dataSet = (DataSet)iterator.next();
                if (!"".equals(dataSet.getArtist())) {
                    this.tArtist.setText(dataSet.getArtist());
                }
                if ("".equals(dataSet.getAlbum())) continue;
                this.tAlbum.setText(dataSet.getAlbum());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

