/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats;

import entagged.audioformats.AudioFile;
import entagged.audioformats.ape.MonkeyFileReader;
import entagged.audioformats.ape.MonkeyFileWriter;
import entagged.audioformats.asf.AsfFileReader;
import entagged.audioformats.asf.AsfFileWriter;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.exceptions.CannotWriteException;
import entagged.audioformats.flac.FlacFileReader;
import entagged.audioformats.flac.FlacFileWriter;
import entagged.audioformats.generic.AudioFileModificationListener;
import entagged.audioformats.generic.AudioFileReader;
import entagged.audioformats.generic.AudioFileWriter;
import entagged.audioformats.generic.ModificationHandler;
import entagged.audioformats.generic.Utils;
import entagged.audioformats.mp3.Mp3FileReader;
import entagged.audioformats.mp3.Mp3FileWriter;
import entagged.audioformats.mpc.MpcFileReader;
import entagged.audioformats.mpc.MpcFileWriter;
import entagged.audioformats.ogg.OggFileReader;
import entagged.audioformats.ogg.OggFileWriter;
import entagged.audioformats.wav.WavFileReader;
import entagged.audioformats.wav.WavFileWriter;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;

public class AudioFileIO {
    private static AudioFileIO defaultInstance;
    private final ModificationHandler modificationHandler;
    private Hashtable readers = new Hashtable();
    private Hashtable writers = new Hashtable();

    public static void delete(AudioFile audioFile) throws CannotWriteException {
        AudioFileIO.getDefaultAudioFileIO().deleteTag(audioFile);
    }

    public static AudioFileIO getDefaultAudioFileIO() {
        if (defaultInstance == null) {
            defaultInstance = new AudioFileIO();
        }
        return defaultInstance;
    }

    public static AudioFile read(File file) throws CannotReadException {
        return AudioFileIO.getDefaultAudioFileIO().readFile(file);
    }

    public static void write(AudioFile audioFile) throws CannotWriteException {
        AudioFileIO.getDefaultAudioFileIO().writeFile(audioFile);
    }

    public AudioFileIO() {
        this.modificationHandler = new ModificationHandler();
        this.prepareReadersAndWriters();
    }

    public void addAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        this.modificationHandler.addAudioFileModificationListener(audioFileModificationListener);
    }

    public void deleteTag(AudioFile audioFile) throws CannotWriteException {
        String string = Utils.getExtension(audioFile);
        Object v = this.writers.get(string);
        if (v == null) {
            throw new CannotWriteException("No Deleter associated to this extension: " + string);
        }
        ((AudioFileWriter)v).delete(audioFile);
    }

    private void prepareReadersAndWriters() {
        this.readers.put("mp3", new Mp3FileReader());
        this.readers.put("ogg", new OggFileReader());
        this.readers.put("flac", new FlacFileReader());
        this.readers.put("wav", new WavFileReader());
        this.readers.put("mpc", new MpcFileReader());
        this.readers.put("mp+", this.readers.get("mpc"));
        this.readers.put("ape", new MonkeyFileReader());
        this.readers.put("wma", new AsfFileReader());
        this.writers.put("mp3", new Mp3FileWriter());
        this.writers.put("ogg", new OggFileWriter());
        this.writers.put("flac", new FlacFileWriter());
        this.writers.put("wav", new WavFileWriter());
        this.writers.put("mpc", new MpcFileWriter());
        this.writers.put("mp+", this.writers.get("mpc"));
        this.writers.put("ape", new MonkeyFileWriter());
        this.writers.put("wma", new AsfFileWriter());
        Iterator iterator = this.writers.values().iterator();
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            audioFileWriter.setAudioFileModificationListener(this.modificationHandler);
        }
    }

    public AudioFile readFile(File file) throws CannotReadException {
        String string = Utils.getExtension(file);
        Object v = this.readers.get(string);
        if (v == null) {
            throw new CannotReadException("No Reader associated to this extension: " + string);
        }
        return ((AudioFileReader)v).read(file);
    }

    public void removeAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        this.modificationHandler.removeAudioFileModificationListener(audioFileModificationListener);
    }

    public void writeFile(AudioFile audioFile) throws CannotWriteException {
        String string = Utils.getExtension(audioFile);
        Object v = this.writers.get(string);
        if (v == null) {
            throw new CannotWriteException("No Writer associated to this extension: " + string);
        }
        ((AudioFileWriter)v).write(audioFile);
    }
}

