/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.io;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.ContentDescription;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public class ContentDescriptionReader {
    public static ContentDescription read(RandomAccessFile randomAccessFile, Chunk chunk) throws IOException {
        if (randomAccessFile == null || chunk == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_CONTENTDESCRIPTION.equals(chunk.getGuid())) {
            randomAccessFile.seek(chunk.getPosition());
            return new ContentDescriptionReader().parseData(randomAccessFile);
        }
        return null;
    }

    public static String readFixedSizeUTF16Str(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = randomAccessFile.read(byArray);
        if (n2 == byArray.length) {
            if (byArray.length >= 2 && byArray[byArray.length - 1] == 0 && byArray[byArray.length - 2] == 0) {
                byte[] byArray2 = new byte[byArray.length - 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length - 2);
                byArray = byArray2;
            }
            return new String(byArray, "UTF-16LE");
        }
        throw new IllegalStateException("Couldn't read the necessary amount of bytes.");
    }

    protected ContentDescriptionReader() {
    }

    private int[] getStringSizes(RandomAccessFile randomAccessFile) throws IOException {
        int[] nArray = new int[5];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Utils.readUINT16(randomAccessFile);
        }
        return nArray;
    }

    private ContentDescription parseData(RandomAccessFile randomAccessFile) throws IOException {
        ContentDescription contentDescription = null;
        long l = randomAccessFile.getFilePointer();
        GUID gUID = Utils.readGUID(randomAccessFile);
        if (GUID.GUID_CONTENTDESCRIPTION.equals(gUID)) {
            BigInteger bigInteger = Utils.readBig64(randomAccessFile);
            contentDescription = new ContentDescription(l, bigInteger);
            int[] nArray = this.getStringSizes(randomAccessFile);
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (nArray[i] <= 0) continue;
                stringArray[i] = ContentDescriptionReader.readFixedSizeUTF16Str(randomAccessFile, nArray[i]);
            }
            if (nArray[0] > 0) {
                contentDescription.setTitle(stringArray[0]);
            }
            if (nArray[1] > 0) {
                contentDescription.setAuthor(stringArray[1]);
            }
            if (nArray[2] > 0) {
                contentDescription.setCopyRight(stringArray[2]);
            }
            if (nArray[3] > 0) {
                contentDescription.setComment(stringArray[3]);
            }
            if (nArray[4] > 0) {
                contentDescription.setRating(stringArray[4]);
            }
        }
        return contentDescription;
    }
}

