/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.util;

import entagged.audioformats.Tag;
import entagged.audioformats.asf.data.AsfHeader;
import entagged.audioformats.asf.data.ContentDescription;
import entagged.audioformats.asf.data.ContentDescriptor;
import entagged.audioformats.asf.data.ExtendedContentDescription;
import entagged.audioformats.asf.data.wrapper.ContentDescriptorTagField;
import entagged.audioformats.asf.util.AsfCopyrightField;
import entagged.audioformats.generic.GenericTag;
import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.TagTextField;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;

public class TagConverter {
    public static void assignCommonTagValues(Tag tag, ExtendedContentDescription extendedContentDescription) {
        ContentDescriptor contentDescriptor = null;
        if (tag.getFirstAlbum() != null && tag.getFirstAlbum().length() > 0) {
            contentDescriptor = new ContentDescriptor("WM/AlbumTitle", 0);
            contentDescriptor.setStringValue(tag.getFirstAlbum());
            extendedContentDescription.addOrReplace(contentDescriptor);
        } else {
            extendedContentDescription.remove("WM/AlbumTitle");
        }
        if (tag.getFirstTrack() != null && tag.getFirstTrack().length() > 0) {
            contentDescriptor = new ContentDescriptor("WM/TrackNumber", 0);
            contentDescriptor.setStringValue(tag.getFirstTrack());
            extendedContentDescription.addOrReplace(contentDescriptor);
        } else {
            extendedContentDescription.remove("WM/TrackNumber");
        }
        if (tag.getFirstYear() != null && tag.getFirstYear().length() > 0) {
            contentDescriptor = new ContentDescriptor("WM/Year", 0);
            contentDescriptor.setStringValue(tag.getFirstYear());
            extendedContentDescription.addOrReplace(contentDescriptor);
        } else {
            extendedContentDescription.remove("WM/Year");
        }
        if (tag.getFirstGenre() != null && tag.getFirstGenre().length() > 0) {
            contentDescriptor = new ContentDescriptor("WM/Genre", 0);
            contentDescriptor.setStringValue(tag.getFirstGenre());
            extendedContentDescription.addOrReplace(contentDescriptor);
            int n = Arrays.asList(Tag.DEFAULT_GENRES).indexOf(tag.getFirstGenre());
            if (n != -1) {
                contentDescriptor = new ContentDescriptor("WM/GenreID", 0);
                contentDescriptor.setStringValue("(" + n + ")");
                extendedContentDescription.addOrReplace(contentDescriptor);
            } else {
                extendedContentDescription.remove("WM/GenreID");
            }
        } else {
            extendedContentDescription.remove("WM/Genre");
            extendedContentDescription.remove("WM/GenreID");
        }
    }

    public static void assignOptionalTagValues(Tag tag, ExtendedContentDescription extendedContentDescription) {
        Iterator iterator = tag.getFields();
        ContentDescriptor contentDescriptor = null;
        while (iterator.hasNext()) {
            try {
                TagField tagField = (TagField)iterator.next();
                if (tagField.isCommon()) continue;
                contentDescriptor = new ContentDescriptor(tagField.getId(), 0);
                if (tagField.isBinary()) {
                    contentDescriptor.setBinaryValue(tagField.getRawContent());
                } else {
                    contentDescriptor.setStringValue(((Object)tagField).toString());
                }
                extendedContentDescription.addOrReplace(contentDescriptor);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public static ContentDescription createContentDescription(Tag tag) {
        ContentDescription contentDescription = new ContentDescription();
        contentDescription.setAuthor(tag.getFirstArtist());
        contentDescription.setTitle(tag.getFirstTitle());
        contentDescription.setComment(tag.getFirstComment());
        TagTextField tagTextField = AsfCopyrightField.getCopyright(tag);
        if (tagTextField != null) {
            contentDescription.setCopyRight(tagTextField.getContent());
        }
        return contentDescription;
    }

    public static ExtendedContentDescription createExtendedContentDescription(Tag tag) {
        ExtendedContentDescription extendedContentDescription = new ExtendedContentDescription();
        TagConverter.assignCommonTagValues(tag, extendedContentDescription);
        return extendedContentDescription;
    }

    public static Tag createTagOf(AsfHeader asfHeader) {
        Object object;
        GenericTag genericTag = new GenericTag();
        if (asfHeader.getContentDescription() != null) {
            genericTag.setArtist(asfHeader.getContentDescription().getAuthor());
            genericTag.setComment(asfHeader.getContentDescription().getComment());
            genericTag.setTitle(asfHeader.getContentDescription().getTitle());
            object = new AsfCopyrightField();
            ((AsfCopyrightField)object).setContent(asfHeader.getContentDescription().getCopyRight());
            genericTag.set((TagField)object);
        }
        if (asfHeader.getExtendedContentDescription() != null) {
            genericTag.setTrack(asfHeader.getExtendedContentDescription().getTrack());
            genericTag.setYear(asfHeader.getExtendedContentDescription().getYear());
            genericTag.setGenre(asfHeader.getExtendedContentDescription().getGenre());
            genericTag.setAlbum(asfHeader.getExtendedContentDescription().getAlbum());
            object = asfHeader.getExtendedContentDescription();
            Iterator iterator = ((ExtendedContentDescription)object).getDescriptors().iterator();
            while (iterator.hasNext()) {
                ContentDescriptor contentDescriptor = (ContentDescriptor)iterator.next();
                if (contentDescriptor.isCommon()) continue;
                genericTag.add(new ContentDescriptorTagField(contentDescriptor));
            }
        }
        return genericTag;
    }
}

