/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.flac.util;

import entagged.audioformats.EncodingInfo;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.flac.util.MetadataBlockDataStreamInfo;
import entagged.audioformats.flac.util.MetadataBlockHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FlacInfoReader {
    static final /* synthetic */ boolean $assertionsDisabled;

    public EncodingInfo read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Object object;
        if (randomAccessFile.length() == 0L) {
            throw new CannotReadException("Error: File empty");
        }
        randomAccessFile.seek(0L);
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        if (!string.equals("fLaC")) {
            throw new CannotReadException("fLaC Header not found");
        }
        MetadataBlockDataStreamInfo metadataBlockDataStreamInfo = null;
        boolean bl = false;
        while (!bl) {
            byArray = new byte[4];
            randomAccessFile.read(byArray);
            object = new MetadataBlockHeader(byArray);
            if (((MetadataBlockHeader)object).getBlockType() == 0) {
                byArray = new byte[((MetadataBlockHeader)object).getDataLength()];
                randomAccessFile.read(byArray);
                metadataBlockDataStreamInfo = new MetadataBlockDataStreamInfo(byArray);
                if (metadataBlockDataStreamInfo.isValid()) break;
                throw new CannotReadException("FLAC StreamInfo not valid");
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)((MetadataBlockHeader)object).getDataLength());
            bl = ((MetadataBlockHeader)object).isLastBlock();
            object = null;
        }
        if (!$assertionsDisabled && metadataBlockDataStreamInfo == null) {
            throw new AssertionError();
        }
        object = new EncodingInfo();
        ((EncodingInfo)object).setPreciseLength(metadataBlockDataStreamInfo.getPreciseLength());
        ((EncodingInfo)object).setChannelNumber(metadataBlockDataStreamInfo.getChannelNumber());
        ((EncodingInfo)object).setSamplingRate(metadataBlockDataStreamInfo.getSamplingRate());
        ((EncodingInfo)object).setEncodingType(metadataBlockDataStreamInfo.getEncodingType());
        ((EncodingInfo)object).setExtraEncodingInfos("");
        ((EncodingInfo)object).setBitrate(this.computeBitrate(metadataBlockDataStreamInfo.getLength(), randomAccessFile.length()));
        return object;
    }

    private int computeBitrate(int n, long l) {
        return (int)(l / 1000L * 8L / (long)n);
    }

    static {
        $assertionsDisabled = !FlacInfoReader.class.desiredAssertionStatus();
    }
}

