/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.generic;

import entagged.audioformats.generic.AbstractTag;
import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.TagTextField;

public class GenericTag
extends AbstractTag {
    public static final int ALBUM = 1;
    public static final int ARTIST = 0;
    public static final int COMMENT = 6;
    public static final int GENRE = 5;
    private static final String[] keys = new String[]{"ARTIST", "ALBUM", "TITLE", "TRACK", "YEAR", "GENRE", "COMMENT"};
    public static final int TITLE = 2;
    public static final int TRACK = 3;
    public static final int YEAR = 4;

    protected TagField createAlbumField(String string) {
        return new GenericTagTextField(keys[1], string);
    }

    protected TagField createArtistField(String string) {
        return new GenericTagTextField(keys[0], string);
    }

    protected TagField createCommentField(String string) {
        return new GenericTagTextField(keys[6], string);
    }

    protected TagField createGenreField(String string) {
        return new GenericTagTextField(keys[5], string);
    }

    protected TagField createTitleField(String string) {
        return new GenericTagTextField(keys[2], string);
    }

    protected TagField createTrackField(String string) {
        return new GenericTagTextField(keys[3], string);
    }

    protected TagField createYearField(String string) {
        return new GenericTagTextField(keys[4], string);
    }

    protected String getAlbumId() {
        return keys[1];
    }

    protected String getArtistId() {
        return keys[0];
    }

    protected String getCommentId() {
        return keys[6];
    }

    protected String getGenreId() {
        return keys[5];
    }

    protected String getTitleId() {
        return keys[2];
    }

    protected String getTrackId() {
        return keys[3];
    }

    protected String getYearId() {
        return keys[4];
    }

    protected boolean isAllowedEncoding(String string) {
        return true;
    }

    private class GenericTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public GenericTagTextField(String string, String string2) {
            this.id = string;
            this.content = string2;
        }

        public void copyContent(TagField tagField) {
            if (tagField instanceof TagTextField) {
                this.content = ((TagTextField)tagField).getContent();
            }
        }

        public String getContent() {
            return this.content;
        }

        public String getEncoding() {
            return "ISO-8859-1";
        }

        public String getId() {
            return this.id;
        }

        public byte[] getRawContent() {
            return this.content == null ? new byte[]{} : this.content.getBytes();
        }

        public boolean isBinary() {
            return false;
        }

        public void isBinary(boolean bl) {
        }

        public boolean isCommon() {
            return true;
        }

        public boolean isEmpty() {
            return this.content.equals("");
        }

        public void setContent(String string) {
            this.content = string;
        }

        public void setEncoding(String string) {
        }

        public String toString() {
            return this.getId() + " : " + this.getContent();
        }
    }
}

