/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.converter;

import com.wet.wired.jsr.converter.RecordingStream;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullBufferStream;

class PlayerSourceStream
implements PullBufferStream {
    FileInputStream inStream;
    RecordingStream recordingStream;
    int width;
    int height;
    int frameRate;
    VideoFormat format;
    RenderedImage image;
    int nextImage = 0;
    boolean ended = false;

    public PlayerSourceStream(String screenRecordingFileName) throws IOException {
        this.inStream = new FileInputStream(screenRecordingFileName);
        this.recordingStream = new RecordingStream(this.inStream);
        this.width = (int)this.recordingStream.getArea().getWidth();
        this.height = (int)this.recordingStream.getArea().getHeight();
        this.frameRate = 5;
        this.format = new VideoFormat("jpeg", new Dimension(this.width, this.height), -1, Format.byteArray, (float)this.frameRate);
    }

    public boolean willReadBlock() {
        return false;
    }

    public void read(Buffer buffer) throws IOException {
        if (this.recordingStream.isFinished()) {
            System.out.println("Done reading all images.");
            buffer.setEOM(true);
            buffer.setOffset(0);
            buffer.setLength(0);
            return;
        }
        BufferedImage newImage = this.recordingStream.readFrame();
        if (newImage != null) {
            this.image = newImage;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(outputStream);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
        writer.setOutput(ios);
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionType("JPEG");
        iwp.setCompressionQuality(1.0f);
        writer.write(null, new IIOImage(this.image, null, null), iwp);
        writer.dispose();
        byte[] data = outputStream.toByteArray();
        ++this.nextImage;
        System.out.println("Processing frame: " + this.nextImage);
        buffer.setData((Object)data);
        buffer.setOffset(0);
        buffer.setLength(data.length);
        buffer.setFormat((Format)this.format);
        buffer.setFlags(buffer.getFlags() | 0x10);
    }

    public Format getFormat() {
        return this.format;
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor("raw");
    }

    public long getContentLength() {
        return 0L;
    }

    public boolean endOfStream() {
        return this.ended;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String type) {
        return null;
    }
}

