/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class IOPanel
extends JPanel
implements ActionListener {
    Component mParent;
    JButton ibrowse;
    JButton obrowse;
    JLabel sourceLabel;
    JTextField source;
    JTextField dest;
    JTextField outfile;
    JCheckBox textout;
    JCheckBox cdiout;
    JCheckBox cdrout;
    JCheckBox htmlout;

    public IOPanel(Component component) {
        this.mParent = component;
        GridLayout gridLayout = new GridLayout(5, 1);
        gridLayout.setVgap(5);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(null, "Input dir/drive", 1, 2));
        this.source = new JTextField(15);
        jPanel.add(this.source);
        this.ibrowse = new JButton("Browse");
        this.ibrowse.addActionListener(this);
        jPanel.add(this.ibrowse);
        this.source.setText(ConfigProperties.get("MP3DIR"));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, "Output dir", 1, 2));
        this.dest = new JTextField(15);
        jPanel2.add(this.dest);
        this.obrowse = new JButton("Browse");
        this.obrowse.addActionListener(this);
        jPanel2.add(this.obrowse);
        this.dest.setText(ConfigProperties.get("OUTPUTDIR"));
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(null, "Output Filename (no extension)", 1, 2));
        this.outfile = new JTextField(10);
        this.outfile.setText(ConfigProperties.get("OUTFILE"));
        jPanel3.add(this.outfile);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        GridLayout gridLayout2 = new GridLayout(4, 1);
        gridLayout.setVgap(5);
        jPanel4.setLayout(gridLayout2);
        jPanel4.setBorder(new TitledBorder(null, "Output Filetype(s)", 1, 2));
        this.textout = new JCheckBox("Text file (.txt)");
        this.cdiout = new JCheckBox("CDInsert file (.txt)", true);
        this.cdrout = new JCheckBox("CDRLabel file (.clb)");
        this.htmlout = new JCheckBox("HTML (.html)");
        jPanel4.add(this.textout);
        jPanel4.add(this.cdiout);
        jPanel4.add(this.cdrout);
        jPanel4.add(this.htmlout);
        this.textout.setSelected(ConfigProperties.getBoolean("OUTPUTTXT"));
        this.cdiout.setSelected(ConfigProperties.getBoolean("OUTPUTCDI"));
        this.cdrout.setSelected(ConfigProperties.getBoolean("OUTPUTCDR"));
        this.htmlout.setSelected(ConfigProperties.getBoolean("OUTPUTHTML"));
        this.add(jPanel4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ibrowse) {
            this.chooseDir(this.source);
        } else if (actionEvent.getSource() == this.obrowse) {
            this.chooseDir(this.dest);
        }
    }

    public String getOutputFilename() {
        return this.outfile.getText();
    }

    public String getDestDir() {
        return this.dest.getText();
    }

    public void savePage() {
        ConfigProperties.set("MP3DIR", this.source.getText());
        ConfigProperties.set("OUTPUTDIR", this.dest.getText());
        ConfigProperties.set("OUTFILE", this.outfile.getText());
        ConfigProperties.setBoolean("OUTPUTTXT", this.textout.isSelected());
        ConfigProperties.setBoolean("OUTPUTCDI", this.cdiout.isSelected());
        ConfigProperties.setBoolean("OUTPUTCDR", this.cdrout.isSelected());
        ConfigProperties.setBoolean("OUTPUTHTML", this.htmlout.isSelected());
    }

    private void chooseDir(JTextField jTextField) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Choose directory");
        jFileChooser.setCurrentDirectory(new File(jTextField.getText()));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.toString();
            jTextField.setText(string);
        }
    }
}

