/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class MP3DisplayPanel
extends JPanel
implements ActionListener {
    MP3Object[] mp3objects;
    int[] rows;
    MP3CDGUI mParent;
    JPanel leftpanel;
    JPanel rightpanel;
    JPanel otherpanel;
    JCheckBox removeTrackNumbers;
    JRadioButton trackname;
    JRadioButton trackartist;
    JRadioButton artisttrack;
    JRadioButton files;
    JRadioButton id3tag;
    boolean isGlobal;

    public MP3DisplayPanel(MP3CDGUI mP3CDGUI, boolean bl) {
        this.mParent = mP3CDGUI;
        this.isGlobal = bl;
        this.setLayout(new BorderLayout(20, 20));
        this.leftpanel = new JPanel();
        this.leftpanel.setLayout(new BoxLayout(this.leftpanel, 1));
        this.removeTrackNumbers = new JCheckBox("Remove track #s (if present)");
        this.removeTrackNumbers.addActionListener(this);
        this.leftpanel.add(this.removeTrackNumbers);
        this.files = new JRadioButton("Use Filename");
        this.files.addActionListener(this);
        this.leftpanel.add(this.files);
        this.files.addActionListener(this);
        this.rightpanel = new JPanel();
        this.rightpanel.setLayout(new BoxLayout(this.rightpanel, 1));
        this.id3tag = new JRadioButton("Use ID3 Tag");
        this.id3tag.addActionListener(this);
        this.rightpanel.add(this.id3tag);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.files);
        buttonGroup.add(this.id3tag);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(null, "Display Options", 1, 2));
        this.trackname = new JRadioButton("Trackname");
        this.trackname.addActionListener(this);
        jPanel.add(this.trackname);
        this.trackartist = new JRadioButton("Trackname-Artist");
        this.trackartist.addActionListener(this);
        jPanel.add(this.trackartist);
        this.artisttrack = new JRadioButton("Artist-Trackname");
        this.artisttrack.addActionListener(this);
        jPanel.add(this.artisttrack);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.trackname);
        buttonGroup2.add(this.trackartist);
        buttonGroup2.add(this.artisttrack);
        this.rightpanel.add(jPanel);
        this.otherpanel = new JPanel();
        this.add((Component)this.leftpanel, "North");
        this.add((Component)this.rightpanel, "Center");
        if (this.isGlobal) {
            this.removeTrackNumbers.setSelected(ConfigProperties.getBoolean("REMOVE_LEADING_TRACK"));
            this.trackname.setSelected(ConfigProperties.getBoolean("ID3_TRACKNAME"));
            this.trackartist.setSelected(ConfigProperties.getBoolean("ID3_TRACKARTIST"));
            this.artisttrack.setSelected(ConfigProperties.getBoolean("ID3_ARTISTTRACK"));
            this.files.setSelected(ConfigProperties.getBoolean("USE_FILENAME"));
            this.id3tag.setSelected(ConfigProperties.getBoolean("USE_ID3"));
            this.setTags(!this.files.isSelected());
            this.setTags(this.id3tag.isSelected());
        } else {
            this.setTags(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.files) {
            if (this.files.isSelected()) {
                this.setTags(!this.files.isSelected());
                if (!this.isGlobal) {
                    this.setUseID3(!this.files.isSelected());
                    this.setRemoveLeadingTrackNum(this.removeTrackNumbers.isSelected());
                }
            }
        } else if (actionEvent.getSource() == this.id3tag) {
            if (this.id3tag.isSelected()) {
                this.setTags(this.id3tag.isSelected());
                if (!this.isGlobal) {
                    this.setUseID3(this.id3tag.isSelected());
                }
            }
        } else if (actionEvent.getSource() == this.removeTrackNumbers) {
            if (!this.isGlobal) {
                this.setRemoveLeadingTrackNum(this.removeTrackNumbers.isSelected());
            }
        } else if (actionEvent.getSource() == this.trackartist) {
            if (!this.isGlobal) {
                this.setID3Format(1);
            }
        } else if (actionEvent.getSource() == this.artisttrack) {
            if (!this.isGlobal) {
                this.setID3Format(0);
            }
        } else if (actionEvent.getSource() == this.trackname && !this.isGlobal) {
            this.setID3Format(2);
        }
    }

    private void setUseID3(boolean bl) {
        int n = 0;
        while (n < this.rows.length) {
            this.mp3objects[n].setUseID3(bl);
            ++n;
        }
        this.mParent.setMP3Objects(this.mp3objects, this.rows);
    }

    private void setID3Format(int n) {
        int n2 = 0;
        while (n2 < this.rows.length) {
            this.mp3objects[n2].setID3Format(n);
            ++n2;
        }
        this.mParent.setMP3Objects(this.mp3objects, this.rows);
    }

    private void setRemoveLeadingTrackNum(boolean bl) {
        int n = 0;
        while (n < this.rows.length) {
            this.mp3objects[n].setRemoveLeadingTrackNum(bl);
            ++n;
        }
        this.mParent.setMP3Objects(this.mp3objects, this.rows);
    }

    private void setTags(boolean bl) {
        this.trackname.setEnabled(bl);
        this.trackartist.setEnabled(bl);
        this.artisttrack.setEnabled(bl);
    }

    public void setMP3Objects(MP3Object[] mP3ObjectArray, int[] nArray) {
        this.mp3objects = mP3ObjectArray;
        this.rows = nArray;
    }

    private void removeCharsFromDisplayString(int n) {
        int n2 = 0;
        while (n2 < this.rows.length) {
            String string = this.mp3objects[n2].getDisplayString();
            this.mp3objects[n2].setDisplayString(string.substring(n));
            ++n2;
        }
        this.mParent.setMP3Objects(this.mp3objects, this.rows);
    }

    public boolean useID3() {
        return this.id3tag.isSelected();
    }

    public boolean useFilename() {
        return this.files.isSelected();
    }

    public boolean removeTrackNums() {
        return this.removeTrackNumbers.isSelected();
    }

    public int getID3DisplayFormat() {
        if (this.artisttrack.isSelected()) {
            return 0;
        }
        if (this.trackartist.isSelected()) {
            return 1;
        }
        return 2;
    }

    public void saveValues() {
        ConfigProperties.setBoolean("REMOVE_LEADING_TRACK", this.removeTrackNumbers.isSelected());
        ConfigProperties.setBoolean("USE_FILENAME", this.files.isSelected());
        ConfigProperties.setBoolean("USE_ID3", this.id3tag.isSelected());
        ConfigProperties.setBoolean("ID3_TRACKNAME", this.trackname.isSelected());
        ConfigProperties.setBoolean("ID3_TRACKARTIST", this.trackartist.isSelected());
        ConfigProperties.setBoolean("ID3_ARTISTTRACK", this.artisttrack.isSelected());
    }

    public static void main(String[] stringArray) {
        MP3DisplayPanel mP3DisplayPanel = new MP3DisplayPanel(null, false);
        JFrame jFrame = new JFrame("TESTING");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)mP3DisplayPanel, "Center");
        jFrame.pack();
        jFrame.show();
    }
}

