/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.midi;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.io.wav.RMIFile;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.midi.MidiConfigPanel;
import de.quippy.javamod.multimedia.midi.MidiInfoPanel;
import de.quippy.javamod.multimedia.midi.MidiMixer;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JPanel;

public class MidiContainer
extends MultimediaContainer {
    private static final String[] MIDIFILEEXTENSION = new String[]{"mid", "rmf", "rmi"};
    public static final String PROPERTY_MIDIPLAYER_OUTPUTDEVICE = "javamod.player.midi.outputdevice";
    public static final String PROPERTY_MIDIPLAYER_SOUNDBANK = "javamod.player.midi.soundbankurl";
    public static final String PROPERTY_MIDIPLAYER_CAPTURE = "javamod.player.midi.capture";
    public static final String PROPERTY_MIDIPLAYER_MIXERNAME = "javamod.player.midi.mixername";
    public static final String PROPERTY_MIDIPLAYER_PORTNAME = "javamod.player.midi.portname";
    public static final String DEFAULT_OUTPUTDEVICE = "Java Sound Synthesizer";
    public static final String DEFAULT_SOUNDBANKURL = "";
    public static final String DEFAULT_CAPUTRE = "0";
    public static final String DEFAULT_MIXERNAME = "";
    public static final String DEFAULT_PORTNAME = "";
    public static final MidiDevice.Info[] MIDIOUTDEVICEINFOS = MidiContainer.getMidiOutDevices();
    public static final Mixer.Info[] MIXERDEVICEINFOS = MidiContainer.getInputMixerNames();
    private MidiConfigPanel midiConfigPanel;
    private JPanel midiInfoPanel;
    private MidiMixer currentMixer;
    private Sequence currentSequence;

    static {
        MultimediaContainerManager.registerContainer(new MidiContainer());
    }

    @Override
    public MultimediaContainer getInstance(URL uRL) {
        MultimediaContainer multimediaContainer = super.getInstance(uRL);
        this.currentSequence = this.getSequenceFromURL(uRL);
        ((MidiInfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.currentSequence, this.getSongName());
        return multimediaContainer;
    }

    private Sequence getSequenceFromURL(URL uRL) {
        Sequence sequence;
        block11: {
            String string = uRL.getPath();
            String string2 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
            if (string2.equals("rmi")) {
                return RMIFile.open(uRL);
            }
            FileOrPackedInputStream fileOrPackedInputStream = null;
            try {
                fileOrPackedInputStream = new FileOrPackedInputStream(uRL);
                sequence = MidiSystem.getSequence(fileOrPackedInputStream);
                if (fileOrPackedInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (fileOrPackedInputStream != null) {
                        try {
                            fileOrPackedInputStream.close();
                        }
                        catch (IOException iOException) {
                            Log.error("IGNORED", iOException);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throw new RuntimeException(throwable2);
                }
            }
            try {
                fileOrPackedInputStream.close();
            }
            catch (IOException iOException) {
                Log.error("IGNORED", iOException);
            }
        }
        return sequence;
    }

    @Override
    public Object[] getSongInfosFor(URL uRL) {
        String string = MultimediaContainerManager.getSongNameFromURL(uRL);
        Long l = -1L;
        try {
            Sequence sequence = this.getSequenceFromURL(uRL);
            l = sequence != null ? sequence.getMicrosecondLength() / 1000L : 0L;
        }
        catch (Throwable throwable) {}
        return new Object[]{string, l};
    }

    @Override
    public String getSongName() {
        return super.getSongName();
    }

    @Override
    public String[] getFileExtensionList() {
        return MIDIFILEEXTENSION;
    }

    @Override
    public String getName() {
        return "Midi-File";
    }

    @Override
    public boolean canExport() {
        return ((MidiConfigPanel)this.getConfigPanel()).getCapture().isSelected();
    }

    @Override
    public JPanel getConfigPanel() {
        if (this.midiConfigPanel == null) {
            this.midiConfigPanel = new MidiConfigPanel();
            this.midiConfigPanel.setParentContainer(this);
        }
        return this.midiConfigPanel;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.midiInfoPanel == null) {
            this.midiInfoPanel = new MidiInfoPanel();
        }
        return this.midiInfoPanel;
    }

    private File getSoundBankFile() {
        String string = ((MidiConfigPanel)this.getConfigPanel()).getMidiSoundBankURL().getText();
        return new File(string);
    }

    @Override
    public de.quippy.javamod.mixer.Mixer createNewMixer() {
        Mixer.Info info;
        MidiConfigPanel midiConfigPanel = (MidiConfigPanel)this.getConfigPanel();
        MidiDevice.Info info2 = MIDIOUTDEVICEINFOS[midiConfigPanel.getMidiOutputDevice().getSelectedIndex()];
        boolean bl = midiConfigPanel.getCapture().isSelected();
        int n = midiConfigPanel.getMixerInputDevice().getSelectedIndex();
        Mixer.Info info3 = info = n != -1 ? MIXERDEVICEINFOS[n] : null;
        if (bl && info == null) {
            bl = false;
        }
        this.currentMixer = new MidiMixer(this.currentSequence, info2, this.getSoundBankFile(), bl, info);
        return this.currentMixer;
    }

    @Override
    public void configurationChanged(Properties properties) {
        MidiConfigPanel midiConfigPanel = (MidiConfigPanel)this.getConfigPanel();
        midiConfigPanel.getMidiOutputDevice().setSelectedItem(MidiContainer.getMidiOutDevice(properties.getProperty(PROPERTY_MIDIPLAYER_OUTPUTDEVICE, DEFAULT_OUTPUTDEVICE)));
        midiConfigPanel.getMidiSoundBankURL().setText(properties.getProperty(PROPERTY_MIDIPLAYER_SOUNDBANK, ""));
        midiConfigPanel.getCapture().setSelected(Boolean.valueOf(properties.getProperty(PROPERTY_MIDIPLAYER_CAPTURE, DEFAULT_CAPUTRE)));
        Mixer.Info info = MidiContainer.getMixerInfo(properties.getProperty(PROPERTY_MIDIPLAYER_MIXERNAME, ""));
        if (info != null) {
            int n = 0;
            while (n < MIXERDEVICEINFOS.length) {
                if (MIXERDEVICEINFOS[n].toString().equals(info.toString())) {
                    midiConfigPanel.getMixerInputDevice().setSelectedIndex(n);
                }
                ++n;
            }
        }
    }

    @Override
    public void configurationSave(Properties properties) {
        MidiConfigPanel midiConfigPanel = (MidiConfigPanel)this.getConfigPanel();
        MidiDevice.Info info = (MidiDevice.Info)midiConfigPanel.getMidiOutputDevice().getSelectedItem();
        if (info != null) {
            properties.setProperty(PROPERTY_MIDIPLAYER_OUTPUTDEVICE, info.getName());
        }
        properties.setProperty(PROPERTY_MIDIPLAYER_SOUNDBANK, midiConfigPanel.getMidiSoundBankURL().getText());
        properties.setProperty(PROPERTY_MIDIPLAYER_CAPTURE, Boolean.toString(midiConfigPanel.getCapture().isSelected()));
        Mixer.Info info2 = (Mixer.Info)midiConfigPanel.getMixerInputDevice().getSelectedItem();
        if (info2 != null) {
            properties.setProperty(PROPERTY_MIDIPLAYER_MIXERNAME, info2.getName());
        }
    }

    private static MidiDevice.Info[] getMidiOutDevices() {
        ArrayList<MidiDevice.Info> arrayList = new ArrayList<MidiDevice.Info>();
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = 0;
        while (n < infoArray.length) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[n]);
                if (midiDevice.getMaxReceivers() != 0) {
                    arrayList.add(infoArray[n]);
                }
            }
            catch (MidiUnavailableException midiUnavailableException) {}
            ++n;
        }
        MidiDevice.Info[] infoArray2 = new MidiDevice.Info[arrayList.size()];
        arrayList.toArray(infoArray2);
        return infoArray2;
    }

    private static MidiDevice.Info getMidiOutDevice(String string) {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = 0;
        while (n < infoArray.length) {
            if (infoArray[n].getName().equalsIgnoreCase(string)) {
                return infoArray[n];
            }
            ++n;
        }
        return null;
    }

    private static Mixer.Info[] getInputMixerNames() {
        ArrayList<Mixer.Info> arrayList = new ArrayList<Mixer.Info>();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        Line.Info info = new Line.Info(TargetDataLine.class);
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            if (mixer.isLineSupported(info)) {
                arrayList.add(infoArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Mixer.Info[arrayList.size()]);
    }

    private static Mixer.Info getMixerInfo(String string) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            if (infoArray[n].getName().equalsIgnoreCase(string)) {
                return infoArray[n];
            }
            ++n;
        }
        return null;
    }

    public MidiMixer getCurrentMixer() {
        return this.currentMixer;
    }
}

