/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.prediction;

import de.quippy.jmac.prediction.IPredictorDecompress;
import de.quippy.jmac.prediction.NNFilter;
import de.quippy.jmac.prediction.NNFilter16;
import de.quippy.jmac.prediction.NNFilter256;
import de.quippy.jmac.prediction.NNFilter32;
import de.quippy.jmac.prediction.NNFilter64;
import de.quippy.jmac.tools.JMACException;
import java.util.Arrays;

public class PredictorDecompressNormal3930to3950
extends IPredictorDecompress {
    private static final int HISTORY_ELEMENTS = 8;
    private static final int WINDOW_BLOCKS = 512;
    private static final int BUFFER_COUNT = 1;
    private static final int M_COUNT = 8;
    protected int[][] m_pBuffer = new int[1][];
    protected int[] m_aryM = new int[8];
    protected int m_pInputBuffer_i;
    protected int m_pInputBuffer_j;
    protected int m_nCurrentIndex;
    protected int m_nLastValue;
    protected NNFilter m_pNNFilter;
    protected NNFilter m_pNNFilter1;

    public PredictorDecompressNormal3930to3950(int n, int n2) {
        super(n, n2);
        this.m_pBuffer[0] = new int[520];
        if (n == 1000) {
            this.m_pNNFilter = null;
            this.m_pNNFilter1 = null;
        } else if (n == 2000) {
            this.m_pNNFilter = new NNFilter16(11, n2);
            this.m_pNNFilter1 = null;
        } else if (n == 3000) {
            this.m_pNNFilter = new NNFilter64(11, n2);
            this.m_pNNFilter1 = null;
        } else if (n == 4000) {
            this.m_pNNFilter = new NNFilter256(13, n2);
            this.m_pNNFilter1 = new NNFilter32(10, n2);
        } else {
            throw new JMACException("Unknown Compression Type");
        }
    }

    @Override
    public int DecompressValue(int n, int n2) {
        int n3;
        if (this.m_nCurrentIndex == 512) {
            System.arraycopy(this.m_pBuffer[0], 512, this.m_pBuffer[0], 0, 8);
            this.m_pInputBuffer_i = 0;
            this.m_pInputBuffer_j = 8;
            this.m_nCurrentIndex = 0;
        }
        if (this.m_pNNFilter1 != null) {
            n = this.m_pNNFilter1.Decompress(n);
        }
        if (this.m_pNNFilter != null) {
            n = this.m_pNNFilter.Decompress(n);
        }
        int n4 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 1];
        int n5 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 1] - this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 2];
        int n6 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 2] - this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 3];
        int n7 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 3] - this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 4];
        this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j] = n + (n4 * this.m_aryM[0] + n5 * this.m_aryM[1] + n6 * this.m_aryM[2] + n7 * this.m_aryM[3] >> 9);
        if (n > 0) {
            this.m_aryM[0] = this.m_aryM[0] - ((n4 >> 30 & 2) - 1);
            this.m_aryM[1] = this.m_aryM[1] - ((n5 >> 30 & 2) - 1);
            this.m_aryM[2] = this.m_aryM[2] - ((n6 >> 30 & 2) - 1);
            this.m_aryM[3] = this.m_aryM[3] - ((n7 >> 30 & 2) - 1);
        } else if (n < 0) {
            this.m_aryM[0] = this.m_aryM[0] + ((n4 >> 30 & 2) - 1);
            this.m_aryM[1] = this.m_aryM[1] + ((n5 >> 30 & 2) - 1);
            this.m_aryM[2] = this.m_aryM[2] + ((n6 >> 30 & 2) - 1);
            this.m_aryM[3] = this.m_aryM[3] + ((n7 >> 30 & 2) - 1);
        }
        this.m_nLastValue = n3 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j] + (this.m_nLastValue * 31 >> 5);
        ++this.m_nCurrentIndex;
        ++this.m_pInputBuffer_j;
        return n3;
    }

    @Override
    public void Flush() {
        if (this.m_pNNFilter != null) {
            this.m_pNNFilter.Flush();
        }
        if (this.m_pNNFilter1 != null) {
            this.m_pNNFilter1.Flush();
        }
        Arrays.fill(this.m_pBuffer[0], 0, 8, 0);
        Arrays.fill(this.m_aryM, 0);
        this.m_aryM[0] = 360;
        this.m_aryM[1] = 317;
        this.m_aryM[2] = -109;
        this.m_aryM[3] = 98;
        this.m_pInputBuffer_i = 0;
        this.m_pInputBuffer_j = 8;
        this.m_nLastValue = 0;
        this.m_nCurrentIndex = 0;
    }
}

