/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.tools;

import de.quippy.jmac.tools.ByteBuffer;

public class CircleBuffer {
    private int m_nTotal = 0;
    private int m_nMaxDirectWriteBytes = 0;
    private int m_nEndCap = 0;
    private int m_nHead = 0;
    private int m_nTail = 0;
    private byte[] m_pBuffer = null;
    private ByteBuffer byteBuffer;

    public void CreateBuffer(int n, int n2) {
        this.m_nMaxDirectWriteBytes = n2;
        this.m_nTotal = n + 1 + n2;
        this.m_pBuffer = new byte[this.m_nTotal];
        this.byteBuffer = new ByteBuffer();
        this.m_nHead = 0;
        this.m_nTail = 0;
        this.m_nEndCap = this.m_nTotal;
    }

    public int MaxAdd() {
        int n = this.m_nTail >= this.m_nHead ? this.m_nTotal - 1 - this.m_nMaxDirectWriteBytes - (this.m_nTail - this.m_nHead) : this.m_nHead - this.m_nTail - 1;
        return n;
    }

    public int MaxGet() {
        return this.m_nTail >= this.m_nHead ? this.m_nTail - this.m_nHead : this.m_nEndCap - this.m_nHead + this.m_nTail;
    }

    public ByteBuffer GetDirectWritePointer() {
        this.byteBuffer.reset(this.m_pBuffer, this.m_nTail);
        return this.byteBuffer;
    }

    public void UpdateAfterDirectWrite(int n) {
        this.m_nTail += n;
        if (this.m_nTail >= this.m_nTotal - this.m_nMaxDirectWriteBytes) {
            this.m_nEndCap = this.m_nTail;
            this.m_nTail = 0;
        }
    }

    public int Get(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (byArray != null && n2 > 0) {
            int n4 = Math.min(this.m_nEndCap - this.m_nHead, n2);
            int n5 = n2 - n4;
            System.arraycopy(this.m_pBuffer, this.m_nHead, byArray, n, n4);
            n3 = n4;
            if (n5 > 0) {
                System.arraycopy(this.m_pBuffer, 0, byArray, n + n4, n5);
                n3 += n5;
            }
            this.RemoveHead(n2);
        }
        return n3;
    }

    public void Empty() {
        this.m_nHead = 0;
        this.m_nTail = 0;
        this.m_nEndCap = this.m_nTotal;
    }

    public int RemoveHead(int n) {
        n = Math.min(this.MaxGet(), n);
        this.m_nHead += n;
        if (this.m_nHead >= this.m_nEndCap) {
            this.m_nHead -= this.m_nEndCap;
        }
        return n;
    }

    public int RemoveTail(int n) {
        n = Math.min(this.MaxGet(), n);
        this.m_nTail -= n;
        if (this.m_nTail < 0) {
            this.m_nTail += this.m_nEndCap;
        }
        return n;
    }
}

