/*
 * Decompiled with CFR 0.152.
 */
package xtrememp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import xtrememp.XtremeMP;
import xtrememp.playlist.PlaylistItem;
import xtrememp.tag.TagInfo;
import xtrememp.util.Utilities;

public class MediaInfoDialog
extends JDialog
implements ActionListener {
    private JTextField locationTextField;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JLabel artistLabel;
    private JTextField artistTextField;
    private JLabel albumLabel;
    private JTextField albumTextField;
    private JLabel genreLabel;
    private JTextField genreTextField;
    private JLabel trackLabel;
    private JTextField trackTextField;
    private JLabel yearLabel;
    private JTextField yearTextField;
    private JLabel commentLabel;
    private JTextArea commentTextArea;
    private JLabel cdLabel;
    private JButton closeButton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfoDialog(PlaylistItem pli) {
        super((Frame)XtremeMP.getInstance().getMainFrame(), true);
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setTitle(Utilities.tr("Dialog.MediaInformation"));
        this.initComponents();
        Utilities.closeOnEscape(this);
        this.locationTextField.setText(pli.getLocation());
        this.locationTextField.setToolTipText(pli.getLocation());
        TagInfo tagInfo = pli.getTagInfo();
        if (tagInfo != null) {
            String comment;
            String genre;
            String album;
            String artist;
            String title = tagInfo.getTitle();
            if (!Utilities.isNullOrEmpty(title)) {
                this.titleTextField.setText(title.trim());
            }
            if (!Utilities.isNullOrEmpty(artist = tagInfo.getArtist())) {
                this.artistTextField.setText(artist.trim());
            }
            if (!Utilities.isNullOrEmpty(album = tagInfo.getAlbum())) {
                this.albumTextField.setText(album.trim());
            }
            if (!Utilities.isNullOrEmpty(genre = tagInfo.getGenre())) {
                this.genreTextField.setText(genre.trim());
            }
            if (!Utilities.isNullOrEmpty(comment = tagInfo.getComment())) {
                this.commentTextArea.setText(comment.trim());
            }
            int track = -1;
            try {
                String trackString = String.valueOf(tagInfo.getTrack());
                if (trackString.contains("/")) {
                    int separatorPosition = trackString.indexOf("/");
                    track = Integer.parseInt(trackString.substring(0, separatorPosition));
                } else {
                    track = Integer.parseInt(trackString);
                }
            }
            catch (NumberFormatException ex) {
                track = -1;
            }
            finally {
                if (track != -1) {
                    this.trackTextField.setText(String.valueOf(track));
                }
            }
            int year = -1;
            try {
                String yearString = tagInfo.getYear();
                if (yearString != null && !yearString.isEmpty()) {
                    year = Integer.parseInt(yearString);
                }
            }
            catch (NumberFormatException ex) {
                year = -1;
            }
            finally {
                if (year != -1) {
                    this.yearTextField.setText(String.valueOf(year));
                }
            }
            this.cdLabel.setText(tagInfo.getCodecDetails());
        }
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.closeButton);
        this.closeButton.requestFocusInWindow();
    }

    private void initComponents() {
        Container container = this.getContentPane();
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout("wrap", "[right,5lp:pref][500]", ""));
        northPanel.add(new JLabel(Utilities.tr("Dialog.MediaInformation.Location")));
        this.locationTextField = new JTextField();
        this.locationTextField.setEditable(false);
        northPanel.add((Component)this.locationTextField, "growx,push");
        container.add((Component)northPanel, "north");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("nogrid, fillx, aligny 100%, gapy unrel"));
        this.closeButton = new JButton(Utilities.tr("Button.Close"));
        this.closeButton.addActionListener(this);
        buttonPanel.add((Component)this.closeButton, "tag cancel");
        container.add((Component)buttonPanel, "south");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("", "[trailing][grow,fill]", ""));
        centerPanel.setBorder(BorderFactory.createTitledBorder(Utilities.tr("Dialog.MediaInformation.StandardTags")));
        this.titleLabel = new JLabel(Utilities.tr("Dialog.MediaInformation.StandardTags.Title"));
        centerPanel.add(this.titleLabel);
        this.titleTextField = new JTextField();
        centerPanel.add((Component)this.titleTextField, "span,growx");
        this.artistLabel = new JLabel(Utilities.tr("Dialog.MediaInformation.StandardTags.Artist"));
        centerPanel.add(this.artistLabel);
        this.artistTextField = new JTextField();
        centerPanel.add((Component)this.artistTextField, "span,growx");
        this.albumLabel = new JLabel(Utilities.tr("Dialog.MediaInformation.StandardTags.Album"));
        centerPanel.add(this.albumLabel);
        this.albumTextField = new JTextField();
        centerPanel.add((Component)this.albumTextField, "span,growx");
        this.genreLabel = new JLabel(Utilities.tr("Dialog.MediaInformation.StandardTags.Genre"));
        centerPanel.add(this.genreLabel);
        this.genreTextField = new JTextField();
        centerPanel.add((Component)this.genreTextField, "growx,width 100:null:null");
        this.trackLabel = new JLabel(Utilities.tr("Dialog.MediaInformation.StandardTags.Track"));
        centerPanel.add((Component)this.trackLabel, "split");
        this.trackTextField = new JTextField();
        centerPanel.add((Component)this.trackTextField, "growx,width 35:null:null");
        this.yearLabel = new JLabel(Utilities.tr("Dialog.MediaInformation.StandardTags.Year"));
        centerPanel.add((Component)this.yearLabel, "split");
        this.yearTextField = new JTextField();
        centerPanel.add((Component)this.yearTextField, "growx,wrap,width 45:null:null");
        this.commentLabel = new JLabel(Utilities.tr("Dialog.MediaInformation.StandardTags.Comment"));
        centerPanel.add(this.commentLabel);
        this.commentTextArea = new JTextArea();
        centerPanel.add((Component)new JScrollPane(this.commentTextArea), "span, growx, width min:150, height min:100");
        container.add((Component)centerPanel, "spany, grow, center");
        JPanel eastPanel = new JPanel((LayoutManager)new MigLayout("fill", "[leading]", "[top]"));
        eastPanel.setBorder(BorderFactory.createTitledBorder(Utilities.tr("Dialog.MediaInformation.CodecDetails")));
        this.cdLabel = new JLabel();
        eastPanel.add((Component)this.cdLabel, "width 150:null:null");
        container.add((Component)eastPanel, "east");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.dispose();
        }
    }
}

