/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.player.dsp;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.player.dsp.DigitalSignalProcessor;
import xtrememp.player.dsp.DssContext;

public class DigitalSignalSynchronizer
implements LineListener,
Runnable {
    private static Logger logger = LoggerFactory.getLogger(DigitalSignalSynchronizer.class);
    public static final int DEFAULT_FPS = 60;
    public static final int DEFAULT_SAMPLE_SIZE = 2048;
    private final List<DigitalSignalProcessor> dspList;
    private final ScheduledExecutorService execService;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock rLock = this.lock.readLock();
    private final Lock wLock = this.lock.writeLock();
    private final Condition writeCondition = this.wLock.newCondition();
    private ScheduledFuture schedFuture;
    private int sampleSize = 2048;
    private int framesPerSecond = 60;
    private SourceDataLine sourceDataLine;
    private ByteBuffer audioDataBuffer;
    private DssContext dssContext;

    public DigitalSignalSynchronizer() {
        this(2048, 60);
    }

    public DigitalSignalSynchronizer(int sampleSize, int framesPerSecond) {
        this.sampleSize = sampleSize;
        this.framesPerSecond = framesPerSecond;
        this.dspList = new CopyOnWriteArrayList<DigitalSignalProcessor>();
        this.execService = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DigitalSignalProcessor dsp) {
        if (dsp == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceDataLine != null) {
            dsp.init(this.sampleSize, this.sourceDataLine);
        }
        if (this.dspList.add(dsp)) {
            logger.info("DSP added");
        }
        this.wLock.lock();
        try {
            this.writeCondition.signal();
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void remove(DigitalSignalProcessor dsp) {
        if (dsp == null) {
            throw new IllegalArgumentException();
        }
        if (this.dspList.remove(dsp)) {
            logger.info("DSP removed");
        }
    }

    protected void open(SourceDataLine sdl) {
        if (this.schedFuture != null && !this.schedFuture.isCancelled()) {
            this.stop();
        }
        this.sourceDataLine = sdl;
        this.dssContext = new DssContext(this.sourceDataLine, this.sampleSize);
        this.audioDataBuffer = ByteBuffer.allocate(sdl.getBufferSize());
        for (DigitalSignalProcessor dsp : this.dspList) {
            dsp.init(this.sampleSize, this.sourceDataLine);
        }
    }

    protected void start() {
        long delay = Math.round(1000 / this.framesPerSecond);
        this.schedFuture = this.execService.scheduleWithFixedDelay(this, 0L, delay, TimeUnit.MILLISECONDS);
    }

    protected boolean isRunning() {
        if (this.schedFuture != null) {
            return !this.schedFuture.isDone();
        }
        return false;
    }

    protected void stop() {
        if (this.schedFuture != null) {
            this.schedFuture.cancel(true);
        }
    }

    protected void close() {
        if (this.schedFuture != null) {
            this.schedFuture.cancel(true);
        }
        if (this.audioDataBuffer != null) {
            this.audioDataBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAudioData(byte[] audioData, int offset, int length) {
        if (this.audioDataBuffer == null) {
            return;
        }
        this.wLock.lock();
        try {
            if (this.audioDataBuffer.remaining() < length) {
                this.audioDataBuffer.clear();
            }
            this.audioDataBuffer.put(audioData, offset, length);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.dspList.isEmpty()) {
            this.rLock.lock();
            try {
                this.dssContext.normalizeData(this.audioDataBuffer);
            }
            finally {
                this.rLock.unlock();
            }
            for (DigitalSignalProcessor dsp : this.dspList) {
                dsp.process(this.dssContext);
            }
        } else {
            this.wLock.lock();
            try {
                this.writeCondition.awaitUninterruptibly();
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(LineEvent event) {
        LineEvent.Type type = event.getType();
        this.wLock.lock();
        try {
            if (type.equals(LineEvent.Type.OPEN)) {
                this.open((SourceDataLine)event.getLine());
            } else if (type.equals(LineEvent.Type.START)) {
                this.start();
            } else if (type.equals(LineEvent.Type.STOP)) {
                this.stop();
            } else if (type.equals(LineEvent.Type.CLOSE)) {
                this.close();
            }
        }
        finally {
            this.wLock.unlock();
        }
    }
}

