/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.tag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.ogg.util.OggInfoReader;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import xtrememp.tag.TagInfo;
import xtrememp.util.Utilities;

public class OggVorbisInfo
extends TagInfo {
    protected String vendor = null;
    protected int serial = -1;
    protected int version = -1;
    protected int minbitrate = -1;
    protected int maxbitrate = -1;
    protected int averagebitrate = -1;

    @Override
    public void load(File file) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.location = file.getPath();
        try {
            AudioFile oggFile = AudioFileIO.read((File)file);
            VorbisCommentTag vcTag = (VorbisCommentTag)oggFile.getTag();
            OggInfoReader oir = new OggInfoReader();
            GenericAudioHeader gah = oir.read(new RandomAccessFile(file, "r"));
            if (gah != null) {
                this.encodingType = gah.getEncodingType();
                this.channelsAsNumber = gah.getChannelNumber();
                this.sampleRateAsNumber = gah.getSampleRateAsNumber();
                this.bitRateAsNumber = (int)gah.getBitRateAsNumber();
                this.duration = gah.getTrackLength();
            }
            if (vcTag != null) {
                this.vendor = vcTag.getVendor();
                this.title = vcTag.getFirst(FieldKey.TITLE);
                this.artist = vcTag.getFirst(FieldKey.ARTIST);
                this.album = vcTag.getFirst(FieldKey.ALBUM);
                this.year = vcTag.getFirst(FieldKey.YEAR);
                this.genre = vcTag.getFirst(FieldKey.GENRE);
                this.track = vcTag.getFirst(FieldKey.TRACK);
                this.comment = vcTag.getFirst(FieldKey.COMMENT);
            }
        }
        catch (CannotReadException ex) {
            throw new IOException(ex);
        }
        catch (TagException ex) {
            throw new UnsupportedAudioFileException("Not Ogg Vorbis audio format");
        }
        catch (ReadOnlyFileException ex) {
            throw new IOException(ex);
        }
        catch (InvalidAudioFrameException ex) {
            throw new UnsupportedAudioFileException("Not Ogg Vorbis audio format");
        }
    }

    @Override
    public void load(URL input) throws IOException, UnsupportedAudioFileException {
        this.location = input.toString();
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(input);
        this.loadInfo(aff);
        this.loadExtendedInfo(aff);
    }

    @Override
    public void load(InputStream input) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(input);
        this.loadInfo(aff);
    }

    protected void loadInfo(AudioFileFormat aff) throws UnsupportedAudioFileException {
        this.encodingType = aff.getType().toString();
        if (!this.encodingType.equalsIgnoreCase("ogg")) {
            throw new UnsupportedAudioFileException("Not Ogg Vorbis audio format");
        }
        if (aff instanceof TAudioFileFormat) {
            Map props = ((TAudioFileFormat)aff).properties();
            if (props.containsKey("ogg.channels")) {
                this.channelsAsNumber = (Integer)props.get("ogg.channels");
            }
            if (props.containsKey("ogg.frequency.hz")) {
                this.sampleRateAsNumber = (Integer)props.get("ogg.frequency.hz");
            }
            if (props.containsKey("ogg.bitrate.nominal.bps")) {
                this.bitRateAsNumber = ((Integer)props.get("ogg.bitrate.nominal.bps")).intValue();
            }
            this.averagebitrate = (int)this.bitRateAsNumber;
            if (props.containsKey("ogg.bitrate.max.bps")) {
                this.maxbitrate = (Integer)props.get("ogg.bitrate.max.bps");
            }
            if (props.containsKey("ogg.bitrate.min.bps")) {
                this.minbitrate = (Integer)props.get("ogg.bitrate.min.bps");
            }
            if (props.containsKey("ogg.version")) {
                this.version = (Integer)props.get("ogg.version");
            }
            if (props.containsKey("ogg.serial")) {
                this.serial = (Integer)props.get("ogg.serial");
            }
            if (props.containsKey("ogg.comment.encodedby")) {
                this.vendor = (String)props.get("ogg.comment.encodedby");
            }
            this.comment = "";
            if (props.containsKey("copyright")) {
                this.comment.concat((String)props.get("copyright"));
            }
            if (props.containsKey("title")) {
                this.title = (String)props.get("title");
            }
            if (props.containsKey("author")) {
                this.artist = (String)props.get("author");
            }
            if (props.containsKey("album")) {
                this.album = (String)props.get("album");
            }
            if (props.containsKey("date")) {
                this.year = (String)props.get("date");
            }
            if (props.containsKey("comment")) {
                this.comment.concat((String)props.get("comment"));
            }
            if (props.containsKey("duration")) {
                this.duration = Math.round((Long)props.get("duration") / 1000000L);
            }
            if (props.containsKey("ogg.comment.genre")) {
                this.genre = (String)props.get("ogg.comment.genre");
            }
            if (props.containsKey("ogg.comment.track")) {
                this.track = (String)props.get("ogg.comment.track");
            }
            if (props.containsKey("ogg.comment.ext.1")) {
                this.comment.concat((String)props.get("ogg.comment.ext.1"));
            }
            if (props.containsKey("ogg.comment.ext.2")) {
                this.comment.concat((String)props.get("ogg.comment.ext.2"));
            }
            if (props.containsKey("ogg.comment.ext.3")) {
                this.comment.concat((String)props.get("ogg.comment.ext.3"));
            }
        }
    }

    protected void loadExtendedInfo(AudioFileFormat aff) throws IOException, UnsupportedAudioFileException {
        this.encodingType = aff.getType().toString();
        if (!this.encodingType.equalsIgnoreCase("ogg")) {
            throw new UnsupportedAudioFileException("Not Ogg Vorbis audio format");
        }
        if (aff instanceof TAudioFileFormat) {
            // empty if block
        }
    }

    public int getSerial() {
        return this.serial;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMinBitrate() {
        return this.minbitrate;
    }

    public int getMaxBitrate() {
        return this.maxbitrate;
    }

    public int getAverageBitrate() {
        return this.averagebitrate;
    }

    public long getSize() {
        return this.size;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getCodecDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><b>Encoding Type: </b>");
        sb.append(this.getEncodingType().toUpperCase());
        sb.append("<br><b>Sampling rate: </b>");
        sb.append(this.getSampleRateAsNumber()).append(" Hz");
        sb.append("<br><b>Bitrate: </b>");
        sb.append(this.getBitRateAsNumber()).append(" Kbps");
        sb.append("<br><b>Channels: </b>");
        sb.append(this.getChannelsAsNumber());
        sb.append("<br><b>Vendor: </b>");
        sb.append(this.getVendor());
        if (this.size > 0L) {
            sb.append("<br><b>Size: </b>");
            sb.append(Utilities.byteCountToDisplaySize(this.size));
        }
        sb.append("</html>");
        return sb.toString();
    }
}

