/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.util.file;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class PlaylistFileFilter
extends FileFilter {
    public static final PlaylistFileFilter INSTANCE = new PlaylistFileFilter();
    public static final String[] PlaylistFileExt = new String[]{".xspf", ".m3u", ".pls"};

    private PlaylistFileFilter() {
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String s = file.getName().toLowerCase();
        for (String ext : PlaylistFileExt) {
            if (!s.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder description = new StringBuilder("Playlist Files");
        if (PlaylistFileExt.length > 0) {
            description.append(" (");
            for (String ext : PlaylistFileExt) {
                description.append(" *").append(ext);
            }
            description.append(" )");
        }
        return description.toString();
    }
}

